/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTool {
    public static final Date getSystemDate() {
        return DateTool.getSystemCalendar().getTime();
    }

    public static final Calendar getSystemCalendar() {
        return Calendar.getInstance();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Date getDate() {
        return this.getCalendar().getTime();
    }

    public Calendar getCalendar() {
        return Calendar.getInstance(this.getTimeZone(), this.getLocale());
    }

    public String getFormattedDate(String format) {
        return this.format(format, this.getDate());
    }

    public String format(String format, Object obj) {
        return DateTool.format(format, obj, this.getLocale());
    }

    public static String format(String format, Object obj, Locale locale) {
        Date date = DateTool.toDate(obj);
        if (date == null || format == null || locale == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, locale);
        return formatter.format(date);
    }

    public static Date toDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTime();
        }
        if (obj instanceof Long) {
            Date d = new Date();
            d.setTime((Long)obj);
            return d;
        }
        try {
            DateFormat parser = DateFormat.getInstance();
            return parser.parse(String.valueOf(obj));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date toDate(String format, Object obj) {
        return DateTool.toDate(format, obj, this.getLocale());
    }

    public static Date toDate(String format, Object obj, Locale locale) {
        Date date = DateTool.toDate(obj);
        if (date != null) {
            return date;
        }
        try {
            SimpleDateFormat parser = new SimpleDateFormat(format, locale);
            return parser.parse(String.valueOf(obj));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Calendar toCalendar(Object obj) {
        return DateTool.toCalendar(obj, this.getLocale());
    }

    public static Calendar toCalendar(Object obj, Locale locale) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Calendar) {
            return (Calendar)obj;
        }
        Date date = DateTool.toDate(obj);
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(locale);
        cal.setTime(date);
        cal.getTime();
        return cal;
    }

    public String toString() {
        return this.getDate().toString();
    }
}

