/*
 * Decompiled with CFR 0.152.
 */
package org.webtree.renderer;

import java.net.URLEncoder;
import org.apache.log4j.Category;
import org.webtree.TreeData;
import org.webtree.TreeMessage;
import org.webtree.TreeNode;
import org.webtree.TreeRenderer;
import org.webtree.TreeView;

public class HtmlRenderer
implements TreeRenderer {
    public String CELLSPACING = "0";
    public String CELLPADDING = "0";
    public String TABLEWIDTH = "600";
    public String TABLEBORDER = "0";
    public String TEXTSPACE = "&nbsp;";
    public String ICONWIDTH = "19";
    public String ICONHEIGHT = "20";
    public String CELLSTYLE = "treecell";
    public String SELECT_CELLSTYLE = "selecttreecell";
    public String[] SPECIAL_CELLSTYLE = new String[]{"boldtreecell", "italictreecell", "plaintreecell", "plaintreecell"};
    public String[] SPECIAL_COLOR = new String[]{"", "", "", ""};
    public String EMPTY_ICON = "blank.gif";
    public String T_ICON = "T.gif";
    public String I_ICON = "I.gif";
    public String L_ICON = "L.gif";
    public String TMINUS_ICON = "Tminus.gif";
    public String TPLUS_ICON = "Tplus.gif";
    public String LMINUS_ICON = "Lminus.gif";
    public String LPLUS_ICON = "Lplus.gif";
    public String MINUS_ICON = "minus.gif";
    public String PLUS_ICON = "plus.gif";
    public String MINUSFOLDER_ICON = "foldericon.gif";
    public String FOLDER_ICON = "firstfoldericon.gif";
    public String MINUSFOLDERHIGH_ICON = "foldericon_high.gif";
    public String FOLDERHIGH_ICON = "firstfoldericon_high.gif";
    public String ROOTSITE_ICON = "rootsiteicon.gif";
    public String SITE_ICON = "firstsiteicon.gif";
    public String MINUSSITE_ICON = "siteicon.gif";
    private static Category log = Category.getInstance((String)(class$org$webtree$renderer$HtmlRenderer == null ? (class$org$webtree$renderer$HtmlRenderer = HtmlRenderer.class$("org.webtree.renderer.HtmlRenderer")) : class$org$webtree$renderer$HtmlRenderer).getName());
    static /* synthetic */ Class class$org$webtree$renderer$HtmlRenderer;

    private String getImagePath(TreeView view, String iconName) {
        String themeValue = "";
        if (view.getTheme() != null) {
            themeValue = "/" + view.getTheme();
        }
        return view.getImagePath() + themeValue + "/" + iconName;
    }

    public StringBuffer showNavigation(TreeNode current, TreeView tview, int level, int childOrder, int totalSiblings, String background) throws Exception {
        log.debug((Object)"entering showNavigation()");
        StringBuffer sbuf = new StringBuffer();
        TreeNode[] children = null;
        try {
            children = current.getChildren();
        }
        catch (Exception excGetRoot) {
            System.err.println("could not get current children: " + excGetRoot);
        }
        log.debug((Object)"got children for node");
        int nChildren = children != null ? children.length : 0;
        String currentNodeId = current.getId();
        boolean selected = tview.isNodeSelected(currentNodeId);
        boolean open = tview.isNodeOpen(currentNodeId);
        boolean descend = nChildren > 0 && open;
        log.debug((Object)("node open " + currentNodeId + "? " + open));
        boolean firstChild = childOrder == 0;
        boolean lastChild = childOrder == totalSiblings - 1;
        String compositeClass = "";
        Object specialColor = null;
        StringBuffer selectURL = new StringBuffer();
        selectURL.append("<a href=\"");
        selectURL.append(tview.getSelfHref()).append("?select=").append(URLEncoder.encode(currentNodeId, "UTF8"));
        selectURL.append("\">");
        StringBuffer branchURL = new StringBuffer();
        branchURL.append("<a href=\"").append(tview.getSelfHref());
        if (descend) {
            branchURL.append("?collapse=");
            branchURL.append(currentNodeId);
        } else {
            branchURL.append("?expand=");
            branchURL.append(currentNodeId);
        }
        branchURL.append("\">");
        sbuf.append("<table width=100% cellspacing=0 cellpadding=0 border=0><tr>");
        int i = 0;
        while (i < background.length()) {
            sbuf.append("<td><img src=\"");
            if (background.charAt(i) == 'I') {
                sbuf.append(this.getImagePath(tview, this.I_ICON));
            } else {
                sbuf.append(this.getImagePath(tview, this.EMPTY_ICON));
            }
            sbuf.append("\" width=").append(this.ICONWIDTH).append(" height=").append(this.ICONHEIGHT).append(" border=0></td>");
            ++i;
        }
        sbuf.append("<td>");
        if (nChildren > 0) {
            sbuf.append(branchURL);
            sbuf.append("<img src=\"");
            if (level == 0) {
                if (descend) {
                    sbuf.append(this.getImagePath(tview, this.MINUS_ICON));
                } else {
                    sbuf.append(this.getImagePath(tview, this.PLUS_ICON));
                }
            } else if (descend) {
                if (lastChild) {
                    sbuf.append(this.getImagePath(tview, this.LMINUS_ICON));
                } else {
                    sbuf.append(this.getImagePath(tview, this.TMINUS_ICON));
                }
            } else if (lastChild) {
                sbuf.append(this.getImagePath(tview, this.LPLUS_ICON));
            } else {
                sbuf.append(this.getImagePath(tview, this.TPLUS_ICON));
            }
            sbuf.append("\" width=").append(this.ICONWIDTH).append(" height=").append(this.ICONHEIGHT).append(" border=0></a>");
        } else {
            sbuf.append("<img src=\"");
            if (lastChild) {
                sbuf.append(this.getImagePath(tview, this.L_ICON));
            } else {
                sbuf.append(this.getImagePath(tview, this.T_ICON));
            }
            sbuf.append("\" width=").append(this.ICONWIDTH).append(" height=").append(this.ICONHEIGHT).append(" border=0>");
        }
        sbuf.append("</td>");
        sbuf.append("<td>");
        sbuf.append(selectURL);
        sbuf.append("<img src=\"");
        if (descend) {
            if (selected) {
                sbuf.append(this.getImagePath(tview, this.FOLDERHIGH_ICON));
            } else {
                sbuf.append(this.getImagePath(tview, this.FOLDER_ICON));
            }
        } else if (selected) {
            sbuf.append(this.getImagePath(tview, this.MINUSFOLDERHIGH_ICON));
        } else {
            sbuf.append(this.getImagePath(tview, this.MINUSFOLDER_ICON));
        }
        sbuf.append("\" width=").append(this.ICONWIDTH).append(" height=").append(this.ICONHEIGHT).append(" border=0>");
        sbuf.append("</a></td>");
        sbuf.append("<td width=100% class=");
        if (selected) {
            sbuf.append(this.SELECT_CELLSTYLE);
        } else {
            sbuf.append(this.CELLSTYLE);
        }
        sbuf.append(">").append(this.TEXTSPACE);
        sbuf.append(selectURL);
        sbuf.append(current.getName());
        sbuf.append("</a></td></tr></table>\r\n");
        if (descend) {
            String dropDownI = " ";
            if (level > 0 && !lastChild) {
                dropDownI = "I";
            }
            int childCount = 0;
            int i2 = 0;
            while (i2 < children.length) {
                sbuf.append(this.showNavigation(children[i2], tview, level + 1, childCount, nChildren, background + dropDownI));
                ++childCount;
                ++i2;
            }
        }
        return sbuf;
    }

    private StringBuffer renderScript(TreeData tdata, TreeView tview, TreeMessage message) {
        String nodeId;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<script language=\"javascript\">");
        String string = nodeId = message != null ? message.getId() : null;
        if (nodeId != null) {
            sbuf.append("var nodeId = '").append(nodeId).append("';");
        }
        tview.processTreeMessage(message);
        switch (message != null ? message.getType() : 0) {
            case 1: {
                if (tview.getCustomCollapseListener() == null) break;
                sbuf.append(tview.getCustomCollapseListener()).append("('").append(nodeId).append("');");
                break;
            }
            case 2: {
                if (tview.getCustomExpandListener() == null) break;
                sbuf.append(tview.getCustomExpandListener()).append("('").append(nodeId).append("');");
                break;
            }
            case 3: {
                if (tview.getCustomSelectListener() == null) break;
                sbuf.append(tview.getCustomSelectListener()).append("('").append(nodeId).append("');");
            }
        }
        sbuf.append("</script>");
        return sbuf;
    }

    public String render(TreeData tdata, TreeView tview, TreeMessage message) {
        TreeNode rootNode = tdata.getRoot();
        try {
            StringBuffer sbuf = new StringBuffer();
            log.debug((Object)("operating on tree: " + rootNode.getName()));
            sbuf.append(this.renderScript(tdata, tview, message));
            TreeNode[] children = null;
            try {
                children = rootNode.getChildren();
                log.debug((Object)("got " + children.length + " children for this node"));
            }
            catch (Exception excGetRoot) {
                System.err.println("error while getting root children for tree " + rootNode.getName() + ": " + excGetRoot);
                return sbuf.toString();
            }
            int nChildren = children.length;
            log.debug((Object)("# children: " + nChildren));
            sbuf.append(this.showNavigation(rootNode, tview, 0, 0, nChildren, ""));
            return sbuf.toString();
        }
        catch (Exception excGetRoot) {
            excGetRoot.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        HtmlRenderer htmlRenderer = new HtmlRenderer();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

