/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.AsyncableElement;
import org.jbpm.gd.jpdl.util.BooleanTypeHelper;

public class AsyncableElementConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Button asyncButton;
    private AsyncableElement asyncableElement;

    public static AsyncableElementConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        AsyncableElementConfigurationComposite result = new AsyncableElementConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private AsyncableElementConfigurationComposite() {
    }

    public void setAsyncableElement(AsyncableElement asyncableElement) {
        if (this.asyncableElement == asyncableElement) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.asyncableElement = asyncableElement;
        if (asyncableElement != null) {
            this.updateControls();
            this.hookSelectionListener();
        }
    }

    private void hookSelectionListener() {
        this.asyncButton.addSelectionListener((SelectionListener)this);
    }

    private void unhookSelectionListener() {
        this.asyncButton.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.asyncButton.setSelection(false);
    }

    private void updateControls() {
        this.asyncButton.setSelection(BooleanTypeHelper.booleanValue(this.asyncableElement.getAsync()));
    }

    private void create() {
        this.asyncButton = this.widgetFactory.createButton(this.parent, "Asynchronous", 32);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.asyncButton) {
            this.asyncableElement.setAsync(this.asyncButton.getSelection() ? "true" : "false");
        }
    }
}

