/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.util;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jbpm.gd.jpdl.Constants;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.prefs.JbpmInstallation;

public class JbpmClasspathContainer
implements IClasspathContainer,
Constants {
    IClasspathEntry[] jbpmLibraryEntries;
    JbpmInstallation jbpmInstallation;
    IJavaProject javaProject = null;

    public JbpmClasspathContainer(IJavaProject javaProject, JbpmInstallation jbpmInstallation) {
        this.javaProject = javaProject;
        this.jbpmInstallation = jbpmInstallation;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.jbpmLibraryEntries == null) {
            this.jbpmLibraryEntries = this.createJbpmLibraryEntries(this.javaProject);
        }
        return this.jbpmLibraryEntries;
    }

    public String getDescription() {
        return "jBPM Library [" + this.jbpmInstallation.name + "]";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return new Path("JBPM/" + this.jbpmInstallation.name);
    }

    private IClasspathEntry[] createJbpmLibraryEntries(IJavaProject project) {
        Map jarNames = this.getJarNames();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        for (IPath jarPath : jarNames.keySet()) {
            IPath srcPath = (IPath)jarNames.get(jarPath);
            IPath srcRoot = null;
            entries.add(JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcPath, srcRoot));
        }
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    private Map getJarNames() {
        HashMap<IPath, IPath> result = new HashMap<IPath, IPath>();
        try {
            String location = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.jbpmInstallation.location);
            Path locationPath = new Path(location);
            Document document = new SAXReader().read(locationPath.append("src/resources/gpd/version.info.xml").toFile());
            XPath xpath = document.createXPath("/jbpm-version-info/classpathentry");
            List list = xpath.selectNodes((Object)document);
            int i = 0;
            while (i < list.size()) {
                Element entry = (Element)list.get(i);
                IPath sourcePath = null;
                if (entry.attribute("src") != null) {
                    sourcePath = locationPath.append((String)entry.attribute("src").getData());
                }
                result.put(locationPath.append((String)entry.attribute("path").getData()), sourcePath);
                ++i;
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (DocumentException documentException) {
        }
        catch (CoreException e) {
            Logger.logError("Problem while resolving expression", e);
        }
        return result;
    }
}

