/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.Plugin;

public class ProcessDeployer {
    private static final String boundary = "AaB03x";
    Shell shell;
    IFolder processFolder;
    String serverName;
    String serverPort;
    String serverDeployer;
    String targetLocation;
    List classesAndResources;
    List filesAndFolders;

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void setProcessFolder(IFolder processFolder) {
        this.processFolder = processFolder;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerDeployer(String serverDeployer) {
        this.serverDeployer = serverDeployer;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void setTargetLocation(String targetLocation) {
        this.targetLocation = targetLocation;
    }

    public void setClassesAndResources(List classesAndResources) {
        this.classesAndResources = classesAndResources;
    }

    public void setFilesAndFolders(List filesAndFolders) {
        this.filesAndFolders = filesAndFolders;
    }

    public boolean deploy() {
        try {
            this.showProgressMonitorDialog();
            this.showSuccessDialog();
            return true;
        }
        catch (ConnectException connectException) {
            MessageDialog dialog = new MessageDialog(this.shell, "Server Not Found", null, "The server could not be reached. Check your connection parameters.", 2, new String[]{"OK"}, 0);
            dialog.open();
            return false;
        }
        catch (Exception e) {
            this.showErrorDialog(e);
            return false;
        }
    }

    public void pingServer() {
        try {
            int read;
            URL url = new URL("http://" + this.serverName + ":" + this.serverPort + this.serverDeployer);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoOutput(true);
            InputStream inputStream = urlConnection.getInputStream();
            StringBuffer result = new StringBuffer();
            while ((read = inputStream.read()) != -1) {
                result.append((char)read);
            }
            MessageDialog dialog = new MessageDialog(this.shell, "Connection Test", null, "The server connection was successfully tested.", 2, new String[]{"OK"}, 0);
            dialog.open();
        }
        catch (ConnectException connectException) {
            MessageDialog dialog = new MessageDialog(this.shell, "Connection Test", null, "The server could not be reached.", 2, new String[]{"OK"}, 0);
            dialog.open();
        }
        catch (Exception e) {
            Logger.logError(e);
            ErrorDialog dialog = new ErrorDialog(this.shell, "Unexpected Exception", "An exception happened while testing the server connection.", (IStatus)new Status(4, Plugin.getDefault().getBundle().getSymbolicName(), 4, "An unexpected exception caused the test connection operation to fail", (Throwable)e), 4);
            dialog.open();
        }
    }

    public void saveWithoutDeploying() {
        try {
            this.saveParFile(this.createParBytes(this.getProjectClasspathUrls()));
        }
        catch (Exception e) {
            Logger.logError(e);
            ErrorDialog dialog = new ErrorDialog(this.shell, "Unexpected Exception While Saving", "An exception happened while saving the process definition archive", (IStatus)new Status(4, Plugin.getDefault().getBundle().getSymbolicName(), 4, "An unexpected exception caused the save operation to fail", (Throwable)e), 4);
            dialog.open();
        }
    }

    private void showProgressMonitorDialog() throws Exception {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.shell);
        progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                try {
                    byte[] baos = ProcessDeployer.this.createParBytes(ProcessDeployer.this.getProjectClasspathUrls());
                    if (ProcessDeployer.this.targetLocation != null) {
                        ProcessDeployer.this.saveParFile(baos);
                    }
                    ProcessDeployer.this.deployProcessWithServlet(baos);
                    return;
                }
                catch (Exception e) {
                    Logger.logError("Exception happened while deploying", e);
                    throw new InterruptedException("Error while deploying, look in the Error Log for more info");
                }
            }
        });
    }

    private void saveParFile(byte[] parBytes) throws IOException {
        File file = new Path(this.targetLocation).toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(parBytes);
        fos.close();
    }

    private void deployProcessWithServlet(byte[] parBytes) throws Exception {
        int read;
        URL url = new URL("http://" + this.serverName + ":" + this.serverPort + this.serverDeployer);
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=AaB03x");
        DataOutputStream dataOutputStream = new DataOutputStream(urlConnection.getOutputStream());
        dataOutputStream.writeBytes("--AaB03x\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"definition\"; filename=\"dummy.par\"\r\n");
        dataOutputStream.writeBytes("Content-Type: application/x-zip-compressed\r\n\r\n");
        dataOutputStream.write(parBytes);
        dataOutputStream.writeBytes("\r\n--AaB03x--\r\n");
        dataOutputStream.flush();
        dataOutputStream.close();
        InputStream inputStream = urlConnection.getInputStream();
        StringBuffer result = new StringBuffer();
        while ((read = inputStream.read()) != -1) {
            result.append((char)read);
        }
    }

    private byte[] createParBytes(URL[] urls) throws Exception {
        URLClassLoader newLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        this.addFilesAndFolders(zipOutputStream);
        this.addClassesAndResources(zipOutputStream, newLoader);
        zipOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void addFilesAndFolders(ZipOutputStream zipOutputStream) throws Exception {
        int i = 0;
        while (i < this.filesAndFolders.size()) {
            IResource resource = (IResource)this.filesAndFolders.get(i);
            int index = this.processFolder.getProjectRelativePath().toString().length() + 1;
            this.addFile(zipOutputStream, resource.getProjectRelativePath().toString().substring(index));
            ++i;
        }
    }

    private void showSuccessDialog() {
        MessageDialog dialog = new MessageDialog(this.shell, "Deployment Successful", null, "The process archive deployed successfully.", 2, new String[]{"OK"}, 0);
        dialog.open();
    }

    private void showErrorDialog(Throwable t) {
        ErrorDialog dialog = new ErrorDialog(this.shell, "Unexpected Deployment Exception", "An exception happened during the deployment of the process", (IStatus)new Status(4, Plugin.getDefault().getBundle().getSymbolicName(), 4, "An unexpected exception caused the deployment to fail", t), 4);
        dialog.open();
    }

    private void addClassesAndResources(ZipOutputStream zos, ClassLoader loader) throws CoreException, IOException {
        int i = 0;
        while (i < this.classesAndResources.size()) {
            this.addClassOrResource(zos, loader, (String)this.classesAndResources.get(i));
            ++i;
        }
    }

    private void addClassOrResource(ZipOutputStream zos, ClassLoader loader, String classOrResource) throws IOException {
        int read;
        byte[] buff = new byte[256];
        zos.putNextEntry(new ZipEntry("classes/" + classOrResource));
        InputStream is = loader.getResourceAsStream(classOrResource);
        while ((read = is.read(buff)) != -1) {
            zos.write(buff, 0, read);
        }
    }

    private void addFile(ZipOutputStream zos, String fileName) throws CoreException, IOException {
        int read;
        byte[] buff = new byte[256];
        IFile file = this.processFolder.getFile(fileName);
        if (!file.exists()) {
            return;
        }
        InputStream is = file.getContents();
        zos.putNextEntry(new ZipEntry(fileName));
        while ((read = is.read(buff)) != -1) {
            zos.write(buff, 0, read);
        }
    }

    private URL[] getProjectClasspathUrls() throws CoreException, MalformedURLException {
        IProject project = this.processFolder.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String[] pathArray = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        URL[] urls = new URL[pathArray.length];
        int i = 0;
        while (i < pathArray.length) {
            urls[i] = new File(pathArray[i]).toURI().toURL();
            ++i;
        }
        return urls;
    }
}

