/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class JPAContext {
    public static final String APPLICATION_PERSISTENCE_UNIT = "com.tandbergtv.watchpoint.studio";
    private static final JPAContext CONTEXT = new JPAContext();
    private EntityManagerFactory entityManagerFactory = null;
    private boolean initialized = false;

    private JPAContext() {
    }

    public static synchronized JPAContext getContext() {
        return CONTEXT;
    }

    public synchronized void initializeContext() {
        if (this.initialized) {
            return;
        }
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)APPLICATION_PERSISTENCE_UNIT);
        this.initialized = true;
    }

    public synchronized void closeContext() {
        if (!this.initialized) {
            return;
        }
        this.entityManagerFactory.close();
        this.entityManagerFactory = null;
        this.initialized = false;
    }

    public synchronized EntityManagerFactory getEntityManagerFactory() {
        if (!this.initialized) {
            String msg = "The JPAContext has not been initialized.";
            throw new IllegalStateException(msg);
        }
        return this.entityManagerFactory;
    }
}

