/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessFactory;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ProtectionKeyDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.StudioLockDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.MessagePDAO;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.NodeDefinitionDTOPDAO;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.ProtectionKeyPDAO;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.ResourceGroupPDAO;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.ResourceTypePDAO;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.StudioLockPDAO;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.WorkflowTemplateDTOPDAO;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPADataAccessFactory
extends DataAccessFactory {
    @Override
    public <DO extends IPersistable, DOK extends Serializable> DataAccessInterface<DO, DOK> createDataAccessObject(DO entity, IPersistenceContext context) {
        Class<?> entityClass = entity.getClass();
        return this.createDataAccessObject(entityClass, context);
    }

    @Override
    public <DO extends IPersistable, DOK extends Serializable> DataAccessInterface<DO, DOK> createDataAccessObject(Class<DO> entityClass, IPersistenceContext context) {
        String entityClassName = entityClass.getName();
        String daoClassName = null;
        try {
            String simpleEntityClassName = entityClass.getSimpleName();
            String daoPackageName = this.getClass().getPackage().getName();
            daoClassName = String.valueOf(daoPackageName) + "." + simpleEntityClassName + "PDAO";
            Class<?> clazz = Class.forName(daoClassName);
            Object instance = clazz.getConstructor(context.getClass()).newInstance(context);
            return (DataAccessInterface)instance;
        }
        catch (Exception ex) {
            String errMsg = "Failed to instantiate JPA Data Access Object: " + daoClassName + " for entity class: " + entityClassName;
            throw new StudioRuntimeException(errMsg, ex);
        }
    }

    @Override
    public ResourceTypeDAI getResourceTypeDAO(IPersistenceContext context) {
        return new ResourceTypePDAO((JPAPersistenceContext)context);
    }

    @Override
    public MessageDAI getMessageDAO(IPersistenceContext context) {
        return new MessagePDAO((JPAPersistenceContext)context);
    }

    @Override
    public ResourceGroupDAI getResourceGroupDAO(IPersistenceContext context) {
        return new ResourceGroupPDAO((JPAPersistenceContext)context);
    }

    @Override
    public ProtectionKeyDAI getProtectionKeyDAO(IPersistenceContext context) {
        return new ProtectionKeyPDAO((JPAPersistenceContext)context);
    }

    @Override
    public NodeDefinitionDTODAI getNodeDefinitionDTODAO(IPersistenceContext context) {
        return new NodeDefinitionDTOPDAO((JPAPersistenceContext)context);
    }

    @Override
    public WorkflowTemplateDTODAI getWorkflowTemplateDTODAO(IPersistenceContext context) {
        return new WorkflowTemplateDTOPDAO((JPAPersistenceContext)context);
    }

    @Override
    public StudioLockDAI getStudioLockDAO(IPersistenceContext context) {
        return new StudioLockPDAO((JPAPersistenceContext)context);
    }
}

