/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;

public class JPAPersistenceContext
implements IPersistenceContext {
    private EntityManagerFactory factory;
    private EntityManager entityManager;
    private LockModeType lockMode = LockModeType.READ;

    public JPAPersistenceContext(EntityManagerFactory entityManagerFactory) {
        this.factory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public LockModeType getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(LockModeType lockMode) {
        if (lockMode == null) {
            lockMode = LockModeType.READ;
        }
        this.lockMode = lockMode;
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.entityManager = this.factory.createEntityManager();
    }

    public void close() {
        if (!this.isInitialized()) {
            return;
        }
        this.entityManager.close();
        this.entityManager = null;
    }

    protected boolean isInitialized() {
        return this.entityManager != null && this.entityManager.isOpen();
    }

    public void beginTransaction() {
        this.entityManager.getTransaction().begin();
    }

    public void commitTransaction() {
        this.entityManager.getTransaction().commit();
    }

    public void rollbackTransaction() {
        this.entityManager.getTransaction().rollback();
    }

    public EntityTransaction getCurrentTransaction() {
        return this.entityManager.getTransaction();
    }
}

