/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.PersistenceDAO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionDTOPDAO
extends PersistenceDAO<NodeDefinitionDTO, Long>
implements NodeDefinitionDTODAI {
    public NodeDefinitionDTOPDAO(JPAPersistenceContext persistenceContext) {
        super(NodeDefinitionDTO.class, persistenceContext);
    }

    @Override
    public List<NodeDefinitionDTO> findAll() {
        String queryName = "NodeDefinitionDTO.All";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public List<NodeDefinitionDTO> findByResourceType(long resourceTypeId) {
        String queryName = "NodeDefinitionDTO.ByResourceType";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public List<NodeDefinitionDTO> findSingleNodeDefinitionsByResourceType(long resourceTypeId) {
        String queryName = "NodeDefinitionDTO.SingleNodeDefinitionsByResourceType";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public List<NodeDefinitionDTO> findByParentUsage(long nodeDefinitionId) {
        String queryName = "NodeDefinitionDTO.ByParentUsage";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("nodeDefinitionId", (Object)nodeDefinitionId);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public List<NodeDefinitionDTO> findSuperStateNodeDefinitionsByMessages(Set<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return new ArrayList<NodeDefinitionDTO>();
        }
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT nd.id, message.id ");
        queryBuf.append(this.getFromClause()).append(" nd, ");
        queryBuf.append("IN (nd.messages) message ");
        queryBuf.append("WHERE nd.id in (");
        boolean first = true;
        for (Message message : messages) {
            if (first) {
                first = false;
            } else {
                queryBuf.append(" and nd.id in (");
            }
            queryBuf.append("SELECT nd.id ");
            queryBuf.append(this.getFromClause()).append(" nd, ");
            queryBuf.append("IN (nd.messages) message ");
            queryBuf.append("WHERE nd.type = 1 AND message.id = ").append(message.getId());
        }
        int i = 1;
        while (i < messages.size()) {
            queryBuf.append(")");
            ++i;
        }
        queryBuf.append(")");
        Query query = this.getEntityManager().createQuery(queryBuf.toString());
        Map<Long, Set<Long>> ndMessagesMap = this.buildNodeDefMessageMapping(query.getResultList());
        ArrayList<NodeDefinitionDTO> nodeDefinitions = new ArrayList<NodeDefinitionDTO>();
        for (Map.Entry<Long, Set<Long>> ndMessagesMapEntry : ndMessagesMap.entrySet()) {
            Long nodeDefID = ndMessagesMapEntry.getKey();
            Set<Long> mappedMessages = ndMessagesMapEntry.getValue();
            if (!this.isSameSetOfMessages(mappedMessages, messages)) continue;
            NodeDefinitionDTO nodeDefinition = new NodeDefinitionDTO();
            nodeDefinition.setId(nodeDefID);
            nodeDefinitions.add(nodeDefinition);
        }
        return nodeDefinitions;
    }

    @Override
    public List<NodeDefinitionDTO> findSingleNodeDefinitionsByMessage(long id) {
        String queryName = "NodeDefinitionDTO.SingleNodeDefinitionsByMessage";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("id", (Object)id);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public int getCountByParentUsage(long nodeDefinitionId) {
        String queryName = "NodeDefinitionDTO.CountByParentUsage";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("nodeDefinitionId", (Object)nodeDefinitionId);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    @Override
    public int getCountByResourceType(long resourceTypeId) {
        String queryName = "NodeDefinitionDTO.CountByResourceType";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    @Override
    public int getCountByMessage(long messageId) {
        String queryName = "NodeDefinitionDTO.CountByMessage";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("messageId", (Object)messageId);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    @Override
    public List<NodeDefinitionDTO> findByKeys(Collection<Long> keys) {
        if (keys == null || keys.size() == 0) {
            return new ArrayList<NodeDefinitionDTO>();
        }
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT nd.id, nd.name ");
        queryBuf.append(this.getFromClause()).append(" nd ");
        queryBuf.append("WHERE nd.id IN ( ");
        boolean first = true;
        for (Long key : keys) {
            if (!first) {
                queryBuf.append(", ");
            } else {
                first = false;
            }
            queryBuf.append(key.toString());
        }
        queryBuf.append(" ) ");
        Query query = this.getEntityManager().createQuery(queryBuf.toString());
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public int getCountByName(String name) {
        String queryName = "NodeDefinitionDTO.CountByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    @Override
    public void deleteNodeDefinitionReferences(long nodeDefinitionId) {
        String sqlQuery = "DELETE TB_NODEDEFINITIONPARENTMAP WHERE NODEDEFINITIONID= :nodeDefinitionId";
        Query query = this.getEntityManager().createNativeQuery(sqlQuery);
        query.setParameter("nodeDefinitionId", (Object)nodeDefinitionId);
        query.executeUpdate();
    }

    private List<NodeDefinitionDTO> buildNodeDefinitions(List<?> data) {
        ArrayList<NodeDefinitionDTO> nodeDefinitions = new ArrayList<NodeDefinitionDTO>();
        if (data != null) {
            for (Object dataObject : data) {
                Object[] columns = (Object[])dataObject;
                NodeDefinitionDTO nodeDefinition = new NodeDefinitionDTO();
                nodeDefinition.setResourceType(new ResourceType());
                int i = 0;
                while (i < columns.length) {
                    switch (i) {
                        case 0: {
                            nodeDefinition.setId((Long)columns[0]);
                            break;
                        }
                        case 1: {
                            nodeDefinition.setName((String)columns[1]);
                            break;
                        }
                        case 2: {
                            nodeDefinition.setType((NodeDefinitionType)columns[2]);
                            break;
                        }
                        case 3: {
                            nodeDefinition.getResourceType().setId((Long)columns[3]);
                            break;
                        }
                        case 4: {
                            nodeDefinition.getResourceType().setName((String)columns[4]);
                            break;
                        }
                        case 5: {
                            nodeDefinition.getResourceType().setOutOfTheBox((Boolean)columns[5]);
                            break;
                        }
                        case 6: {
                            nodeDefinition.setLock((ILock)columns[6]);
                        }
                    }
                    ++i;
                }
                nodeDefinitions.add(nodeDefinition);
            }
        }
        return nodeDefinitions;
    }

    private Map<Long, Set<Long>> buildNodeDefMessageMapping(List<?> data) {
        HashMap<Long, Set<Long>> ndMessagesMap = new HashMap<Long, Set<Long>>();
        if (data != null) {
            for (Object dataObject : data) {
                Object[] columns = (Object[])dataObject;
                Long nodeDefID = (Long)columns[0];
                Long messageID = (Long)columns[1];
                HashSet<Long> messages = (HashSet<Long>)ndMessagesMap.get(nodeDefID);
                if (messages == null) {
                    messages = new HashSet<Long>();
                    ndMessagesMap.put(nodeDefID, messages);
                }
                messages.add(messageID);
            }
        }
        return ndMessagesMap;
    }

    private boolean isSameSetOfMessages(Set<Long> messageIDs, Set<Message> messages) {
        if (messageIDs.size() == messages.size()) {
            for (Message message : messages) {
                if (messageIDs.contains(message.getId())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

