/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceDAO<EC extends IPersistable, EKC extends Serializable>
implements DataAccessInterface<EC, EKC> {
    private Class<EC> entityClass;
    private JPAPersistenceContext context;

    protected PersistenceDAO(Class<EC> entityClass, JPAPersistenceContext persistenceContext) {
        this.entityClass = entityClass;
        this.context = persistenceContext;
    }

    @Override
    public EC create(EC entity) {
        this.getEntityManager().persist(entity);
        return entity;
    }

    @Override
    public EC update(EC entity) {
        return (EC)((IPersistable)this.getEntityManager().merge(entity));
    }

    @Override
    public void delete(EKC key) {
        EC entity = this.find(key);
        if (entity != null) {
            this.getEntityManager().remove(entity);
        }
    }

    @Override
    public EC find(EKC key) {
        return (EC)((IPersistable)this.getEntityManager().find(this.getEntityClass(), key));
    }

    @Override
    public List<EC> findAll() {
        String queryString = "SELECT entity " + this.getFromClause() + " entity";
        Query query = this.getEntityManager().createQuery(queryString);
        return query.getResultList();
    }

    @Override
    public EC lock(EKC key) {
        EC entity = this.find(key);
        if (entity != null) {
            this.getEntityManager().lock(entity, this.getPersistenceContext().getLockMode());
            this.refresh(entity);
        }
        return entity;
    }

    protected void refresh(EC entity) {
        this.getEntityManager().refresh(entity);
    }

    @Override
    public JPAPersistenceContext getPersistenceContext() {
        return this.context;
    }

    protected Object getSingleResultOrNull(Query query) {
        try {
            return query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    protected EntityManager getEntityManager() {
        if (this.context == null || !this.context.isInitialized()) {
            String msg = "The Persistence Context has not been initialized, cannot perform data operation.";
            throw new IllegalStateException(msg);
        }
        return this.context.getEntityManager();
    }

    protected Class<EC> getEntityClass() {
        return this.entityClass;
    }

    protected String getFromClause() {
        return "FROM " + this.getEntityClass().getName();
    }
}

