/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.PersistenceDAO;
import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupPDAO
extends PersistenceDAO<ResourceGroup, Long>
implements ResourceGroupDAI {
    public ResourceGroupPDAO(JPAPersistenceContext persistenceContext) {
        super(ResourceGroup.class, persistenceContext);
    }

    @Override
    public List<ResourceGroup> findByResourceType(long resourceTypeId) {
        String queryName = "ResourceGroup.ByResourceType";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        return this.buildResourceGroups(query.getResultList());
    }

    @Override
    public List<ResourceGroup> findByResourceTypeSystemId(String systemId) {
        String queryName = "ResourceGroup.ByResourceTypeSystemId";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("systemId", (Object)systemId);
        return this.buildResourceGroups(query.getResultList());
    }

    @Override
    public List<ResourceGroup> findByNames(Collection<String> names) {
        if (names == null || names.isEmpty()) {
            return new ArrayList<ResourceGroup>();
        }
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT rg.id, rg.name ");
        queryBuf.append(this.getFromClause()).append(" rg ");
        queryBuf.append("WHERE rg.name IN ( ");
        boolean first = true;
        for (String name : names) {
            if (!first) {
                queryBuf.append(", ");
            } else {
                first = false;
            }
            queryBuf.append("'" + name + "'");
        }
        queryBuf.append(" ) ");
        Query query = this.getEntityManager().createQuery(queryBuf.toString());
        return this.buildResourceGroups(query.getResultList());
    }

    @Override
    public ResourceGroup findByName(String name) {
        String queryName = "ResourceGroup.ByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        return (ResourceGroup)query.getSingleResult();
    }

    @Override
    public ProtectionKey findProtectionKeyByName(String name) {
        String queryName = "ResourceGroup.ProtectionKeyByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        return (ProtectionKey)query.getSingleResult();
    }

    @Override
    public List<String> getAllFunctionalTypesForResourceType(long resourceTypeId) {
        String queryName = "ResourceGroup.FunctionalTypeByResourceType";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        return this.convertObjectListToStringList(query.getResultList(), true);
    }

    @Override
    public boolean isNameExists(String name) {
        String queryName = "ResourceGroup.CountByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        Long count = (Long)query.getSingleResult();
        return count > 0L;
    }

    @Override
    public int getCountByResourceType(long resourceTypeId) {
        String queryName = "ResourceGroup.CountByResourceType";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    private List<ResourceGroup> buildResourceGroups(List<?> data) {
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>();
        if (data != null) {
            for (Object dataObject : data) {
                Object[] columns = (Object[])dataObject;
                ResourceGroup resourceGroup = new ResourceGroup();
                resourceGroup.setResourceType(new ResourceType());
                int i = 0;
                while (i < columns.length) {
                    switch (i) {
                        case 0: {
                            resourceGroup.setId((Long)columns[0]);
                            break;
                        }
                        case 1: {
                            resourceGroup.setName((String)columns[1]);
                            break;
                        }
                        case 2: {
                            resourceGroup.setDescription((String)columns[2]);
                            break;
                        }
                        case 3: {
                            resourceGroup.setFunctionalType((String)columns[3]);
                            break;
                        }
                        case 4: {
                            resourceGroup.setInternallyAcquired((Boolean)columns[4]);
                            break;
                        }
                        case 5: {
                            resourceGroup.setProtectionKey((ProtectionKey)columns[5]);
                            break;
                        }
                        case 6: {
                            resourceGroup.getResourceType().setId((Long)columns[6]);
                            break;
                        }
                        case 7: {
                            resourceGroup.getResourceType().setName((String)columns[7]);
                        }
                    }
                    ++i;
                }
                resourceGroups.add(resourceGroup);
            }
        }
        return resourceGroups;
    }

    private List<String> convertObjectListToStringList(List<?> objList, boolean ignoreNulls) {
        ArrayList<String> result = new ArrayList<String>();
        if (objList != null) {
            for (Object obj : objList) {
                if (ignoreNulls) {
                    if (obj == null) continue;
                    result.add((String)obj);
                    continue;
                }
                result.add((String)obj);
            }
        }
        return result;
    }
}

