/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.PersistenceDAO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.ResourceTypeParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypePDAO
extends PersistenceDAO<ResourceType, Long>
implements ResourceTypeDAI {
    private static final Logger logger = Logger.getLogger(ResourceType.class);

    public ResourceTypePDAO(JPAPersistenceContext persistenceContext) {
        super(ResourceType.class, persistenceContext);
    }

    @Override
    public ResourceType create(ResourceType entity) {
        return this.fetchLazyLoadedCollections(super.create(entity));
    }

    @Override
    public ResourceType update(ResourceType entity) {
        List<ResourceTypeParameter> currentParameters = this.getParametersById(entity.getId());
        Map<ParameterMapKey, ResourceTypeParameter> parameterMap = this.buildParameterMap(entity);
        ParameterMapKey mapKey = new ParameterMapKey(null);
        Iterator<ResourceTypeParameter> iterator = currentParameters.iterator();
        while (iterator.hasNext()) {
            ResourceTypeParameter currentParameter;
            mapKey.parameter = currentParameter = iterator.next();
            ResourceTypeParameter parameter = parameterMap.get(mapKey);
            if (parameter != null) {
                parameter.setId(currentParameter.getId());
                continue;
            }
            this.getEntityManager().remove((Object)currentParameter);
        }
        return this.fetchLazyLoadedCollections(super.update(entity));
    }

    @Override
    public ResourceType find(Long key) {
        return this.fetchLazyLoadedCollections((ResourceType)super.find(key));
    }

    @Override
    public List<ResourceType> findAll() {
        List<ResourceType> resourceTypes = super.findAll();
        if (resourceTypes != null) {
            for (ResourceType resourceType : resourceTypes) {
                if (resourceType.getMessages() == null) continue;
                resourceType.getMessages().size();
            }
        }
        return resourceTypes;
    }

    @Override
    protected void refresh(ResourceType entity) {
        Set<Message> messages;
        super.refresh(entity);
        Set<ResourceTypeParameter> parameters = entity.getParameters();
        if (parameters != null) {
            for (ResourceTypeParameter parameter : parameters) {
                this.getEntityManager().refresh((Object)parameter);
            }
        }
        if ((messages = entity.getMessages()) != null) {
            for (Message message : messages) {
                this.getEntityManager().refresh((Object)message);
            }
        }
    }

    @Override
    public List<ResourceType> findAllViewable() {
        String queryName = "ResourceType.Viewable";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        return query.getResultList();
    }

    @Override
    public ResourceType findBySystemId(String systemId) {
        String queryName = "ResourceType.BySystemId";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("systemId", (Object)systemId);
        ResourceType resourceType = null;
        try {
            resourceType = (ResourceType)query.getSingleResult();
        }
        catch (NoResultException nre) {
            String msg = "Cannot find a Resource Type with System Id: " + systemId + ", return null.";
            logger.debug((Object)msg, (Throwable)nre);
            resourceType = null;
        }
        return this.fetchLazyLoadedCollections(resourceType);
    }

    @Override
    public ResourceType findByName(String name) {
        String queryName = "ResourceType.ByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        ResourceType resourceType = null;
        try {
            resourceType = (ResourceType)query.getSingleResult();
        }
        catch (NoResultException nre) {
            String msg = "Cannot find a Resource Type with Name: " + name + ", return null.";
            logger.debug((Object)msg, (Throwable)nre);
            resourceType = null;
        }
        return this.fetchLazyLoadedCollections(resourceType);
    }

    @Override
    public int getCountByName(String name) {
        String queryName = "ResourceType.CountByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    @Override
    public int getCountBySystemId(String systemId) {
        String queryName = "ResourceType.CountBySystemId";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("systemId", (Object)systemId);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    @Override
    public List<Message> getMessagesById(long resourceTypeId) {
        String queryName = "ResourceType.MessagesById";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("id", (Object)resourceTypeId);
        return query.getResultList();
    }

    @Override
    public List<Message> getMessagesByUid(Set<String> uids) {
        if (uids == null || uids.size() == 0) {
            return new ArrayList<Message>();
        }
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT NEW com.tandbergtv.watchpoint.studio.dto.Message(msg.id, msg.name) ");
        queryBuf.append("FROM com.tandbergtv.watchpoint.studio.dto.Message msg ");
        queryBuf.append("WHERE msg.uid IN ( ");
        boolean first = true;
        for (String uid : uids) {
            if (uid == null || uid.trim().length() == 0) continue;
            if (!first) {
                queryBuf.append(", ");
            } else {
                first = false;
            }
            queryBuf.append("'");
            queryBuf.append(uid);
            queryBuf.append("'");
        }
        queryBuf.append(" ) ");
        Query query = this.getEntityManager().createQuery(queryBuf.toString());
        return query.getResultList();
    }

    @Override
    public boolean isOutOfTheBox(long resourceTypeID) {
        String queryName = "ResourceType.OutOfTheBoxById";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("id", (Object)resourceTypeID);
        return (Boolean)query.getSingleResult();
    }

    private Map<ParameterMapKey, ResourceTypeParameter> buildParameterMap(ResourceType resourceType) {
        HashMap<ParameterMapKey, ResourceTypeParameter> parameterMap = new HashMap<ParameterMapKey, ResourceTypeParameter>();
        Set<ResourceTypeParameter> parameters = resourceType.getAllParameters();
        for (ResourceTypeParameter parameter : parameters) {
            parameterMap.put(new ParameterMapKey(parameter), parameter);
        }
        return parameterMap;
    }

    private List<ResourceTypeParameter> getParametersById(long resourceTypeId) {
        String queryName = "ResourceType.ParametersById";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("id", (Object)resourceTypeId);
        return query.getResultList();
    }

    private ResourceType fetchLazyLoadedCollections(ResourceType resourceType) {
        if (resourceType != null) {
            if (resourceType.getMessages() != null) {
                resourceType.getMessages().size();
            }
            if (resourceType.getParameters() != null) {
                resourceType.getParameters();
            }
        }
        return resourceType;
    }

    private class ParameterMapKey {
        ResourceTypeParameter parameter;

        ParameterMapKey(ResourceTypeParameter parameter) {
            this.parameter = parameter;
        }

        public int hashCode() {
            if (this.parameter == null || this.parameter.getName() == null) {
                return super.hashCode();
            }
            return this.parameter.getName().hashCode() * 4 - this.parameter.getType().hashCode() * 3 + 373;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterMapKey)) {
                return false;
            }
            ResourceTypeParameter paramObj = ((ParameterMapKey)obj).parameter;
            if (this.parameter == null && paramObj == null) {
                return super.equals(obj);
            }
            String name = this.parameter.getName();
            return this.parameter.getType() == paramObj.getType() && name != null && name.equals(paramObj.getName());
        }
    }
}

