/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.PersistenceDAO;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowTemplateDTOPDAO
extends PersistenceDAO<WorkflowTemplateDTO, Long>
implements WorkflowTemplateDTODAI {
    public WorkflowTemplateDTOPDAO(JPAPersistenceContext persistenceContext) {
        super(WorkflowTemplateDTO.class, persistenceContext);
    }

    @Override
    public List<WorkflowTemplateDTO> findAll() {
        String queryName = "WorkflowTemplateDTO.All";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        return query.getResultList();
    }

    @Override
    public List<WorkflowTemplateDTO> findByCurrentVersion() {
        String queryName = "WorkflowTemplateDTO.ByCurrentVersion";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        return this.buildTemplates(query.getResultList());
    }

    @Override
    public List<WorkflowTemplateDTO> findByNodeDefinitionUsage(long nodeDefinitionId) {
        String queryName = "WorkflowTemplateDTO.ByNodeDefinitionUsage";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("nodeDefinitionId", (Object)nodeDefinitionId);
        return this.buildTemplates(query.getResultList());
    }

    @Override
    public WorkflowTemplateDTO findByName(String name) {
        String queryName = "WorkflowTemplateDTO.ByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        return (WorkflowTemplateDTO)query.getSingleResult();
    }

    @Override
    public Long getTemplateIdByName(String name) {
        String queryName = "WorkflowTemplateDTO.IdByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        return (Long)query.getSingleResult();
    }

    @Override
    public Long getTemplateIdByNameForOldestVersion(String name) {
        String queryName = "WorkflowTemplateDTO.IdByNameForOldestVersion";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        return (Long)query.getSingleResult();
    }

    @Override
    public Integer getCurrentVersionNumberByName(String name) {
        String queryName = "WorkflowTemplateDTO.CurrentVersionByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        return (Integer)query.getSingleResult();
    }

    @Override
    public int getCountByName(String name) {
        String queryName = "WorkflowTemplateDTO.CountByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    @Override
    public int getCountByNodeDefinitionUsage(long nodeDefinitionId) {
        String queryName = "WorkflowTemplateDTO.CountByNodeDefinitionUsage";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("nodeDefinitionId", (Object)nodeDefinitionId);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    @Override
    public int getCountByResourceGroupUsage(long resourceGroupId) {
        String queryName = "WorkflowTemplateDTO.CountByResourceGroupUsage";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("resourceGroupId", (Object)resourceGroupId);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    @Override
    public int setInactiveByName(String name) {
        String queryName = "WorkflowTemplateDTO.Update.InactiveByName";
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("name", (Object)name);
        return query.executeUpdate();
    }

    @Override
    public void deleteNodeDefinitionReferences(long nodeDefinitionId) {
        String sqlQuery = "DELETE TB_NODEDEFINITIONTEMPLATEMAP WHERE NODEDEFINITIONID = :nodeDefinitionId";
        Query query = this.getEntityManager().createNativeQuery(sqlQuery);
        query.setParameter("nodeDefinitionId", (Object)nodeDefinitionId);
        query.executeUpdate();
    }

    @Override
    public void deleteResourceGroupMap(String templateName) {
        String sqlQuery = "DELETE TB_RESOURCEGROUPTEMPLATEMAP WHERE TEMPLATEID IN (SELECT TEMPLATEID FROM TB_TEMPLATE WHERE NAME = :templateName)";
        Query query = this.getEntityManager().createNativeQuery(sqlQuery);
        query.setParameter("templateName", (Object)templateName);
        query.executeUpdate();
    }

    private List<WorkflowTemplateDTO> buildTemplates(List<?> data) {
        ArrayList<WorkflowTemplateDTO> templates = new ArrayList<WorkflowTemplateDTO>();
        if (data != null) {
            for (Object dataObject : data) {
                Object[] columns = (Object[])dataObject;
                WorkflowTemplateDTO template = new WorkflowTemplateDTO();
                int i = 0;
                while (i < columns.length) {
                    switch (i) {
                        case 0: {
                            template.setId((Long)columns[0]);
                            break;
                        }
                        case 1: {
                            template.setName((String)columns[1]);
                            break;
                        }
                        case 2: {
                            template.setExportable((Boolean)columns[2]);
                            break;
                        }
                        case 3: {
                            template.setVersion((Integer)columns[3]);
                            break;
                        }
                        case 4: {
                            template.setDirty((Boolean)columns[4]);
                            break;
                        }
                        case 5: {
                            template.setLock((ILock)columns[5]);
                            break;
                        }
                        case 6: {
                            template.setActive((Boolean)columns[6]);
                        }
                    }
                    ++i;
                }
                templates.add(template);
            }
        }
        return templates;
    }
}

