/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dto;

import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import com.tandbergtv.watchpoint.studio.dto.IVersionable;
import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;

public class ResourceGroup
implements IWatchPointDTO,
IPersistable,
IVersionable {
    private static final long serialVersionUID = 1752587187156740443L;
    private long id = -1L;
    private String name;
    private String description;
    private String functionalType;
    private ResourceType resourceType;
    private boolean internallyAcquired;
    private String allocationStrategyClassName;
    private ProtectionKey protectionKey;
    private byte[] imageContent;
    private String imageFileName;
    private int version;
    private boolean dirty;

    public Long getKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAllocationStrategyClassName() {
        return this.allocationStrategyClassName;
    }

    public void setAllocationStrategyClassName(String allocationStrategyClassName) {
        this.allocationStrategyClassName = allocationStrategyClassName;
    }

    public String getFunctionalType() {
        return this.functionalType;
    }

    public void setFunctionalType(String functionalType) {
        this.functionalType = functionalType;
    }

    public byte[] getImageContent() {
        return this.imageContent;
    }

    public void setImageContent(byte[] imageContent) {
        this.imageContent = imageContent;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    public boolean isInternallyAcquired() {
        return this.internallyAcquired;
    }

    public void setInternallyAcquired(boolean internallyAcquired) {
        this.internallyAcquired = internallyAcquired;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public ProtectionKey getProtectionKey() {
        return this.protectionKey;
    }

    public void setProtectionKey(ProtectionKey protectionKey) {
        this.protectionKey = protectionKey;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int hashCode() {
        if (this.id == -1L) {
            return super.hashCode();
        }
        return new Long(this.id).hashCode() * 7 - 847;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceGroup)) {
            return false;
        }
        ResourceGroup group = (ResourceGroup)obj;
        if (this.id == -1L && group.id == -1L) {
            return super.equals(group);
        }
        return this.id == group.id;
    }

    public ResourceGroup clone() {
        ResourceGroup clone = null;
        try {
            clone = (ResourceGroup)super.clone();
            if (this.resourceType != null) {
                clone.resourceType = this.resourceType.clone();
            }
            if (this.protectionKey != null) {
                clone.protectionKey = this.protectionKey.clone();
            }
            if (this.imageContent != null) {
                int byteCount = this.imageContent.length;
                clone.imageContent = new byte[byteCount];
                System.arraycopy(this.imageContent, 0, clone.imageContent, 0, byteCount);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }
}

