/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dto;

import com.tandbergtv.watchpoint.studio.dto.AdaptorScope;
import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import com.tandbergtv.watchpoint.studio.dto.IVersionable;
import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ParameterType;
import com.tandbergtv.watchpoint.studio.dto.ResourceTypeParameter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceType
implements IWatchPointDTO,
IVersionable,
IPersistable {
    private static final long serialVersionUID = -1762516537061906221L;
    private long id = -1L;
    private String systemId;
    private String name;
    private String description;
    private Date createDate;
    private ConnectionType connectionType;
    private int messageSequenceNumber = 0;
    private AdaptorType adaptorType;
    private String adaptorClassName;
    private AdaptorScope adaptorScope;
    private String messageIdentificationClassName;
    private boolean initializationRequired = false;
    private String initializationStrategyClass;
    private boolean heartbeatRequired = false;
    private String heartbeatStrategyClass;
    private ConnectionType heartbeatConnectionType;
    private Set<ResourceTypeParameter> parameters;
    private String defaultProtocol;
    private Set<Message> messages;
    private int version;
    private boolean dirty;
    private boolean outOfTheBox;

    public ResourceType() {
    }

    public ResourceType(long id) {
        this.setId(id);
    }

    public ResourceType(long id, String name, String systemId, String description, Date createDate, int version, boolean dirty, boolean outOfTheBox) {
        this.setId(id);
        this.setName(name);
        this.setSystemId(systemId);
        this.setDescription(description);
        this.setConnectionType(this.connectionType);
        this.setCreateDate(createDate);
        this.setVersion(version);
        this.setDirty(dirty);
        this.setOutOfTheBox(outOfTheBox);
    }

    @Override
    public Long getKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public int getMessageSequenceNumber() {
        return this.messageSequenceNumber;
    }

    public void setMessageSequenceNumber(int messageSequenceNumber) {
        this.messageSequenceNumber = messageSequenceNumber;
    }

    public AdaptorType getAdaptorType() {
        if (this.adaptorType == null) {
            this.adaptorType = AdaptorType.NONE;
        }
        return this.adaptorType;
    }

    public void setAdaptorType(AdaptorType adaptorType) {
        this.adaptorType = adaptorType;
    }

    public String getAdaptorClassName() {
        return this.adaptorClassName;
    }

    public void setAdaptorClassName(String adaptorClassName) {
        this.adaptorClassName = adaptorClassName;
    }

    public Set<ResourceTypeParameter> getAllParameters() {
        HashSet<ResourceTypeParameter> allParameters = new HashSet<ResourceTypeParameter>();
        if (this.parameters != null) {
            allParameters.addAll(this.parameters);
        }
        return allParameters;
    }

    public Set<ResourceTypeParameter> getParameters() {
        return this.parameters;
    }

    protected void setParameters(Set<ResourceTypeParameter> parameters) {
        this.parameters = parameters;
    }

    public AdaptorScope getAdaptorScope() {
        return this.adaptorScope;
    }

    public void setAdaptorScope(AdaptorScope scope) {
        this.adaptorScope = scope;
    }

    public String getMessageIdentificationClassName() {
        return this.messageIdentificationClassName;
    }

    public void setMessageIdentificationClassName(String messageIdentificationClassName) {
        this.messageIdentificationClassName = messageIdentificationClassName;
    }

    public ConnectionType getHeartbeatConnectionType() {
        return this.heartbeatConnectionType;
    }

    public void setHeartbeatConnectionType(ConnectionType heartbeatConnectionType) {
        this.heartbeatConnectionType = heartbeatConnectionType;
    }

    public String getHeartbeatStrategyClass() {
        return this.heartbeatStrategyClass;
    }

    public void setHeartbeatStrategyClass(String heartbeatStrategyClass) {
        this.heartbeatStrategyClass = heartbeatStrategyClass;
    }

    public String getInitializationStrategyClass() {
        return this.initializationStrategyClass;
    }

    public void setInitializationStrategyClass(String initializationStrategyClass) {
        this.initializationStrategyClass = initializationStrategyClass;
    }

    public boolean isHeartbeatRequired() {
        return this.heartbeatRequired;
    }

    public void setHeartbeatRequired(boolean requiresHeartbeat) {
        this.heartbeatRequired = requiresHeartbeat;
    }

    public boolean isInitializationRequired() {
        return this.initializationRequired;
    }

    public void setInitializationRequired(boolean requiresInitialization) {
        this.initializationRequired = requiresInitialization;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String defaultProtocol) {
        this.defaultProtocol = defaultProtocol;
    }

    public Set<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Set<Message> messages) {
        this.messages = messages;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void addMessage(Message message) {
        message.setResourceType(this);
        if (this.messages == null) {
            this.messages = new HashSet<Message>();
        }
        this.messages.add(message);
    }

    public void removeMessage(Message message) {
        if (this.messages == null) {
            return;
        }
        this.messages.remove(message);
    }

    public boolean isOutOfTheBox() {
        return this.outOfTheBox;
    }

    public void setOutOfTheBox(boolean outOfTheBox) {
        this.outOfTheBox = outOfTheBox;
    }

    public Map<String, String> getAdaptorParameters() {
        return this.getParameters(ParameterType.ADAPTOR);
    }

    public void setAdaptorParameters(Map<String, String> adaptorParameters) {
        this.setParameters(ParameterType.ADAPTOR, adaptorParameters);
    }

    public void addAdaptorParameter(String name, String value) {
        this.addParameter(ParameterType.ADAPTOR, name, value);
    }

    public String removeAdaptorParameter(String name) {
        return this.removeParameter(ParameterType.ADAPTOR, name);
    }

    public void removeAdaptorParameters() {
        this.removeParameters(ParameterType.ADAPTOR);
    }

    public Map<String, String> getHeartbeatParameters() {
        return this.getParameters(ParameterType.HEARTBEAT);
    }

    public void setHeartbeatParameters(Map<String, String> heartbeatParameters) {
        this.setParameters(ParameterType.HEARTBEAT, heartbeatParameters);
    }

    public void addHeartbeatParameter(String name, String value) {
        this.addParameter(ParameterType.HEARTBEAT, name, value);
    }

    public String removeHearbeatParameter(String name) {
        return this.removeParameter(ParameterType.HEARTBEAT, name);
    }

    public void removeHeartbeatParameters() {
        this.removeParameters(ParameterType.HEARTBEAT);
    }

    public Map<String, String> getInitializationParameters() {
        return this.getParameters(ParameterType.INITIALIZATION);
    }

    public void setInitializationParameters(Map<String, String> parameters) {
        this.setParameters(ParameterType.INITIALIZATION, parameters);
    }

    public void addInitializationParameter(String name, String value) {
        this.addParameter(ParameterType.INITIALIZATION, name, value);
    }

    public void removeInitializationParameter(String name) {
        this.removeParameter(ParameterType.INITIALIZATION, name);
    }

    public void removeInitializationParameters() {
        this.removeParameters(ParameterType.INITIALIZATION);
    }

    protected Map<String, String> getParameters(ParameterType parameterType) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.parameters == null) {
            return result;
        }
        for (ResourceTypeParameter parameter : this.parameters) {
            if (parameter.getType() != parameterType) continue;
            result.put(parameter.getName(), parameter.getValue());
        }
        return result;
    }

    protected void setParameters(ParameterType parameterType, Map<String, String> newParameters) {
        this.removeParameters(parameterType);
        if (newParameters == null) {
            return;
        }
        for (String name : newParameters.keySet()) {
            this.addParameter(parameterType, name, newParameters.get(name));
        }
    }

    protected void removeParameters(ParameterType parameterType) {
        if (this.parameters == null) {
            return;
        }
        Iterator<ResourceTypeParameter> itr = this.parameters.iterator();
        while (itr.hasNext()) {
            ResourceTypeParameter parameter = itr.next();
            if (parameter.getType() != parameterType) continue;
            itr.remove();
        }
    }

    protected void addParameter(ParameterType parameterType, String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashSet<ResourceTypeParameter>();
        }
        if (name == null || parameterType == null || value == null) {
            String msg = "ResourceType Parameter type, name and value must all be not null.";
            throw new IllegalArgumentException(msg);
        }
        for (ResourceTypeParameter parameter : this.parameters) {
            if (!this.isMatchingParameter(parameter, parameterType, name)) continue;
            parameter.setValue(value);
            return;
        }
        this.parameters.add(new ResourceTypeParameter(this, parameterType, name, value));
    }

    protected String removeParameter(ParameterType parameterType, String name) {
        String oldValue = null;
        if (this.parameters == null) {
            return oldValue;
        }
        Iterator<ResourceTypeParameter> itr = this.parameters.iterator();
        while (itr.hasNext()) {
            ResourceTypeParameter parameter = itr.next();
            if (!this.isMatchingParameter(itr.next(), parameterType, name)) continue;
            itr.remove();
            oldValue = parameter.getValue();
            break;
        }
        return oldValue;
    }

    protected String getParameterValue(ParameterType parameterType, String name) {
        String value = null;
        if (this.parameters == null) {
            return value;
        }
        for (ResourceTypeParameter parameter : this.parameters) {
            if (!this.isMatchingParameter(parameter, parameterType, name)) continue;
            value = parameter.getValue();
            break;
        }
        return value;
    }

    private boolean isMatchingParameter(ResourceTypeParameter parameter, ParameterType type, String name) {
        String parameterName = parameter.getName();
        ParameterType parameterType = parameter.getType();
        return parameterType == type && parameterName.equals(name);
    }

    public int hashCode() {
        if (this.id == -1L) {
            return super.hashCode();
        }
        return new Long(this.id).hashCode() * 3 + 484;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceType)) {
            return false;
        }
        ResourceType resourceType = (ResourceType)obj;
        if (this.id == -1L && resourceType.id == -1L) {
            return super.equals(resourceType);
        }
        return this.id == resourceType.id;
    }

    @Override
    public ResourceType clone() {
        ResourceType clone = null;
        try {
            clone = (ResourceType)super.clone();
            if (this.parameters != null) {
                clone.parameters = new HashSet<ResourceTypeParameter>();
                for (ResourceTypeParameter parameter : this.parameters) {
                    clone.parameters.add(parameter.clone());
                }
            }
            if (this.messages != null) {
                clone.messages = new HashSet<Message>();
                for (Message message : this.messages) {
                    clone.addMessage(message.clone());
                }
            }
            if (this.connectionType != null) {
                clone.connectionType = this.connectionType.clone();
            }
            if (this.heartbeatConnectionType != null) {
                clone.heartbeatConnectionType = this.heartbeatConnectionType.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    public String toString() {
        return this.getName();
    }
}

