/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.WatchPointDTOExporterFactory;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.ResourceGroupExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.ResourceTypeExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.WorkflowTemplateFileExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExporterFactory
extends WatchPointDTOExporterFactory {
    @Override
    public <T extends IWatchPointDTO> IWatchPointDTOExporter<T> getExporter(Class<T> type) {
        IWatchPointDTOExporter<WorkflowTemplateDTO> exporter = null;
        if (WorkflowTemplateDTO.class.equals(type)) {
            exporter = new WorkflowTemplateFileExporter();
        } else if (ResourceType.class.equals(type)) {
            exporter = new ResourceTypeExporter();
        } else if (ResourceGroup.class.equals(type)) {
            exporter = new ResourceGroupExporter();
        } else {
            String className = type.getName();
            String msg = "No WatchPointDTOExporter available for class: " + className;
            throw new StudioRuntimeException(msg);
        }
        return exporter;
    }
}

