/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPFExportUtil {
    private static final String LIBRARY_ID_PREFIX = "_library_";
    private static final int VALUE_ATTRIBUTE_SIZE_LIMIT = 300;

    private JPFExportUtil() {
    }

    public static Document createPluginDocument(String pluginId, String version) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        DOMImplementation domImpl = documentBuilder.getDOMImplementation();
        DocumentType docType = domImpl.createDocumentType("plugin", "-//JPF//Java Plug-in Manifest 1.0", "http://jpf.sourceforge.net/plugin_1_0.dtd");
        Document pluginDocument = domImpl.createDocument("", "plugin", docType);
        Element pluginElement = pluginDocument.getDocumentElement();
        pluginElement.setAttribute("id", pluginId);
        pluginElement.setAttribute("version", version);
        return pluginDocument;
    }

    public static final void addPluginDependency(Document pluginDocument, String pluginId) {
        List<String> names;
        if (pluginId == null || pluginId.trim().length() == 0) {
            String msg = "The Plugin ID specified as a dependent cannot be null or blank.";
            throw new IllegalArgumentException(msg);
        }
        Element pluginElement = pluginDocument.getDocumentElement();
        Element element = JPFExportUtil.findOrCreateElement("requires", pluginElement, names = Arrays.asList("runtime", "extension-point", "extension"));
        NodeList nodes = element.getChildNodes();
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node childNode = nodes.item(i);
                if (childNode.getNodeType() == 1) {
                    Element childElement = (Element)childNode;
                    String name = childNode.getNodeName();
                    String value = childElement.getAttribute("plugin-id");
                    if ("import".equals(name) && pluginId.equals(value)) {
                        return;
                    }
                }
                ++i;
            }
        }
        Element importElement = pluginDocument.createElement("import");
        importElement.setAttribute("plugin-id", pluginId);
        element.appendChild(importElement);
    }

    public static final void addRuntimeLibraries(Document pluginDocument, List<String> codeLibraries, List<String> resourceLibraries) {
        int newLibraryCount;
        if (codeLibraries == null) {
            codeLibraries = new ArrayList<String>();
        }
        if (resourceLibraries == null) {
            resourceLibraries = new ArrayList<String>();
        }
        if ((newLibraryCount = codeLibraries.size() + resourceLibraries.size()) == 0) {
            return;
        }
        Element pluginElement = pluginDocument.getDocumentElement();
        List<String> names = Arrays.asList("extension-point", "extension");
        Element element = JPFExportUtil.findOrCreateElement("runtime", pluginElement, names);
        HashMap<String, String> currentLibraries = new HashMap<String, String>();
        NodeList nodes = element.getChildNodes();
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node childNode = nodes.item(i);
                if (childNode.getNodeType() == 1 && "library".equals(childNode.getNodeName())) {
                    Element childElement = (Element)childNode;
                    String id = childElement.getAttribute("id");
                    String path = childElement.getAttribute("path");
                    currentLibraries.put(id, path);
                }
                ++i;
            }
        }
        JPFExportUtil.addLibraries(element, codeLibraries, "code", currentLibraries);
        JPFExportUtil.addLibraries(element, resourceLibraries, "resources", currentLibraries);
    }

    public static Element addExtension(Document pluginDocument, String extensionId, String pluginId, String extensionPointId) {
        Element extensionElement = pluginDocument.createElement("extension");
        extensionElement.setAttribute("id", extensionId);
        extensionElement.setAttribute("plugin-id", pluginId);
        extensionElement.setAttribute("point-id", extensionPointId);
        pluginDocument.getDocumentElement().appendChild(extensionElement);
        return extensionElement;
    }

    public static Element addParameter(Element parent, String key) {
        return JPFExportUtil.addParameter(parent, key, null);
    }

    public static Element addParameter(Element parent, String key, String value) {
        Document document = parent.getOwnerDocument();
        Element parameterElement = document.createElement("parameter");
        parameterElement.setAttribute("id", key);
        if (JPFExportUtil.requiresValueElement(value)) {
            Element valueElement = document.createElement("value");
            value = value.replace(System.getProperty("line.separator"), "\n");
            valueElement.setTextContent(value);
            parameterElement.appendChild(valueElement);
        } else if (value != null) {
            parameterElement.setAttribute("value", value);
        }
        parent.appendChild(parameterElement);
        return parameterElement;
    }

    private static boolean requiresValueElement(String value) {
        if (value == null) {
            return false;
        }
        return value.length() > 300 || value.contains(System.getProperty("line.separator")) || value.contains("\n");
    }

    private static Element findOrCreateElement(String elementName, Element parent, List<String> elementsAfter) {
        NodeList nodes = parent.getElementsByTagName(elementName);
        Element element = null;
        if (nodes == null || nodes.getLength() == 0) {
            element = parent.getOwnerDocument().createElement(elementName);
            Node refChild = parent.getFirstChild();
            NodeList childNodes = parent.getChildNodes();
            if (childNodes != null) {
                if (elementsAfter == null) {
                    elementsAfter = new ArrayList<String>();
                }
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node childNode = childNodes.item(i);
                    if (childNode.getNodeType() == 1) {
                        if (elementsAfter.contains(childNode.getNodeName())) break;
                        refChild = childNode.getNextSibling();
                    }
                    ++i;
                }
            }
            parent.insertBefore(element, refChild);
        } else {
            element = (Element)nodes.item(0);
        }
        return element;
    }

    private static void addLibraries(Element runtimeElement, List<String> libraryPaths, String libraryType, Map<String, String> currentLibraries) {
        int libraryCounter = 1;
        for (String libraryPath : libraryPaths) {
            Document document = runtimeElement.getOwnerDocument();
            Element libraryElement = document.createElement("library");
            String initialLibraryId = String.valueOf(libraryType) + LIBRARY_ID_PREFIX;
            String libraryId = null;
            String suffix = null;
            do {
                if ((suffix = Integer.toString(libraryCounter++)).length() != 1) continue;
                suffix = "0" + suffix;
            } while (currentLibraries.containsKey(libraryId = String.valueOf(initialLibraryId) + suffix));
            libraryElement.setAttribute("path", libraryPath);
            libraryElement.setAttribute("id", libraryId);
            libraryElement.setAttribute("type", libraryType);
            runtimeElement.appendChild(libraryElement);
        }
    }
}

