/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.JPFExportUtil;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupExporter
extends WatchPointPluginExporter<ResourceGroup> {
    private static final String EXTENSION_ID_SUFFIX = " Resource Group";
    private static final String TASK_IMAGE_DIR = "images";
    private static final String DEFAULT_TASK_IMAGE_FILE_NAME = "taskImage";

    @Override
    protected String getPluginId(ResourceGroup exportable, Map<String, Object> inputs) {
        return String.valueOf(exportable.getName()) + EXTENSION_ID_SUFFIX;
    }

    @Override
    protected String getPluginVersion(ResourceGroup exportable, Map<String, Object> inputs) {
        return String.valueOf(exportable.getVersion());
    }

    @Override
    protected void addPluginPointsAndExtensions(ResourceGroup exportable, Map<String, Object> inputs, Document pluginDocument, File pluginFolder) throws ExportFailureException {
        String extensionId = String.valueOf(exportable.getName()) + EXTENSION_ID_SUFFIX;
        Element extensionElement = JPFExportUtil.addExtension(pluginDocument, extensionId, "com.tandbergtv.workflow", "resourcegroup");
        if (this.isNotNullAndNotBlank(exportable.getName())) {
            JPFExportUtil.addParameter(extensionElement, "name", exportable.getName());
        }
        if (exportable.getResourceType() != null && this.isNotNullAndNotBlank(exportable.getResourceType().getSystemId())) {
            JPFExportUtil.addParameter(extensionElement, "systemId", exportable.getResourceType().getSystemId());
        }
        if (this.isNotNullAndNotBlank(exportable.getFunctionalType())) {
            JPFExportUtil.addParameter(extensionElement, "functionalType", exportable.getFunctionalType());
        }
        if (exportable.getProtectionKey() != null && this.isNotNullAndNotBlank(exportable.getProtectionKey().getName())) {
            JPFExportUtil.addParameter(extensionElement, "accessLevel", exportable.getProtectionKey().getName());
        }
        JPFExportUtil.addParameter(extensionElement, "isInternallyAcquired", String.valueOf(exportable.isInternallyAcquired()));
        if (this.isNotNullAndNotBlank(exportable.getAllocationStrategyClassName())) {
            JPFExportUtil.addParameter(extensionElement, "allocationStrategyClass", exportable.getAllocationStrategyClassName());
        }
        if (exportable.getImageContent() != null && exportable.getImageContent().length > 0) {
            File imageDir = new File(this.getPluginResourcesFolder(pluginFolder), TASK_IMAGE_DIR);
            String imageFileName = this.isNotNullAndNotBlank(exportable.getImageFileName()) ? exportable.getImageFileName() : DEFAULT_TASK_IMAGE_FILE_NAME;
            File imageFile = new File(imageDir, imageFileName);
            try {
                imageDir.mkdirs();
                this.writeToFile(exportable.getImageContent(), imageFile);
            }
            catch (IOException e) {
                String message = "IO Exception caught while exporting the image (writing image content to file). Ensure that the export folder is accessible.";
                throw new ExportFailureException(message, e);
            }
            JPFExportUtil.addParameter(extensionElement, "imagePath", TASK_IMAGE_DIR + File.separator + imageFileName);
        }
    }

    private boolean isNotNullAndNotBlank(String str) {
        return str != null && str.trim().length() > 0;
    }

    private void writeToFile(byte[] data, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(data);
        fos.flush();
        fos.close();
    }
}

