/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.AdaptorScope;
import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.JPFExportUtil;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginExporter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeExporter
extends WatchPointPluginExporter<ResourceType> {
    private static final String PLUGIN_ID_PREFIX = "ResourceTypePlugin_";
    private static final String EXTENSION_ID_PREFIX = "ResourceType_";
    private static final String JPF_DATE_FORMAT = "yyyy-MM-dd";

    @Override
    protected String getPluginId(ResourceType resourceType, Map<String, Object> inputs) {
        return PLUGIN_ID_PREFIX + resourceType.getSystemId();
    }

    @Override
    protected String getPluginVersion(ResourceType resourceType, Map<String, Object> inputs) {
        return Integer.toString(resourceType.getVersion());
    }

    @Override
    protected void addPluginPointsAndExtensions(ResourceType exportable, Map<String, Object> inputs, Document pluginDocument, File rootFolder) {
        this.addResourceTypeExtension(pluginDocument, exportable, inputs);
    }

    private void addResourceTypeExtension(Document document, ResourceType resourceType, Map<String, Object> inputs) {
        String extensionId = EXTENSION_ID_PREFIX + resourceType.getSystemId();
        Element extensionElement = JPFExportUtil.addExtension(document, extensionId, "com.tandbergtv.workflow", "resourcetype");
        this.addBasicParameters(extensionElement, resourceType, inputs);
        this.addCommunicationParameter(extensionElement, resourceType, inputs);
        this.addManagementParameter(extensionElement, resourceType, inputs);
    }

    private void addBasicParameters(Element element, ResourceType resourceType, Map<String, Object> inputs) {
        JPFExportUtil.addParameter(element, "systemId", resourceType.getSystemId());
        JPFExportUtil.addParameter(element, "name", resourceType.getName());
        SimpleDateFormat dateFormat = new SimpleDateFormat(JPF_DATE_FORMAT);
        String createDate = dateFormat.format(resourceType.getCreateDate());
        JPFExportUtil.addParameter(element, "createDate", createDate);
        String description = resourceType.getDescription();
        if (description != null && description.trim().length() > 0) {
            JPFExportUtil.addParameter(element, "description", description);
        }
    }

    private void addCommunicationParameter(Element element, ResourceType resourceType, Map<String, Object> inputs) {
        int messageCount;
        Set<Message> messages = resourceType.getMessages();
        int n = messageCount = messages != null ? messages.size() : 0;
        if (messageCount == 0) {
            return;
        }
        Element communicationElement = JPFExportUtil.addParameter(element, "communication");
        this.addMessagesParameter(communicationElement, resourceType, inputs);
        this.addAdaptorParameter(communicationElement, resourceType, inputs);
    }

    private void addMessagesParameter(Element element, ResourceType resourceType, Map<String, Object> inputs) {
        Element messagesElement = JPFExportUtil.addParameter(element, "messages");
        String defaultProtocol = resourceType.getDefaultProtocol();
        if (defaultProtocol == null) {
            defaultProtocol = "";
        }
        JPFExportUtil.addParameter(messagesElement, "defaultProtocol", defaultProtocol);
        ArrayList<Message> messageList = new ArrayList<Message>(resourceType.getMessages());
        Collections.sort(messageList, new Comparator<Message>(){

            @Override
            public int compare(Message o1, Message o2) {
                String uid1 = o1 != null ? o1.getUid() : "";
                String uid2 = o2 != null ? o2.getUid() : "";
                return uid1.compareTo(uid2);
            }
        });
        for (Message message : messageList) {
            this.addMessageParameter(messagesElement, message, defaultProtocol, inputs);
        }
    }

    private void addMessageParameter(Element element, Message message, String defaultProtocol, Map<String, Object> inputs) {
        String protocol;
        Element messageElement = JPFExportUtil.addParameter(element, "message");
        JPFExportUtil.addParameter(messageElement, "name", message.getName());
        JPFExportUtil.addParameter(messageElement, "uid", message.getUid());
        String description = message.getDescription();
        if (description != null && description.trim().length() > 0) {
            JPFExportUtil.addParameter(messageElement, "description", description);
        }
        if ((protocol = message.getProtocol()) != null && protocol.trim().length() > 0 && !protocol.equals(defaultProtocol)) {
            JPFExportUtil.addParameter(messageElement, "protocol", protocol);
        }
    }

    private void addAdaptorParameter(Element element, ResourceType resourceType, Map<String, Object> inputs) {
        Element adaptorElement = JPFExportUtil.addParameter(element, "adaptor");
        if (resourceType.getAdaptorType() == AdaptorType.DEFAULT) {
            this.addDefaultAdaptorParameter(adaptorElement, resourceType, inputs);
        } else if (resourceType.getAdaptorType() == AdaptorType.CUSTOM) {
            this.addCustomAdaptorParameter(adaptorElement, resourceType, inputs);
        }
    }

    private void addDefaultAdaptorParameter(Element element, ResourceType resourceType, Map<String, Object> inputs) {
        Element defaultAdaptorElement = JPFExportUtil.addParameter(element, "default");
        String messageIdentifier = resourceType.getMessageIdentificationClassName();
        if (messageIdentifier != null && messageIdentifier.trim().length() > 0) {
            JPFExportUtil.addParameter(defaultAdaptorElement, "messageIdentifierClass", messageIdentifier);
        }
    }

    private void addCustomAdaptorParameter(Element element, ResourceType resourceType, Map<String, Object> inputs) {
        Element customAdaptorElement = JPFExportUtil.addParameter(element, "custom");
        JPFExportUtil.addParameter(customAdaptorElement, "class", resourceType.getAdaptorClassName());
        String scopeValue = this.getScopeValue(resourceType.getAdaptorScope());
        if (scopeValue != null) {
            JPFExportUtil.addParameter(customAdaptorElement, "scope", scopeValue);
        }
        Map<String, String> parameters = resourceType.getAdaptorParameters();
        this.addResourceTypeParameters(customAdaptorElement, parameters, "init-params", "parameter", "key", "value");
    }

    private void addManagementParameter(Element element, ResourceType resourceType, Map<String, Object> inputs) {
        Element managementElement = JPFExportUtil.addParameter(element, "management");
        String connectionType = resourceType.getConnectionType().getName();
        JPFExportUtil.addParameter(managementElement, "connectionType", connectionType);
        this.addInitializationParameters(managementElement, resourceType, inputs);
        this.addHeartbeatParameters(managementElement, resourceType, inputs);
    }

    private void addInitializationParameters(Element element, ResourceType resourceType, Map<String, Object> inputs) {
        if (!resourceType.isInitializationRequired()) {
            return;
        }
        Element initializationElement = JPFExportUtil.addParameter(element, "initialization");
        JPFExportUtil.addParameter(initializationElement, "strategyClass", resourceType.getInitializationStrategyClass());
        Map<String, String> parameters = resourceType.getInitializationParameters();
        this.addResourceTypeParameters(initializationElement, parameters, "init-params", "parameter", "key", "value");
    }

    private void addHeartbeatParameters(Element element, ResourceType resourceType, Map<String, Object> inputs) {
        if (!resourceType.isHeartbeatRequired()) {
            return;
        }
        Element heartbeatElement = JPFExportUtil.addParameter(element, "heartbeat");
        JPFExportUtil.addParameter(heartbeatElement, "connectionType", resourceType.getHeartbeatConnectionType().getName());
        JPFExportUtil.addParameter(heartbeatElement, "strategyClass", resourceType.getHeartbeatStrategyClass());
        Map<String, String> parameters = resourceType.getHeartbeatParameters();
        this.addResourceTypeParameters(heartbeatElement, parameters, "init-params", "parameter", "key", "value");
    }

    private void addResourceTypeParameters(Element element, Map<String, String> parameters, String parametersName, String parameterName, String keyName, String valueName) {
        if (parameters == null || parameters.size() == 0) {
            return;
        }
        Element parametersElement = JPFExportUtil.addParameter(element, parametersName);
        ArrayList parameterKeys = new ArrayList(parameters.keySet());
        Collections.sort(parameterKeys);
        for (String key : parameterKeys) {
            String value = parameters.get(key);
            Element parameterElement = JPFExportUtil.addParameter(parametersElement, parameterName);
            JPFExportUtil.addParameter(parameterElement, keyName, key);
            JPFExportUtil.addParameter(parameterElement, valueName, value);
        }
    }

    private String getScopeValue(AdaptorScope scope) {
        String scopeValue = null;
        if (scope == null) {
            return scopeValue;
        }
        switch (scope) {
            case APPLICATION: {
                scopeValue = "application";
                break;
            }
            case MESSAGE: {
                scopeValue = "message";
            }
        }
        return scopeValue;
    }
}

