/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.JPFExportUtil;
import com.tandbergtv.watchpoint.studio.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WatchPointPluginExporter<T extends IWatchPointDTO>
implements IWatchPointDTOExporter<T> {
    private static final Logger logger = Logger.getLogger(WatchPointPluginExporter.class);
    private static final String PLUGIN_FILE_NAME = "plugin.xml";
    protected static final String GENERIC_EXCEPTION_MESSAGE = "Ensure that the export folder is accessible.";

    @Override
    public Map<String, Object> export(T exportable, Map<String, Object> exportInputs) throws ExportFailureException {
        try {
            File targetFolder = this.getPluginFolder(exportable, exportInputs);
            Document document = this.buildPluginDocument(exportable, exportInputs);
            this.addPluginDependencies(exportable, exportInputs, document, targetFolder);
            this.handleRuntimeLibraries(exportable, exportInputs, document, targetFolder);
            this.addPluginPointsAndExtensions(exportable, exportInputs, document, targetFolder);
            this.writePluginDocument(exportable, exportInputs, document, targetFolder);
            return new HashMap<String, Object>();
        }
        catch (ExportFailureException efe) {
            throw efe;
        }
        catch (Exception ex) {
            String msg = "Failed to export the WatchPoint Plugin.";
            throw new ExportFailureException(msg, ex);
        }
    }

    protected File getPluginFolder(T exportable, Map<String, Object> inputs) throws ExportFailureException {
        String folderPath = (String)inputs.get("exportFolderPath");
        if (folderPath == null) {
            String msg = "No Output Folder provided for export of WatchPoint Plugin, property: exportFolderPath must be assigned with the value of an existing folder pathin the export inputs when exporting a WatchPoint plugin.";
            throw new ExportFailureException(msg);
        }
        File pluginFolder = new File(folderPath);
        folderPath = pluginFolder.getAbsolutePath();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        if (!pluginFolder.isDirectory()) {
            String msg = "The specified output folder for export of WatchPoint Plugin is not a folder: " + folderPath;
            throw new ExportFailureException(msg);
        }
        String[] contents = pluginFolder.list();
        if (contents != null && contents.length > 0) {
            boolean deleteFlag;
            Object value = inputs.get("deleteFolderContents");
            boolean bl = deleteFlag = value != null ? (Boolean)value : false;
            if (deleteFlag) {
                if (!FileUtil.deleteFolderContents(pluginFolder, true)) {
                    String msg = "Failed to delete the contents of the specified output folder for export of WatchPoint Plugin: " + folderPath + ". " + GENERIC_EXCEPTION_MESSAGE;
                    throw new ExportFailureException(msg);
                }
            } else {
                String msg = "The specified output folder for export of WatchPoint Plugin is not empty, delete the contents of this folder before exporting: " + folderPath;
                throw new ExportFailureException(msg);
            }
        }
        return pluginFolder;
    }

    protected Document buildPluginDocument(T exportable, Map<String, Object> inputs) throws ExportFailureException {
        String pluginId = this.getPluginId(exportable, inputs);
        String version = this.getPluginVersion(exportable, inputs);
        try {
            return JPFExportUtil.createPluginDocument(pluginId, version);
        }
        catch (ParserConfigurationException ex) {
            String msg = "Export failed, unable to build the plugin XML document.";
            throw new ExportFailureException(msg, ex);
        }
    }

    protected void addPluginDependencies(T exportable, Map<String, Object> inputs, Document pluginDocument, File pluginRootFolder) {
        JPFExportUtil.addPluginDependency(pluginDocument, "com.tandbergtv.workflow");
    }

    protected void handleRuntimeLibraries(T exportable, Map<String, Object> inputs, Document pluginDocument, File pluginRootFolder) throws ExportFailureException {
        ArrayList<String> codeLibraries = new ArrayList<String>();
        ArrayList<String> resourceLibraries = new ArrayList<String>();
        String folderName = "lib";
        Object value = inputs.get("jarFilePathList");
        List filePaths = (List)value;
        this.copyRuntimeFiles(pluginRootFolder, folderName, filePaths, codeLibraries, true);
        folderName = "classes";
        value = inputs.get("classFilePathList");
        filePaths = (List)value;
        this.copyRuntimeFiles(pluginRootFolder, folderName, filePaths, codeLibraries, false);
        folderName = "resources";
        value = inputs.get("resourceFilePathList");
        filePaths = (List)value;
        this.copyRuntimeFiles(pluginRootFolder, folderName, filePaths, resourceLibraries, false);
        JPFExportUtil.addRuntimeLibraries(pluginDocument, codeLibraries, resourceLibraries);
    }

    protected void writePluginDocument(T exportable, Map<String, Object> inputs, Document pluginDocument, File pluginRootFolder) throws ExportFailureException {
        String filePath = null;
        Writer writer = null;
        try {
            try {
                File targetFile = new File(pluginRootFolder, PLUGIN_FILE_NAME);
                filePath = targetFile.getAbsolutePath();
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setAttribute("indent-number", "4");
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("doctype-public", "-//JPF//Java Plug-in Manifest 1.0");
                transformer.setOutputProperty("doctype-system", "http://jpf.sourceforge.net/plugin_1_0.dtd");
                transformer.setOutputProperty("indent", "yes");
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8");
                transformer.transform(new DOMSource(pluginDocument), new StreamResult(writer));
            }
            catch (Exception ex) {
                String msg = "Failed to write the Plugin document to the file: " + filePath + ". " + GENERIC_EXCEPTION_MESSAGE;
                throw new ExportFailureException(msg, ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    String msg = "Failed to close file stream after writing WatchPoint Plugin file: " + filePath;
                    logger.warn((Object)msg, (Throwable)ex);
                }
            }
        }
    }

    protected final File getPluginLibFolder(File pluginRootFolder) {
        String folderName = "lib";
        return this.getLibraryFolder(pluginRootFolder, folderName);
    }

    protected final File getPluginClassesFolder(File pluginRootFolder) {
        String folderName = "classes";
        return this.getLibraryFolder(pluginRootFolder, folderName);
    }

    protected final File getPluginResourcesFolder(File pluginRootFolder) {
        String folderName = "resources";
        return this.getLibraryFolder(pluginRootFolder, folderName);
    }

    protected abstract String getPluginId(T var1, Map<String, Object> var2);

    protected abstract String getPluginVersion(T var1, Map<String, Object> var2);

    protected abstract void addPluginPointsAndExtensions(T var1, Map<String, Object> var2, Document var3, File var4) throws ExportFailureException;

    private File getLibraryFolder(File pluginRootFolder, String libraryFolderName) {
        File libraryFolder;
        String folderName = libraryFolderName == null ? "" : libraryFolderName.trim();
        File file = libraryFolder = folderName.length() > 0 ? new File(pluginRootFolder, folderName) : pluginRootFolder;
        if (!libraryFolder.exists()) {
            libraryFolder.mkdirs();
        }
        return libraryFolder;
    }

    private void copyRuntimeFiles(File pluginRootFolder, String libraryFolderName, List<String> libraryPaths, List<String> currentLibraries, boolean isJarFiles) throws ExportFailureException {
        if (libraryPaths == null) {
            libraryPaths = new ArrayList<String>();
        }
        String absolutePluginPath = pluginRootFolder.getAbsolutePath();
        int absolutePathSize = absolutePluginPath.length();
        if (!absolutePluginPath.endsWith(File.separator)) {
            ++absolutePathSize;
        }
        File libraryFolder = this.getLibraryFolder(pluginRootFolder, libraryFolderName);
        for (String libraryFilePath : libraryPaths) {
            String absoluteLibraryPath;
            String relativePath;
            String msg;
            File libraryFile = new File(libraryFilePath);
            File target = new File(libraryFolder, libraryFile.getName());
            if (isJarFiles && !libraryFile.isFile()) {
                msg = "Failure when attempting to copy file: " + libraryFile.getAbsolutePath() + ", source is not a file.";
                throw new ExportFailureException(msg);
            }
            if (!FileUtil.copyFileOrFolder(libraryFile, target, true)) {
                msg = "Failed to copy file/folder: " + libraryFile.getAbsolutePath() + " to location: " + target.getAbsolutePath() + " required for export of WatchPoint Plugin. " + GENERIC_EXCEPTION_MESSAGE;
                throw new ExportFailureException(msg);
            }
            if (!isJarFiles || currentLibraries.contains(relativePath = (absoluteLibraryPath = target.getAbsolutePath()).substring(absolutePathSize))) continue;
            currentLibraries.add(relativePath);
        }
        if (!isJarFiles) {
            String relativePath;
            String absoluteLibraryPath = libraryFolder.getAbsolutePath();
            String string = relativePath = absolutePathSize >= absoluteLibraryPath.length() ? File.separator : absoluteLibraryPath.substring(absolutePathSize);
            if (!relativePath.endsWith(File.separator)) {
                relativePath = String.valueOf(relativePath) + File.separator;
            }
            if (!currentLibraries.contains(relativePath)) {
                currentLibraries.add(relativePath);
            }
        }
    }
}

