/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import com.tandbergtv.watchpoint.studio.ui.model.WPTransition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.util.ConvertExprUtility;
import com.tandbergtv.watchpoint.studio.util.DecisionExprValidationUtil;
import com.tandbergtv.watchpoint.studio.util.SemanticElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.SuperState;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkflowTemplateExporter
implements IWatchPointDTOExporter<WorkflowTemplateDTO> {
    private static final String MODEL_ID = "ModelForExport";
    private static final Lock MODEL_LOCK = new ReentrantLock();

    @Override
    public Map<String, Object> export(WorkflowTemplateDTO template, Map<String, Object> exportInputs) throws ExportFailureException {
        try {
            String xml = template.getXml().replaceAll("\r", "");
            Map<String, Object> modelData = this.createWorkflowTemplate(xml);
            WorkflowTemplate templateModel = null;
            templateModel = (WorkflowTemplate)SemanticElementUtil.getSemanticElement(modelData);
            this.convertExpression((NodeElementContainer)templateModel);
            this.checkAndFixSuperStateNodeNames(templateModel);
            this.addResourceReleaseActions(templateModel);
            this.addResourceRequestActions(templateModel);
            this.removeNodeDefinitions((NodeElementContainer)templateModel);
            return modelData;
        }
        catch (ExportFailureException efe) {
            throw efe;
        }
        catch (Exception ex) {
            String msg = "Failed to export the Workflow Template.";
            throw new ExportFailureException(msg, ex);
        }
    }

    private Map<String, Object> createWorkflowTemplate(String xml) throws ExportFailureException {
        MODEL_LOCK.lock();
        try {
            Map<String, Object> map = SemanticElementUtil.createSemanticElement(MODEL_ID, xml, "org.jbpm.gd.jpdl.processDefinition");
            return map;
        }
        catch (Exception ex) {
            String msg = "Failed to construct Semantic Element: WorkflowTemplate from the XML String.";
            throw new ExportFailureException(msg, ex);
        }
        finally {
            MODEL_LOCK.unlock();
        }
    }

    private void convertExpression(NodeElementContainer parent) {
        NodeElement[] childNodes = parent.getNodeElements();
        if (childNodes == null) {
            return;
        }
        NodeElement[] nodeElementArray = childNodes;
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            this.convertNodeExpressions(node, parent);
            ++n2;
        }
    }

    private void convertNodeExpressions(NodeElement nodeElement, NodeElementContainer container) {
        Transition[] transitions;
        NodeDefinition nodeDefinition;
        Decision decision;
        String oldExpression;
        if (!(nodeElement instanceof AutomaticTaskNode) && nodeElement instanceof IDueDateElement) {
            IDurationElement duration;
            String oldDuration;
            IDueDateElement dueDate = (IDueDateElement)nodeElement;
            String oldDueDate = dueDate.getDueDate();
            if (oldDueDate != null && oldDueDate.trim().length() > 0) {
                String newDueDate = ConvertExprUtility.convertTimerExpression(oldDueDate);
                dueDate.setDueDate(newDueDate);
            }
            if (nodeElement instanceof IDurationElement && (oldDuration = (duration = (IDurationElement)nodeElement).getDuration()) != null && oldDuration.trim().length() > 0) {
                String newDuration = ConvertExprUtility.convertTimerExpression(oldDuration);
                duration.setDuration(newDuration);
            }
        }
        if (nodeElement instanceof Decision && (oldExpression = (decision = (Decision)nodeElement).getExpression()) != null && oldExpression.trim().length() > 0) {
            String newExpression = ConvertExprUtility.convertDecisionExpression(oldExpression);
            decision.setExpression(newExpression);
        }
        if (nodeElement instanceof NodeDefinition && (nodeDefinition = (NodeDefinition)nodeElement).getNodeType() == NodeDefinitionType.SuperState) {
            this.convertExpression(nodeDefinition);
        }
        Transition[] transitionArray = transitions = nodeElement.getTransitions();
        int n = transitions.length;
        int n2 = 0;
        while (n2 < n) {
            String oldExpression2;
            Transition transition = transitionArray[n2];
            Condition condition = transition.getCondition();
            String string = oldExpression2 = condition != null ? condition.getExpression() : null;
            if (oldExpression2 != null && oldExpression2.trim().length() > 0) {
                String newExpression = ConvertExprUtility.convertDecisionExpression(oldExpression2);
                condition.setExpression(newExpression);
            }
            ++n2;
        }
    }

    private void checkAndFixSuperStateNodeNames(WorkflowTemplate template) {
        NodeElement[] nodeElementArray = template.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            if (node instanceof NodeDefinition && ((NodeDefinition)node).getNodeType() != NodeDefinitionType.SingleNode) {
                NodeGroup superState = (NodeGroup)((NodeDefinition)node).getNode();
                NodeElement[] nodeElementArray2 = superState.getNodeElements();
                int n3 = nodeElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    NodeElement nodeElement = nodeElementArray2[n4];
                    int runner = 1;
                    boolean nameClash = false;
                    String oldName = nodeElement.getName();
                    String newName = null;
                    while (template.getNodeElementByName(nodeElement.getName()) != null) {
                        newName = String.valueOf(nodeElement.getNamePrefix()) + runner;
                        ++runner;
                        if (superState.getNodeElementByName(newName) != null) continue;
                        nodeElement.setName(newName);
                        nameClash = true;
                    }
                    if (nameClash) {
                        NodeElement[] nodeElementArray3 = superState.getNodeElements();
                        int n5 = nodeElementArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            NodeElement nodeElement2 = nodeElementArray3[n6];
                            Transition[] transitionArray = nodeElement2.getTransitions();
                            int n7 = transitionArray.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                Transition transition = transitionArray[n8];
                                if (transition.getTo().equals(oldName)) {
                                    transition.setTo(newName);
                                }
                                ++n8;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void addResourceReleaseActions(WorkflowTemplate template) {
        NodeElement[] nodeElementArray = template.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceGroup resourceGroup;
            NodeElement node = nodeElementArray[n2];
            if (node instanceof IResourceGroupElement && (resourceGroup = ((IResourceGroupElement)node).getResourceGroup()) != null && resourceGroup.getName() != null && resourceGroup.getName().length() != 0) {
                Action action = this.createAction(node.getTransitions()[0].getFactory());
                action.setRefName("resource-release");
                this.addRefAction((WPTransition)node.getTransitions()[0], action);
            }
            ++n2;
        }
    }

    private void addResourceRequestActions(WorkflowTemplate template) {
        NodeElement[] nodeElementArray = template.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceGroup resourceGroup;
            NodeElement node = nodeElementArray[n2];
            if (node instanceof IResourceGroupElement && (resourceGroup = ((IResourceGroupElement)node).getResourceGroup()) != null && resourceGroup.getName() != null && resourceGroup.getName().length() != 0) {
                NodeElement[] nodeElementArray2 = template.getNodeElements();
                int n3 = nodeElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    NodeElement currentNode = nodeElementArray2[n4];
                    Transition[] transitionArray = currentNode.getTransitions();
                    int n5 = transitionArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Transition transition = transitionArray[n6];
                        if (transition.getTo().equals(node.getName()) || transition.getTo().equals("/" + node.getName())) {
                            Action action = this.createAction(transition.getFactory());
                            action.setRefName("resource-request");
                            this.addRefAction((WPTransition)transition, action);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void removeNodeDefinitions(NodeElementContainer parent) {
        ArrayList<Object> orderedNodes = new ArrayList<Object>();
        boolean requiresReordering = false;
        NodeElement[] childNodes = parent.getNodeElements();
        if (childNodes == null) {
            return;
        }
        NodeElement[] nodeElementArray = childNodes;
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            if (nodeElement instanceof NodeDefinition) {
                NodeDefinition nodeDefinition = (NodeDefinition)nodeElement;
                this.removeUnmappedNodeDefinitionVariables(nodeDefinition);
                orderedNodes.add(nodeDefinition.getNode());
                requiresReordering = true;
                switch (nodeDefinition.getNodeType()) {
                    case SingleNode: {
                        this.fixSingleNodeNodeDefinition(parent, nodeDefinition);
                        break;
                    }
                    case SuperState: {
                        WorkflowTemplate template = (WorkflowTemplate)parent;
                        this.fixSuperStateNodeDefinition(template, nodeDefinition);
                    }
                }
            } else {
                orderedNodes.add(nodeElement);
            }
            ++n2;
        }
        if (requiresReordering) {
            nodeElementArray = parent.getNodeElements();
            n = nodeElementArray.length;
            n2 = 0;
            while (n2 < n) {
                NodeElement nodeElement = nodeElementArray[n2];
                parent.removeNodeElement(nodeElement);
                ++n2;
            }
            for (NodeElement nodeElement : orderedNodes) {
                parent.addNodeElement(nodeElement);
            }
        }
    }

    private void removeUnmappedNodeDefinitionVariables(NodeDefinition nodeDefinition) {
        ArrayList<WPVariable> nodeDefinitionVariables = new ArrayList<WPVariable>();
        if (nodeDefinition.getVariables() != null) {
            nodeDefinitionVariables.addAll(nodeDefinition.getVariables());
        }
        for (WPVariable variable : nodeDefinitionVariables) {
            String processVariableName;
            String string = processVariableName = variable != null ? variable.getName() : null;
            if (processVariableName != null && processVariableName.trim().length() != 0) continue;
            this.removeUnmappedNodeDefinitionVariable(nodeDefinition, variable);
        }
    }

    private void removeUnmappedNodeDefinitionVariable(NodeDefinition nodeDefinition, WPVariable variable) {
        NodeDefinitionType type = nodeDefinition.getNodeType();
        if (type == NodeDefinitionType.SingleNode) {
            AutomaticTaskNode node = (AutomaticTaskNode)nodeDefinition.getNode();
            node.removeVariable(variable.getMappedName());
        } else if (type == NodeDefinitionType.SuperState) {
            String superStateVariableName = variable.getMappedName();
            nodeDefinition.removeVariable(superStateVariableName);
            NodeElement[] nodeElements = nodeDefinition.getNodeElements();
            if (nodeElements == null) {
                return;
            }
            NodeElement[] nodeElementArray = nodeElements;
            int n = nodeElements.length;
            int n2 = 0;
            while (n2 < n) {
                NodeDefinition innerNodeDefinition;
                List<WPVariable> innerVariables;
                NodeElement nodeElement = nodeElementArray[n2];
                if (nodeElement instanceof NodeDefinition && (innerVariables = (innerNodeDefinition = (NodeDefinition)nodeElement).getVariables()) != null) {
                    AutomaticTaskNode node = (AutomaticTaskNode)innerNodeDefinition.getNode();
                    for (WPVariable innerVariable : innerVariables) {
                        if (!superStateVariableName.equals(innerVariable.getName())) continue;
                        node.removeVariable(innerVariable.getMappedName());
                    }
                }
                ++n2;
            }
        }
    }

    private void fixSingleNodeNodeDefinition(NodeElementContainer parent, NodeDefinition childNodeDefinition) {
        Transition[] transitions;
        AbstractNode containedNode = childNodeDefinition.getNode();
        Transition[] transitionArray = transitions = childNodeDefinition.getTransitions();
        int n = transitions.length;
        int n2 = 0;
        while (n2 < n) {
            Transition transition = transitionArray[n2];
            childNodeDefinition.removeTransition(transition);
            transition.setSource((NodeElement)containedNode);
            containedNode.addTransition(transition);
            ++n2;
        }
    }

    private void fixSuperStateNodeDefinition(WorkflowTemplate parent, NodeDefinition childNodeDefinition) {
        SuperState superState = (SuperState)childNodeDefinition.getNode();
        this.removeNodeDefinitionVariables(childNodeDefinition);
        this.removeNodeDefinitions((NodeElementContainer)superState);
        NodeElement entryNode = this.getSuperStateEntryNode(superState);
        String transitionPathToAppend = "/" + entryNode.getName();
        Set<Transition> inTransitions = this.getIncomingTransitions(parent, childNodeDefinition);
        for (Transition transition : inTransitions) {
            transition.setTo(String.valueOf(transition.getTo()) + transitionPathToAppend);
        }
        NodeElement exitNode = this.getSuperStateExitNode(superState);
        Set<Transition> exitTransitions = this.getTransitionsToNode(superState, exitNode);
        WPTransition nodeDefExitTransition = (WPTransition)childNodeDefinition.getTransitions()[0];
        childNodeDefinition.removeTransition(nodeDefExitTransition);
        for (Transition trans : exitTransitions) {
            WPTransition transition = (WPTransition)trans;
            transition.setTo("/" + nodeDefExitTransition.getTo());
            ActionElement[] actionElementArray = nodeDefExitTransition.getActionElements();
            int n = actionElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionElement action = actionElementArray[n2];
                if (action instanceof Action) {
                    Action newAction = this.cloneAction((Action)action, trans.getFactory());
                    this.addRefAction(transition, newAction);
                }
                ++n2;
            }
        }
        superState.removeNodeElement(exitNode);
    }

    private void removeNodeDefinitionVariables(NodeDefinition superStateNodeDefinition) {
        List<WPVariable> nodeDefinitionVars = superStateNodeDefinition.getVariables();
        NodeElement[] nodeElementArray = superStateNodeDefinition.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            if (nodeElement instanceof NodeDefinition) {
                NodeDefinition nestedNodeDefinition = (NodeDefinition)nodeElement;
                for (WPVariable var : nestedNodeDefinition.getVariables()) {
                    WPVariable nodeDefVar = this.findVariableByMappedName(nodeDefinitionVars, var.getName());
                    if (nestedNodeDefinition.getCompositeKey(var.getMappedName()) != null) {
                        nestedNodeDefinition.setCompositeKey(var.getMappedName(), nodeDefVar.getName());
                    }
                    var.setName(nodeDefVar.getName());
                }
            } else if (nodeElement instanceof Decision) {
                Decision decision = (Decision)nodeElement;
                String expression = decision.getExpression();
                if (expression != null && expression.length() > 0) {
                    Map<Integer, String> operandMap = DecisionExprValidationUtil.getOperands(decision.getExpression());
                    Object[] indexArray = operandMap.keySet().toArray();
                    Arrays.sort(indexArray);
                    int exprLength = expression.length();
                    Object[] objectArray = indexArray;
                    int n3 = indexArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object obj = objectArray[n4];
                        int index = (Integer)obj;
                        String operand = operandMap.get(index);
                        WPVariable nodeDefVar = this.findVariableByMappedName(nodeDefinitionVars, operand);
                        int newIndex = index - (exprLength - expression.length());
                        expression = String.valueOf(expression.substring(0, newIndex)) + nodeDefVar.getName() + expression.substring(newIndex + operand.length());
                        ++n4;
                    }
                }
                decision.setExpression(expression);
            }
            ++n2;
        }
    }

    private WPVariable findVariableByMappedName(List<WPVariable> variables, String mappedName) {
        for (WPVariable var : variables) {
            if (!var.getMappedName().equals(mappedName)) continue;
            return var;
        }
        return null;
    }

    private NodeElement getSuperStateEntryNode(SuperState superState) {
        HashSet<String> nodesWithIncomingTransition = new HashSet<String>();
        NodeElement[] nodeElementArray = superState.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            Transition[] transitionArray = node.getTransitions();
            int n3 = transitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Transition transition = transitionArray[n4];
                nodesWithIncomingTransition.add(transition.getTo());
                ++n4;
            }
            ++n2;
        }
        NodeElement entryNode = null;
        NodeElement[] nodeElementArray2 = superState.getNodeElements();
        int n5 = nodeElementArray2.length;
        n = 0;
        while (n < n5) {
            NodeElement node = nodeElementArray2[n];
            if (!nodesWithIncomingTransition.contains(node.getName())) {
                entryNode = node;
                break;
            }
            ++n;
        }
        return entryNode;
    }

    private NodeElement getSuperStateExitNode(SuperState superState) {
        NodeElement exitNode = null;
        NodeElement[] nodeElementArray = superState.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            if (node.getTransitions().length == 0) {
                exitNode = node;
                break;
            }
            ++n2;
        }
        return exitNode;
    }

    private Set<Transition> getTransitionsToNode(SuperState superState, NodeElement node) {
        HashSet<Transition> transitions = new HashSet<Transition>();
        NodeElement[] nodeElementArray = superState.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement currentNode = nodeElementArray[n2];
            Transition[] transitionArray = currentNode.getTransitions();
            int n3 = transitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Transition transition = transitionArray[n4];
                if (transition.getTo().equals(node.getName())) {
                    transitions.add(transition);
                }
                ++n4;
            }
            ++n2;
        }
        return transitions;
    }

    private Set<Transition> getIncomingTransitions(WorkflowTemplate template, NodeDefinition nodeDefinition) {
        HashSet<Transition> incomingTransitions = new HashSet<Transition>();
        NodeElement[] nodeElementArray = template.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            this.getIncomingTransitions(node, nodeDefinition, false, incomingTransitions);
            if (node instanceof NodeDefinition) {
                NodeDefinition currentNodeDefinition = (NodeDefinition)node;
                AbstractNode containedNode = currentNodeDefinition.getNode();
                switch (currentNodeDefinition.getNodeType()) {
                    case SingleNode: {
                        this.getIncomingTransitions((NodeElement)containedNode, nodeDefinition, false, incomingTransitions);
                        break;
                    }
                    case SuperState: {
                        SuperState containedSuperState = (SuperState)containedNode;
                        NodeElement[] nodeElementArray2 = containedSuperState.getNodeElements();
                        int n3 = nodeElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            NodeElement superStateNode = nodeElementArray2[n4];
                            this.getIncomingTransitions(superStateNode, nodeDefinition, true, incomingTransitions);
                            ++n4;
                        }
                        break;
                    }
                }
            }
            ++n2;
        }
        return incomingTransitions;
    }

    private void getIncomingTransitions(NodeElement source, NodeDefinition target, boolean isSuperStateNode, Set<Transition> incomingTransitions) {
        Transition[] transitionArray = source.getTransitions();
        int n = transitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transition transition = transitionArray[n2];
            if (this.isIncomingTransition(transition, (NodeElement)target, isSuperStateNode)) {
                incomingTransitions.add(transition);
            }
            ++n2;
        }
    }

    private boolean isIncomingTransition(Transition transition, NodeElement node, boolean fromSuperStateNode) {
        String dest = transition.getTo();
        String name = node.getName();
        String pathQualifiedName = "/" + name;
        return fromSuperStateNode ? dest.equals(pathQualifiedName) : dest.equals(name);
    }

    private void addRefAction(WPTransition transition, Action action) {
        if (!transition.hasAction(action.getRefName())) {
            transition.addActionElement((ActionElement)action);
        }
    }

    private Action cloneAction(Action action, SemanticElementFactory factory) {
        Action newAction = this.createAction(factory);
        newAction.setAsync(action.getAsync());
        newAction.setClassName(action.getClassName());
        newAction.setAcceptPropagatedEvents(action.getAcceptPropagatedEvents());
        newAction.setConfigInfo(action.getConfigInfo());
        newAction.setClassName(action.getClassName());
        newAction.setConfigType(action.getConfigType());
        newAction.setExpression(action.getExpression());
        newAction.setName(action.getName());
        newAction.setRefName(action.getRefName());
        return newAction;
    }

    private Action createAction(SemanticElementFactory factory) {
        return (Action)factory.createById("org.jbpm.gd.jpdl.action");
    }
}

