/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.WorkflowTemplateExporter;
import com.tandbergtv.watchpoint.studio.util.SemanticElementUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowTemplateFileExporter
extends WorkflowTemplateExporter {
    private static final Logger logger = Logger.getLogger(WorkflowTemplateFileExporter.class);

    @Override
    public Map<String, Object> export(WorkflowTemplateDTO template, Map<String, Object> exportInputs) throws ExportFailureException {
        try {
            Map<String, Object> output = super.export(template, exportInputs);
            XmlAdapter templateAdapter = SemanticElementUtil.getAdapter(output);
            Document templateDocument = templateAdapter.getNode().getOwnerDocument();
            String targetFilePath = (String)exportInputs.get("exportFilePath");
            this.writeDocumentToFile(templateDocument, targetFilePath);
            return new HashMap<String, Object>();
        }
        catch (ExportFailureException efe) {
            throw efe;
        }
        catch (Exception ex) {
            String msg = "Failed to export the Workflow Template to a File.";
            throw new ExportFailureException(msg, ex);
        }
    }

    private void writeDocumentToFile(Document document, String targetFilePath) throws ExportFailureException {
        Writer writer = null;
        try {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setAttribute("indent-number", "4");
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                File targetFile = new File(targetFilePath);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8");
                transformer.transform(new DOMSource(document), new StreamResult(writer));
            }
            catch (Exception ex) {
                String msg = "Failed to write the template document to file: " + targetFilePath;
                throw new ExportFailureException(msg, ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    String msg = "Failed to close file stream for file: " + targetFilePath;
                    logger.warn((Object)msg, (Throwable)ex);
                }
            }
        }
    }
}

