/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.lock.impl;

import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessFactory;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import com.tandbergtv.watchpoint.studio.lock.ILockOperationResult;
import com.tandbergtv.watchpoint.studio.lock.ILockStrategy;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.lock.LockAttributes;
import com.tandbergtv.watchpoint.studio.lock.LockFactory;
import com.tandbergtv.watchpoint.studio.lock.impl.LockOperationResult;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLockStrategy
implements ILockStrategy {
    private static final Logger logger = Logger.getLogger(DefaultLockStrategy.class);

    @Override
    public ILockOperationResult tryLock(String userId, ILockable lockableEntity, Map<String, Serializable> attributes, IPersistenceContext context) {
        Serializable overrideValue;
        DataAccessFactory daFactory = DataAccessFactory.createFactory();
        LockFactory lockFactory = LockFactory.createFactory();
        DataAccessInterface lockableDAO = null;
        DataAccessInterface lockDAO = null;
        lockableDAO = daFactory.createDataAccessObject(lockableEntity, context);
        ILockable refreshedEntity = lockableDAO.lock(lockableEntity.getKey());
        boolean overrideLock = false;
        if (attributes != null && (overrideValue = attributes.get(LockAttributes.OVERRIDE_LOCK.toString())) instanceof Boolean) {
            overrideLock = (Boolean)overrideValue;
        }
        ILock currentLock = null;
        boolean result = false;
        if (refreshedEntity != null) {
            currentLock = refreshedEntity.getLock();
            boolean bl = result = currentLock == null || overrideLock || currentLock.getOwnerId().equals(userId);
            if (result) {
                ILock newLock = lockFactory.createLock(userId);
                refreshedEntity.setLock(newLock);
                refreshedEntity = lockableDAO.update(refreshedEntity);
                if (currentLock != null) {
                    lockDAO = daFactory.createDataAccessObject(newLock, context);
                    lockDAO.delete(currentLock.getKey());
                }
            }
        }
        String entityDesc = this.getEntityDescription(refreshedEntity);
        StringBuilder logMsg = new StringBuilder();
        if (result) {
            logMsg.append("Locking Entity: ").append(entityDesc);
            logMsg.append(" with Lock: ");
            logMsg.append(this.getLockDescription(refreshedEntity.getLock()));
            if (currentLock != null) {
                logMsg.append(", overriding existing Lock: ");
                logMsg.append(this.getLockDescription(currentLock));
            }
        } else {
            logMsg.append("Failed to lock Entity: ").append(entityDesc);
            if (refreshedEntity != null) {
                logMsg.append(", already has Lock: ");
                logMsg.append(this.getLockDescription(currentLock));
            } else {
                logMsg.append(", entity does not exist.");
            }
        }
        logger.info((Object)logMsg.toString());
        return new LockOperationResult(result, refreshedEntity);
    }

    @Override
    public ILockOperationResult releaseLock(String userId, ILockable lockableEntity, IPersistenceContext context) {
        boolean result;
        DataAccessFactory daFactory = DataAccessFactory.createFactory();
        DataAccessInterface lockableDAO = null;
        DataAccessInterface lockDAO = null;
        lockableDAO = daFactory.createDataAccessObject(lockableEntity, context);
        ILockable refreshedEntity = lockableDAO.lock(lockableEntity.getKey());
        ILock currentLock = refreshedEntity != null ? refreshedEntity.getLock() : null;
        boolean bl = result = currentLock != null && currentLock.getOwnerId().equals(userId);
        if (result) {
            refreshedEntity.setLock(null);
            refreshedEntity = lockableDAO.update(refreshedEntity);
            lockDAO = daFactory.createDataAccessObject(currentLock, context);
            lockDAO.delete(currentLock.getKey());
        }
        String entityDesc = this.getEntityDescription(refreshedEntity);
        StringBuilder logMsg = new StringBuilder();
        if (result) {
            logMsg.append("Releasing lock for Entity: ").append(entityDesc);
            logMsg.append(" with Lock: ");
            logMsg.append(this.getLockDescription(currentLock));
        } else {
            logMsg.append("Failed to release lock for Entity: ").append(entityDesc);
            if (currentLock != null) {
                logMsg.append(" with Lock: ");
                logMsg.append(this.getLockDescription(currentLock));
                logMsg.append(", lock belongs to a different user.");
            } else {
                String msg = refreshedEntity != null ? ", entity is not locked." : ", entity does not exist.";
                logMsg.append(msg);
            }
        }
        logger.info((Object)logMsg.toString());
        return new LockOperationResult(result, refreshedEntity);
    }

    private String getEntityDescription(IPersistable entity) {
        return entity != null ? String.valueOf(entity.getClass().getName()) + "[" + entity.getKey() + "]" : "[null]";
    }

    private String getLockDescription(ILock lockObject) {
        return String.valueOf(this.getEntityDescription(lockObject)) + "[userId=" + lockObject.getOwnerId() + ", createDate=" + lockObject.getCreateDate() + "]";
    }
}

