/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service;

import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceValidationException
extends ServiceException {
    private static final long serialVersionUID = 7045667273830246578L;
    private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

    public ServiceValidationException() {
        super(ServiceErrorCode.GENERAL_VALIDATION_ERROR);
    }

    public ServiceValidationException(List<ValidationMessage> messages) {
        this();
        this.setValidationMessages(messages);
    }

    public ServiceValidationException(String message, List<ValidationMessage> messages) {
        super(ServiceErrorCode.GENERAL_VALIDATION_ERROR, message);
        this.setValidationMessages(messages);
    }

    public ServiceValidationException(String message, List<ValidationMessage> messages, Throwable cause) {
        super(ServiceErrorCode.GENERAL_VALIDATION_ERROR, message, cause);
        this.setValidationMessages(messages);
    }

    public List<ValidationMessage> getValidationMessages() {
        return this.messages;
    }

    void setValidationMessages(List<ValidationMessage> messages) {
        this.messages.clear();
        if (messages != null) {
            this.messages.addAll(messages);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append(" Validation Errors: ");
        for (ValidationMessage message : this.messages) {
            buf.append(System.getProperty("line.separator"));
            buf.append("\t").append(message.getCode());
            buf.append(": ").append(message.getElement().toString());
        }
        return buf.toString();
    }
}

