/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IMessageUIDGenerator;

public class MessageUIDGenerator
implements IMessageUIDGenerator {
    private static final String MESSAGE_UID_SEPARATOR = ".";
    private static final String NUMERIC_SET = "0123456789";
    private static final String CHARACTER_SET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public String generateMessageUID(Message message, ResourceType resourceType) {
        ApplicationProperties properties = ApplicationProperties.getInstance();
        String wfsSystemId = properties.getProperty("WFS.ResourceType.SystemId");
        String deploymentKey = properties.getProperty("DeploymentKey");
        String sourceId = message.isIncoming() ? resourceType.getSystemId() : wfsSystemId;
        String destinationId = message.isIncoming() ? wfsSystemId : resourceType.getSystemId();
        String messageId = this.generateMessageID(resourceType.getMessageSequenceNumber());
        String messageUID = String.valueOf(sourceId) + destinationId + messageId + MESSAGE_UID_SEPARATOR + deploymentKey;
        return messageUID.trim();
    }

    private String generateMessageID(int value) {
        String result = null;
        int numericSize = NUMERIC_SET.length();
        int alphaSize = CHARACTER_SET.length();
        int numberRange = numericSize * numericSize;
        int alphaRange = alphaSize * alphaSize;
        int mixedRange = numericSize * alphaSize;
        int range1 = numberRange - 1;
        int range2 = range1 + mixedRange;
        int range3 = range2 + mixedRange;
        int range4 = range3 + alphaRange;
        if (value < 0) {
            String msg = "The Message UID's sequence number must be generated from an integer value >= 0, got value: " + value;
            throw new IllegalArgumentException(msg);
        }
        if (value <= range1) {
            int index0 = value % numericSize;
            int index1 = value / numericSize;
            result = String.valueOf(NUMERIC_SET.charAt(index1)) + NUMERIC_SET.charAt(index0);
        } else if (value <= range2) {
            int index0 = (value -= range1 + 1) % numericSize;
            int index1 = value / numericSize;
            result = String.valueOf(CHARACTER_SET.charAt(index1)) + NUMERIC_SET.charAt(index0);
        } else if (value <= range3) {
            int index0 = (value -= range2 + 1) % alphaSize;
            int index1 = value / alphaSize;
            result = String.valueOf(NUMERIC_SET.charAt(index1)) + CHARACTER_SET.charAt(index0);
        } else if (value <= range4) {
            int index0 = (value -= range3 + 1) % alphaSize;
            int index1 = value / alphaSize;
            result = String.valueOf(CHARACTER_SET.charAt(index1)) + CHARACTER_SET.charAt(index0);
        } else {
            String msg = "The Message UID's sequence number must be generated from an integer value < " + range4 + ", got value: " + value;
            throw new IllegalArgumentException(msg);
        }
        return result;
    }
}

