/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import com.tandbergtv.watchpoint.studio.lock.ILockOperationResult;
import com.tandbergtv.watchpoint.studio.lock.ILockStrategy;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.lock.LockAttributes;
import com.tandbergtv.watchpoint.studio.lock.LockFactory;
import com.tandbergtv.watchpoint.studio.service.INodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.LockFailureException;
import com.tandbergtv.watchpoint.studio.service.ReferenceDeletionException;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionService
extends ServiceImpl
implements INodeDefinitionService {
    private static final String NODE_DEFINITION_ID_XPATH = "//nodeDefinition/@id";
    private static final String SEND_MESSAGE_UID_XPATH = "//action/send";
    private static final String RECEIVE_MESSAGE_UID_XPATH = "//action/receive";

    @Override
    public List<NodeDefinitionDTO> getAllNodeDefinitions() {
        Class[] types = new Class[]{};
        return (List)super.performOperation(types, new Object[0]);
    }

    @Override
    public List<NodeDefinitionDTO> getNodeDefinitionsByResourceType(long resourceTypeId) {
        Class[] types = new Class[]{Long.TYPE};
        return (List)super.performOperation(types, resourceTypeId);
    }

    @Override
    public List<NodeDefinitionDTO> getSingleNodeDefinitionsByResourceType(long resourceTypeId) {
        Class[] types = new Class[]{Long.TYPE};
        return (List)super.performOperation(types, resourceTypeId);
    }

    @Override
    public NodeDefinitionDTO getNodeDefinitionForView(long nodeDefinitionId) {
        Class[] types = new Class[]{Long.TYPE};
        return (NodeDefinitionDTO)super.performOperation(types, nodeDefinitionId);
    }

    @Override
    public NodeDefinitionDTO getNodeDefinitionForEdit(long nodeDefinitionId, String userId, boolean overrideLock) {
        Class[] types = new Class[]{Long.TYPE, String.class, Boolean.TYPE};
        return (NodeDefinitionDTO)super.performOperation(types, nodeDefinitionId, userId, overrideLock);
    }

    @Override
    public NodeDefinitionDTO createNodeDefinition(NodeDefinitionDTO nodeDefinition, String ownerId, boolean lockNodeDefinition) {
        Class[] types = new Class[]{NodeDefinitionDTO.class, String.class, Boolean.TYPE};
        return (NodeDefinitionDTO)super.performOperation(types, nodeDefinition, ownerId, lockNodeDefinition);
    }

    @Override
    public void deleteNodeDefinition(long nodeDefinitionId, String userId, boolean removeReferences) {
        Class[] types = new Class[]{Long.TYPE, String.class, Boolean.TYPE};
        super.performOperation(types, nodeDefinitionId, userId, removeReferences);
    }

    @Override
    public NodeDefinitionDTO saveNodeDefinition(NodeDefinitionDTO nodeDefinition, String userId) {
        Class[] types = new Class[]{NodeDefinitionDTO.class, String.class};
        return (NodeDefinitionDTO)super.performOperation(types, nodeDefinition, userId);
    }

    @Override
    public void closeNodeDefinition(long nodeDefinitionKey, String ownerId) {
        Class[] types = new Class[]{Long.TYPE, String.class};
        super.performOperation(types, nodeDefinitionKey, ownerId);
    }

    @Override
    public boolean nameExists(String name) {
        Class[] types = new Class[]{String.class};
        return (Boolean)super.performOperation(types, name);
    }

    @Override
    public boolean isUsedByTemplate(long nodeDefinitionId) {
        Class[] types = new Class[]{Long.TYPE};
        return (Boolean)super.performOperation(types, nodeDefinitionId);
    }

    @Override
    public boolean isUsedByNodeDefinition(long nodeDefinitionId) {
        Class[] types = new Class[]{Long.TYPE};
        return (Boolean)super.performOperation(types, nodeDefinitionId);
    }

    protected List<NodeDefinitionDTO> getAllNodeDefinitions(IPersistenceContext context) {
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        return nodeDefinitionDAO.findAll();
    }

    protected List<NodeDefinitionDTO> getNodeDefinitionsByResourceType(long resourceTypeId, IPersistenceContext context) {
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        return nodeDefinitionDAO.findByResourceType(resourceTypeId);
    }

    List<NodeDefinitionDTO> getSingleNodeDefinitionsByResourceType(long resourceTypeId, IPersistenceContext context) {
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        return nodeDefinitionDAO.findSingleNodeDefinitionsByResourceType(resourceTypeId);
    }

    protected NodeDefinitionDTO getNodeDefinitionForView(long nodeDefinitionId, IPersistenceContext context) {
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        return this.lockNodeDefinition(nodeDefinitionId, nodeDefinitionDAO);
    }

    protected NodeDefinitionDTO getNodeDefinitionForEdit(long nodeDefinitionId, String userId, boolean overrideLock, IPersistenceContext context) {
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        NodeDefinitionDTO nodeDefinition = this.lockNodeDefinition(nodeDefinitionId, nodeDefinitionDAO);
        if (nodeDefinition.getResourceType().isOutOfTheBox()) {
            throw new ServiceException(ServiceErrorCode.ND_EDIT_RESTYPE_OOB_ERROR);
        }
        ILockStrategy lockStrategy = LockFactory.createFactory().createLockStrategy();
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put(LockAttributes.OVERRIDE_LOCK.toString(), Boolean.valueOf(overrideLock));
        ILockOperationResult result = lockStrategy.tryLock(userId, nodeDefinition, attributes, context);
        if (!result.getOperationResult()) {
            String msg = "Failed to acquire a lock, cannot edit this node definition.";
            ILockable entity = result.getLockableEntity();
            throw new LockFailureException(ServiceErrorCode.ND_EDIT_LOCK_ERROR, entity, msg);
        }
        return (NodeDefinitionDTO)result.getLockableEntity();
    }

    protected NodeDefinitionDTO createNodeDefinition(NodeDefinitionDTO nodeDefinition, String ownerId, boolean lockNodeDefinition, IPersistenceContext context) {
        nodeDefinition.setId(-1L);
        Document nodeDefinitionDocument = this.loadNodeDefinitionDocument(nodeDefinition);
        String nodeDefinitionName = nodeDefinition.getName();
        if (nodeDefinitionName != null) {
            nodeDefinition.setName(nodeDefinitionName.trim());
        }
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        this.updateNodeDefinitionsUsed(nodeDefinition, nodeDefinitionDocument, nodeDefinitionDAO);
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        this.updateMessagesUsed(nodeDefinition, nodeDefinitionDocument, resourceTypeDAO);
        ILock lockObject = lockNodeDefinition ? LockFactory.createFactory().createLock(ownerId) : null;
        nodeDefinition.setLock(lockObject);
        this.validateNewNodeDefinition(nodeDefinition, context);
        return nodeDefinitionDAO.create(nodeDefinition);
    }

    protected void deleteNodeDefinition(long nodeDefinitionId, String userId, boolean removeReferences, IPersistenceContext context) {
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        NodeDefinitionDTO nodeDefinition = this.lockNodeDefinition(nodeDefinitionId, nodeDefinitionDAO);
        if (nodeDefinition.getResourceType().isOutOfTheBox()) {
            throw new ServiceException(ServiceErrorCode.ND_DELETE_RESTYPE_OOB_ERROR);
        }
        ILock nodeDefinitionLock = nodeDefinition.getLock();
        if (nodeDefinitionLock != null && !nodeDefinitionLock.getOwnerId().equals(userId)) {
            String msg = "The node definition is locked by another user, cannot delete this node definition.";
            throw new ServiceException(ServiceErrorCode.ND_DELETE_LOCKED_ERROR, msg);
        }
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        if (!removeReferences) {
            List<WorkflowTemplateDTO> templateList = templateDAO.findByNodeDefinitionUsage(nodeDefinitionId);
            List<NodeDefinitionDTO> parentList = nodeDefinitionDAO.findByParentUsage(nodeDefinitionId);
            ArrayList<IWatchPointDTO> references = new ArrayList<IWatchPointDTO>();
            references.addAll(templateList);
            references.addAll(parentList);
            if (!references.isEmpty()) {
                throw new ReferenceDeletionException(ServiceErrorCode.ND_NODE_DEFN_REFERENCED, references);
            }
        }
        nodeDefinitionDAO.deleteNodeDefinitionReferences(nodeDefinitionId);
        templateDAO.deleteNodeDefinitionReferences(nodeDefinitionId);
        nodeDefinitionDAO.delete(nodeDefinitionId);
    }

    protected NodeDefinitionDTO saveNodeDefinition(NodeDefinitionDTO nodeDefinition, String userId, IPersistenceContext context) {
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        NodeDefinitionDTO persistedNodeDefinition = (NodeDefinitionDTO)nodeDefinitionDAO.lock(nodeDefinition.getId());
        if (persistedNodeDefinition.getResourceType().isOutOfTheBox()) {
            throw new ServiceException(ServiceErrorCode.ND_EDIT_RESTYPE_OOB_ERROR);
        }
        ILock nodeDefinitionLock = persistedNodeDefinition.getLock();
        if (nodeDefinitionLock == null || !nodeDefinitionLock.getOwnerId().equals(userId)) {
            String msg = "The node definition is not currently locked for the user, cannot save this node definition.";
            throw new ServiceException(ServiceErrorCode.ND_SAVE_UNLOCKED_ERROR, msg);
        }
        nodeDefinition.setLock(persistedNodeDefinition.getLock());
        Document nodeDefinitionDocument = this.loadNodeDefinitionDocument(nodeDefinition);
        this.updateNodeDefinitionsUsed(nodeDefinition, nodeDefinitionDocument, nodeDefinitionDAO);
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        this.updateMessagesUsed(nodeDefinition, nodeDefinitionDocument, resourceTypeDAO);
        this.validateExistingNodeDefinition(nodeDefinition, persistedNodeDefinition, context);
        nodeDefinition = nodeDefinitionDAO.update(nodeDefinition);
        return nodeDefinition;
    }

    protected void closeNodeDefinition(long nodeDefinitionKey, String ownerId, IPersistenceContext context) {
        NodeDefinitionDTO nodeDefinition = new NodeDefinitionDTO();
        nodeDefinition.setId(nodeDefinitionKey);
        ILockStrategy lockStrategy = LockFactory.createFactory().createLockStrategy();
        lockStrategy.releaseLock(ownerId, nodeDefinition, context);
    }

    protected boolean nameExists(String name, IPersistenceContext context) {
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        return nodeDefinitionDAO.getCountByName(name) > 0;
    }

    protected boolean isUsedByTemplate(long nodeDefinitionId, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        return templateDAO.getCountByNodeDefinitionUsage(nodeDefinitionId) > 0;
    }

    protected boolean isUsedByNodeDefinition(long nodeDefinitionId, IPersistenceContext context) {
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        return nodeDefinitionDAO.getCountByParentUsage(nodeDefinitionId) > 0;
    }

    protected NodeDefinitionDTODAI createNodeDefinitionDAO(IPersistenceContext context) {
        Class<NodeDefinitionDTO> entityClass = NodeDefinitionDTO.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (NodeDefinitionDTODAI)dao;
    }

    protected ResourceTypeDAI createResourceTypeDAO(IPersistenceContext context) {
        Class<ResourceType> entityClass = ResourceType.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (ResourceTypeDAI)dao;
    }

    protected WorkflowTemplateDTODAI createTemplateDAO(IPersistenceContext context) {
        Class<WorkflowTemplateDTO> entityClass = WorkflowTemplateDTO.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (WorkflowTemplateDTODAI)dao;
    }

    private NodeDefinitionDTO lockNodeDefinition(long id, NodeDefinitionDTODAI nodeDefinitionDAO) {
        return (NodeDefinitionDTO)nodeDefinitionDAO.lock(id);
    }

    private Document loadNodeDefinitionDocument(NodeDefinitionDTO nodeDefinition) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            StringReader reader = new StringReader(nodeDefinition.getXml());
            return factory.newDocumentBuilder().parse(new InputSource(reader));
        }
        catch (Exception ex) {
            String msg = "Failed to load the node definition XML.";
            throw new ServiceException(ServiceErrorCode.ND_INVALID_XML, msg, ex);
        }
    }

    private void updateNodeDefinitionsUsed(NodeDefinitionDTO nodeDefinition, Document document, NodeDefinitionDTODAI nodeDefinitionDAO) {
        HashSet<NodeDefinitionDTO> nodeDefinitions = new HashSet<NodeDefinitionDTO>();
        nodeDefinition.setChildren(nodeDefinitions);
        HashSet<Long> nodeDefinitionKeys = new HashSet<Long>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(NODE_DEFINITION_ID_XPATH, document, XPathConstants.NODESET);
            int nodeCount = nodes != null ? nodes.getLength() : 0;
            int i = 0;
            while (i < nodeCount) {
                Node node = nodes.item(i);
                String nodeDefinitionIdValue = node.getNodeValue();
                if (nodeDefinitionIdValue != null && nodeDefinitionIdValue.trim().length() > 0) {
                    nodeDefinitionKeys.add(Long.parseLong(nodeDefinitionIdValue));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String msg = "Failed to get the list of Node Definition Ids specified in the Node Definition XML.";
            throw new ServiceException(ServiceErrorCode.ND_NODE_DEFN_UPDATE_ERROR, msg, ex);
        }
        List<NodeDefinitionDTO> usedDefns = nodeDefinitionDAO.findByKeys(nodeDefinitionKeys);
        if (usedDefns != null) {
            nodeDefinitions.addAll(usedDefns);
        }
    }

    private void updateMessagesUsed(NodeDefinitionDTO nodeDefinition, Document document, ResourceTypeDAI resourceTypeDAO) {
        HashSet<Message> messages = new HashSet<Message>();
        nodeDefinition.setMessages(messages);
        HashSet<String> messageUIDs = new HashSet<String>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList sendNodes = (NodeList)xpath.evaluate(SEND_MESSAGE_UID_XPATH, document, XPathConstants.NODESET);
            NodeList receiveNodes = (NodeList)xpath.evaluate(RECEIVE_MESSAGE_UID_XPATH, document, XPathConstants.NODESET);
            this.addMessages(sendNodes, messageUIDs);
            this.addMessages(receiveNodes, messageUIDs);
        }
        catch (Exception ex) {
            String msg = "Failed to get the list of Message Uids specified in the Node Definition XML.";
            throw new ServiceException(ServiceErrorCode.ND_MESSAGE_UPDATE_ERROR, msg, ex);
        }
        List<Message> usedMessages = resourceTypeDAO.getMessagesByUid(messageUIDs);
        if (usedMessages != null) {
            messages.addAll(usedMessages);
        }
    }

    private void addMessages(NodeList nodes, Set<String> messageUIDs) {
        int nodeCount = nodes != null ? nodes.getLength() : 0;
        int i = 0;
        while (i < nodeCount) {
            Node node = nodes.item(i);
            String uid = node.getTextContent().trim();
            if (uid != null && uid.trim().length() > 0) {
                messageUIDs.add(uid);
            }
            ++i;
        }
    }

    private void validateNewNodeDefinition(NodeDefinitionDTO nodeDefinition, IPersistenceContext context) {
        ValidationMessageCode code;
        NodeDefinitionDTODAI nodeDefinitionDAI = this.createNodeDefinitionDAO(context);
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String nodeDefinitionName = nodeDefinition.getName();
        if (nodeDefinitionName == null || nodeDefinitionName.length() == 0) {
            ValidationMessageCode code2 = ValidationMessageCode.NODEDEFINITION_NAME_BLANK;
            messages.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, code2));
        } else {
            int nodeDefinitionCount = nodeDefinitionDAI.getCountByName(nodeDefinition.getName());
            if (nodeDefinitionCount > 0) {
                code = ValidationMessageCode.NODEDEFINITION_NAME_NOT_UNIQUE;
                messages.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, code));
            }
        }
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        if (resourceTypeDAO.isOutOfTheBox(nodeDefinition.getResourceType().getId())) {
            code = ValidationMessageCode.NODEDEFINITION_CANNOT_CREATE_OOBRESTYPE;
            messages.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, code));
        }
        if (nodeDefinition.getType() == NodeDefinitionType.SuperState) {
            List<NodeDefinitionDTO> nodeDefs = nodeDefinitionDAI.findSuperStateNodeDefinitionsByMessages(nodeDefinition.getMessages());
            if (nodeDefs != null && !nodeDefs.isEmpty()) {
                ValidationMessageCode code3 = ValidationMessageCode.NODEDEFINITION_SAME_SET_MESSAGES_USED;
                messages.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, code3));
            }
        } else {
            Set<Message> msgs = nodeDefinition.getMessages();
            if (msgs.size() != 0) {
                if (msgs.size() > 1) {
                    throw new ServiceException(ServiceErrorCode.ND_INVALID_XML);
                }
                Message message = msgs.iterator().next();
                List<NodeDefinitionDTO> nodeDefs = nodeDefinitionDAI.findSingleNodeDefinitionsByMessage(message.getId());
                if (nodeDefs != null && !nodeDefs.isEmpty()) {
                    ValidationMessageCode code4 = ValidationMessageCode.NODEDEFINITION_SAME_MESSAGE_USED;
                    messages.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, code4));
                }
            }
        }
        if (messages.size() > 0) {
            String msg = "The node definition failed validation during creation.";
            throw new ServiceValidationException(msg, messages);
        }
    }

    private void validateExistingNodeDefinition(NodeDefinitionDTO nodeDefinition, NodeDefinitionDTO existingNodeDefinition, IPersistenceContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String nodeDefinitionName = existingNodeDefinition.getName();
        if (nodeDefinitionName == null || nodeDefinitionName.length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.NODEDEFINITION_NAME_BLANK;
            messages.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, code));
        }
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        if (existingNodeDefinition.getType() == NodeDefinitionType.SuperState) {
            List<NodeDefinitionDTO> nodeDefs = nodeDefinitionDAO.findSuperStateNodeDefinitionsByMessages(nodeDefinition.getMessages());
            if (nodeDefs != null && (nodeDefs.size() > 1 || nodeDefs.size() == 1 && nodeDefs.get(0).getId() != existingNodeDefinition.getId())) {
                ValidationMessageCode code = ValidationMessageCode.NODEDEFINITION_SAME_SET_MESSAGES_USED;
                messages.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, code));
            }
        } else {
            Set<Message> msgs = nodeDefinition.getMessages();
            if (msgs.size() != 0) {
                if (msgs.size() > 1) {
                    throw new ServiceException(ServiceErrorCode.ND_INVALID_XML);
                }
                Message message = msgs.iterator().next();
                List<NodeDefinitionDTO> nodeDefs = nodeDefinitionDAO.findSingleNodeDefinitionsByMessage(message.getId());
                if (nodeDefs != null && nodeDefs.size() > 1) {
                    ValidationMessageCode code = ValidationMessageCode.NODEDEFINITION_SAME_MESSAGE_USED;
                    messages.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, code));
                }
            }
        }
        if (messages.size() > 0) {
            String msg = "The node definition failed validation when updating.";
            throw new ServiceValidationException(msg, messages);
        }
    }
}

