/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.ProtectionKeyDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.WatchPointDTOExporterFactory;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupService
extends ServiceImpl
implements IResourceGroupService {
    @Override
    public List<ResourceGroup> getAllResourceGroups() {
        Class[] types = new Class[]{};
        return (List)super.performOperation(types, new Object[0]);
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResourceType(long resourceTypeId) {
        Class[] types = new Class[]{Long.TYPE};
        return (List)super.performOperation(types, resourceTypeId);
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByHumanResourceType() {
        Class[] types = new Class[]{};
        return (List)super.performOperation(types, new Object[0]);
    }

    @Override
    public ResourceGroup getResourceGroup(long resourceGroupId) {
        Class[] types = new Class[]{Long.TYPE};
        return (ResourceGroup)super.performOperation(types, resourceGroupId);
    }

    @Override
    public ResourceGroup getResourceGroupByName(String name) {
        Class[] types = new Class[]{String.class};
        return (ResourceGroup)super.performOperation(types, name);
    }

    @Override
    public ProtectionKey getProtectionKeyByResourceGroupName(String name) {
        Class[] types = new Class[]{String.class};
        return (ProtectionKey)super.performOperation(types, name);
    }

    @Override
    public List<String> getAllFunctionalTypesForResourceType(long resourceTypeId) {
        Class[] types = new Class[]{Long.TYPE};
        return (List)super.performOperation(types, resourceTypeId);
    }

    @Override
    public boolean isNameExists(String name) {
        Class[] types = new Class[]{String.class};
        return (Boolean)super.performOperation(types, name);
    }

    @Override
    public ResourceGroup createResourceGroup(ResourceGroup group) {
        Class[] types = new Class[]{ResourceGroup.class};
        return (ResourceGroup)super.performOperation(types, group);
    }

    @Override
    public ResourceGroup updateResourceGroup(ResourceGroup group) {
        Class[] types = new Class[]{ResourceGroup.class};
        return (ResourceGroup)super.performOperation(types, group);
    }

    @Override
    public void deleteResourceGroup(ResourceGroup group) {
        Class[] types = new Class[]{ResourceGroup.class};
        super.performOperation(types, group);
    }

    @Override
    public ResourceGroup exportResourceGroup(ResourceGroup group, Map<String, Object> exportInputs) throws ExportFailureException {
        Class[] types = new Class[]{ResourceGroup.class};
        ResourceGroup rgInDB = (ResourceGroup)super.performOperation(types, group);
        WatchPointDTOExporterFactory exporterFactory = WatchPointDTOExporterFactory.createFactory();
        IWatchPointDTOExporter<ResourceGroup> exporter = exporterFactory.getExporter(ResourceGroup.class);
        exporter.export(rgInDB, exportInputs);
        return rgInDB;
    }

    @Override
    public List<ProtectionKey> getAllProtectionKeys() {
        Class[] types = new Class[]{};
        return (List)super.performOperation(types, new Object[0]);
    }

    protected List<ResourceGroup> getAllResourceGroups(IPersistenceContext context) {
        return this.createResourceGroupDAO(context).findAll();
    }

    protected List<ResourceGroup> getResourceGroupsByResourceType(long resourceTypeId, IPersistenceContext context) {
        return this.createResourceGroupDAO(context).findByResourceType(resourceTypeId);
    }

    protected List<ResourceGroup> getResourceGroupsByHumanResourceType(IPersistenceContext context) {
        ApplicationProperties properties = ApplicationProperties.getInstance();
        String humanSystemId = properties.getProperty("Human.ResourceType.SystemId");
        return this.createResourceGroupDAO(context).findByResourceTypeSystemId(humanSystemId);
    }

    protected ResourceGroup getResourceGroup(long resourceGroupId, IPersistenceContext context) {
        return (ResourceGroup)this.createResourceGroupDAO(context).find(resourceGroupId);
    }

    protected ResourceGroup getResourceGroupByName(String name, IPersistenceContext context) {
        return this.createResourceGroupDAO(context).findByName(name);
    }

    protected ProtectionKey getProtectionKeyByResourceGroupName(String name, IPersistenceContext context) {
        return this.createResourceGroupDAO(context).findProtectionKeyByName(name);
    }

    protected List<String> getAllFunctionalTypesForResourceType(long resourceTypeId, IPersistenceContext context) {
        return this.createResourceGroupDAO(context).getAllFunctionalTypesForResourceType(resourceTypeId);
    }

    protected Boolean isNameExists(String name, IPersistenceContext context) {
        return this.createResourceGroupDAO(context).isNameExists(name);
    }

    protected ResourceGroup createResourceGroup(ResourceGroup group, IPersistenceContext context) {
        List<ValidationMessage> messages = this.validateForCreate(group, context);
        if (messages != null && !messages.isEmpty()) {
            throw new ServiceValidationException(messages);
        }
        group.setVersion(1);
        group.setDirty(true);
        if (group.getProtectionKey().getId() == -1L) {
            group.setProtectionKey(this.createProtectionKeyDAO(context).create(group.getProtectionKey()));
        }
        return this.createResourceGroupDAO(context).create(group);
    }

    protected ResourceGroup updateResourceGroup(ResourceGroup group, IPersistenceContext context) {
        ResourceGroup resourceGroupInDB = (ResourceGroup)this.createResourceGroupDAO(context).find(group.getKey());
        List<ValidationMessage> messages = this.validateForUpdate(group, resourceGroupInDB, context);
        if (messages != null && !messages.isEmpty()) {
            throw new ServiceValidationException(messages);
        }
        if (resourceGroupInDB.isDirty()) {
            group.setVersion(resourceGroupInDB.getVersion());
        } else {
            group.setVersion(resourceGroupInDB.getVersion() + 1);
        }
        group.setDirty(true);
        if (group.getProtectionKey().getId() == -1L) {
            group.setProtectionKey(this.createProtectionKeyDAO(context).create(group.getProtectionKey()));
        }
        return this.createResourceGroupDAO(context).update(group);
    }

    protected void deleteResourceGroup(ResourceGroup group, IPersistenceContext context) {
        boolean usedByTemplates;
        boolean exported;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        ResourceGroupDAI rgDAO = this.createResourceGroupDAO(context);
        ResourceGroup resourceGroupInDB = (ResourceGroup)rgDAO.find(group.getKey());
        if (resourceGroupInDB.getVersion() == 1 && resourceGroupInDB.isDirty()) {
            exported = false;
        } else {
            exported = true;
            messages.add(new ValidationMessage(resourceGroupInDB, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_CANTDEL_EXPORTED));
        }
        WorkflowTemplateDTODAI templateDAO = this.createWorkflowTemplateDAO(context);
        int templateUserCount = templateDAO.getCountByResourceGroupUsage(group.getId());
        if (templateUserCount > 0) {
            usedByTemplates = true;
            messages.add(new ValidationMessage(resourceGroupInDB, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_CANTDEL_USEDBYTEMPLATE));
        } else {
            usedByTemplates = false;
        }
        if (exported || usedByTemplates) {
            throw new ServiceValidationException(messages);
        }
        rgDAO.delete(resourceGroupInDB.getKey());
    }

    protected ResourceGroup exportResourceGroup(ResourceGroup group, IPersistenceContext context) throws ExportFailureException {
        ResourceGroupDAI rgDAO = this.createResourceGroupDAO(context);
        ResourceGroup rgInDB = (ResourceGroup)rgDAO.find(group.getKey());
        rgInDB.setDirty(false);
        rgDAO.update(rgInDB);
        return rgInDB;
    }

    protected List<ProtectionKey> getAllProtectionKeys(IPersistenceContext context) {
        return this.createProtectionKeyDAO(context).findAll();
    }

    private WorkflowTemplateDTODAI createWorkflowTemplateDAO(IPersistenceContext context) {
        Class<WorkflowTemplateDTO> entityClass = WorkflowTemplateDTO.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (WorkflowTemplateDTODAI)dao;
    }

    private ResourceGroupDAI createResourceGroupDAO(IPersistenceContext context) {
        Class<ResourceGroup> entityClass = ResourceGroup.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (ResourceGroupDAI)dao;
    }

    private ResourceTypeDAI createResourceTypeDAO(IPersistenceContext context) {
        Class<ResourceType> entityClass = ResourceType.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (ResourceTypeDAI)dao;
    }

    private ProtectionKeyDAI createProtectionKeyDAO(IPersistenceContext context) {
        Class<ProtectionKey> entityClass = ProtectionKey.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (ProtectionKeyDAI)dao;
    }

    protected List<ValidationMessage> validateForCreate(ResourceGroup group, IPersistenceContext context) {
        List<ValidationMessage> uiValidationMessages = this.validateResourceGroup(group);
        if (uiValidationMessages != null && !uiValidationMessages.isEmpty()) {
            return uiValidationMessages;
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.isNameExists(group.getName(), context).booleanValue()) {
            messages.add(new ValidationMessage(group, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_NAME_NOT_UNIQUE));
        }
        if (this.createResourceTypeDAO(context).find(group.getResourceType().getKey()) == null) {
            messages.add(new ValidationMessage(group, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_RESOURCETYPE_NOTEXISTS));
        }
        return messages;
    }

    protected List<ValidationMessage> validateForUpdate(ResourceGroup group, ResourceGroup resourceGroupInDB, IPersistenceContext context) {
        List<ValidationMessage> uiValidationMessages = this.validateResourceGroup(group);
        if (uiValidationMessages != null && !uiValidationMessages.isEmpty()) {
            return uiValidationMessages;
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (!group.getName().equals(resourceGroupInDB.getName())) {
            messages.add(new ValidationMessage(group, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_NAME_CHANGED));
        }
        if (!resourceGroupInDB.getResourceType().equals(group.getResourceType())) {
            messages.add(new ValidationMessage(group, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_RESOURCETYPE_CHANGED));
        }
        return messages;
    }

    protected List<ValidationMessage> validateResourceGroup(ResourceGroup group) {
        ValidationServiceFactory factory = ValidationServiceFactory.createFactory();
        IValidationService validationService = factory.createValidationService();
        return validationService.validateResourceGroup(group);
    }
}

