/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.dataaccess.ConnectionTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.WatchPointDTOExporterFactory;
import com.tandbergtv.watchpoint.studio.service.IMessageUIDGenerator;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeService
extends ServiceImpl
implements IResourceTypeService {
    private static final int MAX_UIDGEN_RETRY_COUNT = 100;

    @Override
    public List<ResourceType> getResourceTypeList() {
        Class[] types = new Class[]{};
        return (List)this.performOperation(types, new Object[0]);
    }

    @Override
    public List<ResourceType> getViewableResourceTypeList() {
        Class[] types = new Class[]{};
        return (List)this.performOperation(types, new Object[0]);
    }

    @Override
    public List<ResourceType> getViewableNonOOBResourceTypeList() {
        ArrayList<ResourceType> oobResTypes = new ArrayList<ResourceType>();
        List<ResourceType> allResTypes = this.getViewableResourceTypeList();
        if (allResTypes != null) {
            for (ResourceType resType : allResTypes) {
                if (resType.isOutOfTheBox()) continue;
                oobResTypes.add(resType);
            }
        }
        return oobResTypes;
    }

    @Override
    public ResourceType getResourceType(long resourceTypeId) {
        Class[] types = new Class[]{Long.TYPE};
        return (ResourceType)this.performOperation(types, resourceTypeId);
    }

    @Override
    public ResourceType getResourceTypeByName(String name) {
        Class[] types = new Class[]{String.class};
        return (ResourceType)this.performOperation(types, name);
    }

    @Override
    public ResourceType getResourceTypeBySystemId(String systemId) {
        Class[] types = new Class[]{String.class};
        return (ResourceType)this.performOperation(types, systemId);
    }

    @Override
    public ResourceType createResourceType(ResourceType resourceType) {
        Class[] types = new Class[]{ResourceType.class};
        return (ResourceType)this.performOperation(types, resourceType);
    }

    @Override
    public ResourceType updateResourceType(ResourceType resourceType) {
        Class[] types = new Class[]{ResourceType.class};
        return (ResourceType)this.performOperation(types, resourceType);
    }

    @Override
    public void deleteResourceType(long resourceTypeId) {
        Class[] types = new Class[]{Long.TYPE};
        this.performOperation(types, resourceTypeId);
    }

    @Override
    public ResourceType exportResourceType(long resourceTypeId, Map<String, Object> parameters) throws ExportFailureException {
        Class[] types = new Class[]{Long.TYPE};
        ResourceType resourceType = (ResourceType)this.performOperation(types, resourceTypeId);
        WatchPointDTOExporterFactory exporterFactory = WatchPointDTOExporterFactory.createFactory();
        IWatchPointDTOExporter<ResourceType> exporter = exporterFactory.getExporter(ResourceType.class);
        exporter.export(resourceType, parameters);
        return resourceType;
    }

    @Override
    public List<ValidationMessage> validateResourceType(long resourceTypeId) {
        Class[] types = new Class[]{Long.TYPE};
        return (List)this.performOperation(types, resourceTypeId);
    }

    @Override
    public boolean isResourceTypeNameUnique(String name) {
        Class[] types = new Class[]{String.class};
        return (Boolean)this.performOperation(types, name);
    }

    @Override
    public boolean isResourceTypeSystemIdUnique(String systemId) {
        Class[] types = new Class[]{String.class};
        return (Boolean)this.performOperation(types, systemId);
    }

    @Override
    public boolean isMessageNameUnique(long resourceTypeId, String name) {
        Class[] types = new Class[]{Long.TYPE, String.class};
        return (Boolean)this.performOperation(types, resourceTypeId, name);
    }

    @Override
    public List<Message> getResourceTypeMessages(long resourceTypeId) {
        Class[] types = new Class[]{Long.TYPE};
        return (List)this.performOperation(types, resourceTypeId);
    }

    @Override
    public List<Message> getUnusedResourceTypeMessages(long resourceTypeId) {
        Class[] types = new Class[]{Long.TYPE};
        return (List)this.performOperation(types, resourceTypeId);
    }

    @Override
    public List<Message> getUnusedResourceTypeMessages(long resourceTypeId, long nodeDefinitionId) {
        Class[] types = new Class[]{Long.TYPE, Long.TYPE};
        return (List)this.performOperation(types, resourceTypeId, nodeDefinitionId);
    }

    @Override
    public Message findMessageByUID(String messageUID) {
        Class[] types = new Class[]{String.class};
        return (Message)this.performOperation(types, messageUID);
    }

    @Override
    public List<ConnectionType> getAllConnectionTypes() {
        Class[] types = new Class[]{};
        return (List)this.performOperation(types, new Object[0]);
    }

    @Override
    public Message createMessage(Message message) {
        Class[] types = new Class[]{Message.class};
        return (Message)this.performOperation(types, message);
    }

    @Override
    public void deleteMessage(long messageId) {
        Class[] types = new Class[]{Long.TYPE};
        this.performOperation(types, messageId);
    }

    protected List<ResourceType> getResourceTypeList(IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        return resourceTypeDAO.findAll();
    }

    protected List<ResourceType> getViewableResourceTypeList(IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        return resourceTypeDAO.findAllViewable();
    }

    protected ResourceType getResourceType(long resourceTypeId, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        return this.lockResourceType(resourceTypeId, resourceTypeDAO);
    }

    protected ResourceType getResourceTypeByName(String name, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        return resourceTypeDAO.findByName(name);
    }

    protected ResourceType getResourceTypeBySystemId(String systemId, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        return resourceTypeDAO.findBySystemId(systemId);
    }

    protected ResourceType createResourceType(ResourceType resourceType, IPersistenceContext context) {
        String systemId;
        resourceType.setId(-1L);
        resourceType.setVersion(1);
        resourceType.setDirty(true);
        resourceType.setMessageSequenceNumber(1);
        resourceType.setMessages(new HashSet<Message>());
        String name = resourceType.getName();
        if (name != null) {
            resourceType.setName(name.trim());
        }
        if ((systemId = resourceType.getSystemId()) != null) {
            resourceType.setSystemId(systemId.trim());
        }
        this.validateCreation(resourceType, context);
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        return resourceTypeDAO.create(resourceType);
    }

    protected ResourceType updateResourceType(ResourceType resourceType, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO;
        long resourceTypeId = resourceType.getId();
        ResourceType currentResourceType = this.lockResourceType(resourceTypeId, resourceTypeDAO = this.createResourceTypeDAO(context));
        if (currentResourceType.isOutOfTheBox()) {
            String message = "Modifying an out-of-the-box Resource Type is not allowed.";
            throw new ServiceException(ServiceErrorCode.RESOURCE_TYPE_CANNOT_UPDATE_OOBRESTYPE, message);
        }
        int currentVersion = currentResourceType.getVersion();
        if (!currentResourceType.isDirty()) {
            ++currentVersion;
        }
        resourceType.setVersion(currentVersion);
        resourceType.setDirty(true);
        resourceType.setMessageSequenceNumber(currentResourceType.getMessageSequenceNumber());
        resourceType.setMessages(this.getMessagesForUpdate(resourceType, currentResourceType));
        this.validateModification(resourceType, currentResourceType, context);
        MessageDAI messageDAO = this.createMessageDAO(context);
        for (Message message : resourceType.getMessages()) {
            messageDAO.update(message);
        }
        return resourceTypeDAO.update(resourceType);
    }

    protected void deleteResourceType(long resourceTypeId, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        MessageDAI messageDAO = this.createMessageDAO(context);
        ResourceType resourceType = this.lockResourceType(resourceTypeId, resourceTypeDAO);
        this.validateDeletion(resourceType, context);
        Set<Message> messages = resourceType.getMessages();
        if (messages != null) {
            for (Message message : messages) {
                messageDAO.delete(message.getId());
            }
        }
        resourceTypeDAO.delete(resourceTypeId);
    }

    protected ResourceType exportResourceType(long resourceTypeId, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        ResourceType resourceType = this.lockResourceType(resourceTypeId, resourceTypeDAO);
        this.validateExport(resourceType);
        if (!resourceType.isDirty()) {
            resourceType.setVersion(resourceType.getVersion() + 1);
        }
        resourceType.setDirty(false);
        resourceType = resourceTypeDAO.update(resourceType);
        return resourceType;
    }

    protected List<ValidationMessage> validateResourceType(long resourceTypeId, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        ResourceType resourceType = this.lockResourceType(resourceTypeId, resourceTypeDAO);
        return this.validateResourceType(resourceType);
    }

    protected boolean isResourceTypeNameUnique(String name, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        return resourceTypeDAO.getCountByName(name) == 0;
    }

    protected boolean isResourceTypeSystemIdUnique(String systemId, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        return resourceTypeDAO.getCountBySystemId(systemId) == 0;
    }

    protected boolean isMessageNameUnique(long resourceTypeId, String name, IPersistenceContext context) {
        MessageDAI messageDAO = this.createMessageDAO(context);
        return messageDAO.getCountByResourceTypeAndName(resourceTypeId, name) == 0;
    }

    protected List<Message> getResourceTypeMessages(long resourceTypeId, IPersistenceContext context) {
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        return resourceTypeDAO.getMessagesById(resourceTypeId);
    }

    protected List<Message> getUnusedResourceTypeMessages(long resourceTypeId, IPersistenceContext context) {
        return this.createMessageDAO(context).findUnusedByResourceType(resourceTypeId);
    }

    protected List<Message> getUnusedResourceTypeMessages(long resourceTypeId, long nodeDefinitionId, IPersistenceContext context) {
        return this.createMessageDAO(context).findUnusedByResourceType(resourceTypeId, nodeDefinitionId);
    }

    protected Message findMessageByUID(String messageUID, IPersistenceContext context) {
        return this.createMessageDAO(context).findByUID(messageUID);
    }

    protected List<ConnectionType> getAllConnectionTypes(IPersistenceContext context) {
        ConnectionTypeDAI connectionTypeDAO = this.createConnectionTypeDAO(context);
        return connectionTypeDAO.findAll();
    }

    protected Message createMessage(Message message, IPersistenceContext context) {
        String uid;
        String name;
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        long resourceTypeId = message.getResourceType().getId();
        ResourceType currentResourceType = this.lockResourceType(resourceTypeId, resourceTypeDAO);
        if (currentResourceType.isOutOfTheBox()) {
            String errMsg = "Cannot create a new Message for an out-of-the-box Resource Type.";
            throw new ServiceException(ServiceErrorCode.MESSAGE_CANNOT_CREATE_OOBRESTYPE, errMsg);
        }
        ResourceType clonedResourceType = currentResourceType.clone();
        clonedResourceType.addMessage(message);
        boolean generateUID = message.isUIDGenerationRequired();
        if (generateUID) {
            this.generateMessageUID(clonedResourceType, message);
            int sequence = clonedResourceType.getMessageSequenceNumber();
            currentResourceType.setMessageSequenceNumber(sequence);
        }
        if ((name = message.getName()) != null) {
            message.setName(name.trim());
        }
        if ((uid = message.getUid()) != null) {
            message.setUid(uid.trim());
        }
        this.validateMessageCreation(message, context);
        int currentVersion = currentResourceType.getVersion();
        if (!currentResourceType.isDirty()) {
            ++currentVersion;
        }
        currentResourceType.setVersion(currentVersion);
        currentResourceType.setDirty(true);
        resourceTypeDAO.update(currentResourceType);
        MessageDAI messageDAO = this.createMessageDAO(context);
        return messageDAO.create(message);
    }

    protected void deleteMessage(long messageId, IPersistenceContext context) {
        MessageDAI messageDAO = this.createMessageDAO(context);
        Message message = (Message)messageDAO.find(messageId);
        if (message == null) {
            return;
        }
        long resourceTypeId = message.getResourceType().getId();
        ResourceTypeDAI resourceTypeDAO = this.createResourceTypeDAO(context);
        ResourceType resourceType = this.lockResourceType(resourceTypeId, resourceTypeDAO);
        this.validateMessageDeletion(message, resourceType, context);
        if (!resourceType.isDirty()) {
            resourceType.setVersion(resourceType.getVersion() + 1);
            resourceType.setDirty(true);
            resourceTypeDAO.update(resourceType);
        }
        messageDAO.delete(messageId);
    }

    private void validateCreation(ResourceType resourceType, IPersistenceContext context) {
        List<ValidationMessage> fvMessages;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (resourceType.isOutOfTheBox()) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_CANNOT_CREATE_OOB;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
        this.validateUniqueResourceTypeName(resourceType, context, messages);
        String systemId = resourceType.getSystemId();
        if (!this.isResourceTypeSystemIdUnique(systemId, context)) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_SYSTEM_ID_NOT_UNIQUE;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
        if ((fvMessages = this.validateResourceType(resourceType)) != null) {
            messages.addAll(fvMessages);
        }
        if (this.isInvalid(messages)) {
            String msg = "The Resource Type failed validation during creation.";
            throw new ServiceValidationException(msg, messages);
        }
    }

    private void validateModification(ResourceType resourceType, ResourceType currentResourceType, IPersistenceContext context) {
        List<ValidationMessage> fvMessages;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (!currentResourceType.getName().equalsIgnoreCase(resourceType.getName())) {
            this.validateUniqueResourceTypeName(resourceType, context, messages);
        }
        if (!currentResourceType.getSystemId().equals(resourceType.getSystemId())) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_SYSTEM_ID_CHANGED;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
        if (resourceType.getMessages() != null) {
            HashMap<Long, Message> existingMessages = new HashMap<Long, Message>();
            for (Message message : currentResourceType.getMessages()) {
                existingMessages.put(message.getKey(), message);
            }
            for (Message message : resourceType.getMessages()) {
                ValidationMessageCode code;
                Message currentMessage = (Message)existingMessages.get(message.getKey());
                if (currentMessage == null) continue;
                if (!currentMessage.getUid().equals(message.getUid())) {
                    code = ValidationMessageCode.MESSAGE_UID_CHANGED;
                    messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
                }
                if (currentMessage.isIncoming() == message.isIncoming()) continue;
                code = ValidationMessageCode.MESSAGE_DIRECTION_CHANGED;
                messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
            }
        }
        if ((fvMessages = this.validateResourceType(resourceType)) != null) {
            messages.addAll(fvMessages);
        }
        if (this.isInvalid(messages)) {
            String msg = "The Resource Type failed validation during modification.";
            throw new ServiceValidationException(msg, messages);
        }
    }

    private void validateDeletion(ResourceType resourceType, IPersistenceContext context) {
        if (resourceType.isOutOfTheBox()) {
            String message = "Cannot delete an out-of-the-box Resource Type.";
            throw new ServiceException(ServiceErrorCode.RT_DELETE_OOB_ERROR, message);
        }
        if (resourceType.getVersion() > 1 || !resourceType.isDirty()) {
            String msg = "The resource type has already been exported, cannot delete this resource type.";
            throw new ServiceException(ServiceErrorCode.RT_DELETE_EXPORTED_ERROR, msg);
        }
        long resourceTypeId = resourceType.getId();
        ResourceGroupDAI resourceGroupDAI = this.createResourceGroupDAO(context);
        int groupCount = resourceGroupDAI.getCountByResourceType(resourceTypeId);
        if (groupCount > 0) {
            String msg = "The resource type is being used by existing resource groups, cannot delete this resource type.";
            throw new ServiceException(ServiceErrorCode.RT_DELETE_USED_BY_RESOURCE_GROUP_ERROR, msg);
        }
        NodeDefinitionDTODAI nodeDefinitionDAI = this.createNodeDefinitionDAO(context);
        int nodeDefinitionCount = nodeDefinitionDAI.getCountByResourceType(resourceTypeId);
        if (nodeDefinitionCount > 0) {
            String msg = "The resource type is being used by existing node definitions, cannot delete this resource type.";
            throw new ServiceException(ServiceErrorCode.RT_DELETE_USED_BY_NODE_DEFN_ERROR, msg);
        }
    }

    private void validateExport(ResourceType resourceType) {
        Set<Message> messages;
        if (resourceType.getAdaptorType() != AdaptorType.NONE && ((messages = resourceType.getMessages()) == null || messages.isEmpty())) {
            ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
            validationMessages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, ValidationMessageCode.RESOURCE_TYPE_CANNOT_EXPORT_NO_MESSAGES));
            String errMsg = "The resource type has adaptor defined, but does not have messages. Cannot export this resource type.";
            throw new ServiceValidationException(errMsg, validationMessages);
        }
    }

    private List<ValidationMessage> validateResourceType(ResourceType resourceType) {
        ValidationServiceFactory factory = ValidationServiceFactory.createFactory();
        IValidationService service = factory.createValidationService();
        return service.validateResourceType(resourceType);
    }

    private void validateUniqueResourceTypeName(ResourceType resourceType, IPersistenceContext context, List<ValidationMessage> messages) {
        String resourceTypeName = resourceType.getName();
        if (!this.isResourceTypeNameUnique(resourceTypeName, context)) {
            ValidationMessageCode code = ValidationMessageCode.RESOURCE_TYPE_NAME_NOT_UNIQUE;
            messages.add(new ValidationMessage(resourceType, ValidationMessageType.Error, code));
        }
    }

    private boolean isInvalid(List<ValidationMessage> messages) {
        boolean result = false;
        if (messages != null) {
            for (ValidationMessage message : messages) {
                if (message.getType() != ValidationMessageType.Error && message.getType() != ValidationMessageType.Warning) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void validateMessageCreation(Message message, IPersistenceContext context) {
        List<ValidationMessage> fvMessages;
        ValidationMessageCode code;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        long resourceTypeId = message.getResourceType().getId();
        AdaptorType adaptorType = message.getResourceType().getAdaptorType();
        String name = message.getName();
        if (adaptorType == null || adaptorType == AdaptorType.NONE) {
            code = ValidationMessageCode.RESOURCE_TYPE_ADAPTOR_TYPE_INVALID;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        }
        if (!this.isMessageNameUnique(resourceTypeId, name, context)) {
            code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_NAME_NOT_UNIQUE;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        }
        if (!this.isMessageUidUnique(message, context)) {
            code = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_UID_NOT_UNIQUE;
            messages.add(new ValidationMessage(message, ValidationMessageType.Error, code));
        }
        if ((fvMessages = this.validateMessage(message)) != null) {
            messages.addAll(fvMessages);
        }
        if (this.isInvalid(messages)) {
            String msg = "The Message failed validation during creation.";
            throw new ServiceValidationException(msg, messages);
        }
    }

    private void validateMessageDeletion(Message message, ResourceType resourceType, IPersistenceContext context) {
        if (resourceType.isOutOfTheBox()) {
            String errMsg = "Cannot delete a Message that belongs to an out-of-the-box Resource Type.";
            throw new ServiceException(ServiceErrorCode.RT_MESSAGE_DELETE_OOBRESTYPE_ERROR, errMsg);
        }
        NodeDefinitionDTODAI nodeDefinitionDAI = this.createNodeDefinitionDAO(context);
        int nodeDefinitionCount = nodeDefinitionDAI.getCountByMessage(message.getId());
        if (nodeDefinitionCount > 0) {
            String msg = "The message is being used by existing node definitions, cannot delete this message.";
            throw new ServiceException(ServiceErrorCode.RT_MESSAGE_DELETE_USED_BY_NODE_DEFN_ERROR, msg);
        }
    }

    private List<ValidationMessage> validateMessage(Message message) {
        ValidationServiceFactory factory = ValidationServiceFactory.createFactory();
        IValidationService service = factory.createValidationService();
        return service.validateMessage(message);
    }

    private boolean isMessageUidUnique(Message message, IPersistenceContext context) {
        MessageDAI messageDAO = this.createMessageDAO(context);
        return messageDAO.getCountByUID(message.getUid()) == 0;
    }

    private ResourceType lockResourceType(long resourceTypeId, ResourceTypeDAI resourceTypeDAO) {
        ResourceType resourceType = (ResourceType)resourceTypeDAO.lock(resourceTypeId);
        if (resourceType == null) {
            String msg = "The Resource Type has already been deleted, cannot perform operation on this Resource Type.";
            throw new ServiceException(ServiceErrorCode.WT_OPERATION_ON_DELETED_TEMPLATE, msg);
        }
        return resourceType;
    }

    private ResourceTypeDAI createResourceTypeDAO(IPersistenceContext context) {
        Class<ResourceType> entityClass = ResourceType.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (ResourceTypeDAI)dao;
    }

    private ResourceGroupDAI createResourceGroupDAO(IPersistenceContext context) {
        Class<ResourceGroup> entityClass = ResourceGroup.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (ResourceGroupDAI)dao;
    }

    private NodeDefinitionDTODAI createNodeDefinitionDAO(IPersistenceContext context) {
        Class<NodeDefinitionDTO> entityClass = NodeDefinitionDTO.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (NodeDefinitionDTODAI)dao;
    }

    private ConnectionTypeDAI createConnectionTypeDAO(IPersistenceContext context) {
        Class<ConnectionType> entityClass = ConnectionType.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (ConnectionTypeDAI)dao;
    }

    private MessageDAI createMessageDAO(IPersistenceContext context) {
        Class<Message> entityClass = Message.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (MessageDAI)dao;
    }

    private Set<Message> getMessagesForUpdate(ResourceType resourceType, ResourceType currentResourceType) {
        HashSet<Message> messagesForUpdate = new HashSet<Message>();
        Set<Message> messages = resourceType.getMessages();
        Set<Message> currentMessages = currentResourceType.getMessages();
        if (messages == null || currentMessages == null) {
            return messagesForUpdate;
        }
        for (Message message : messages) {
            if (!currentMessages.contains(message)) continue;
            messagesForUpdate.add(message);
        }
        return messagesForUpdate;
    }

    private void generateMessageUID(ResourceType resourceType, Message messageForGeneration) {
        HashSet<String> usedUIDs = new HashSet<String>();
        for (Message message : resourceType.getMessages()) {
            if (message.isUIDGenerationRequired()) continue;
            usedUIDs.add(message.getUid());
        }
        ServiceFactory factory = ServiceFactory.createFactory();
        IMessageUIDGenerator uidGenerator = factory.createMessageUIDGenerator();
        int sequenceNumber = resourceType.getMessageSequenceNumber();
        int attemptCount = 0;
        while (messageForGeneration.isUIDGenerationRequired() && attemptCount < 100) {
            String uid = uidGenerator.generateMessageUID(messageForGeneration, resourceType);
            resourceType.setMessageSequenceNumber(++sequenceNumber);
            ++attemptCount;
            if (usedUIDs.contains(uid)) continue;
            messageForGeneration.setUid(uid);
            messageForGeneration.setUIDGenerationRequired(false);
        }
        if (messageForGeneration.isUIDGenerationRequired()) {
            String msg = "Failed to generate a Message UID for the resource type.";
            throw new ServiceException(ServiceErrorCode.RT_UID_GENERATION_ERROR, msg);
        }
    }
}

