/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessFactory;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.PersistenceContextFactory;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import com.tandbergtv.watchpoint.studio.service.IService;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceImpl
implements IService {
    private static final Logger logger = Logger.getLogger(ServiceImpl.class);
    private static final String PERSISTENCE_OPERATION_NAME = "performOperation";
    protected PersistenceContextFactory pcFactory;
    protected DataAccessFactory daFactory = DataAccessFactory.createFactory();

    protected ServiceImpl() {
        this.pcFactory = PersistenceContextFactory.createFactory();
    }

    protected IPersistenceContext createPersistenceContext() {
        IPersistenceContext context = this.pcFactory.createPersistenceContext();
        context.initialize();
        return context;
    }

    protected DataAccessInterface<? extends IPersistable, ? extends Serializable> createDAO(IPersistable entity, IPersistenceContext context) {
        return this.daFactory.createDataAccessObject(entity, context);
    }

    protected void closePersistenceContext(IPersistenceContext context) {
        try {
            context.close();
        }
        catch (Exception ex) {
            String msg = "Failed to close the Persistence Context: " + ex.getLocalizedMessage();
            logger.error((Object)msg, (Throwable)ex);
        }
    }

    protected void beginTransaction(IPersistenceContext context) {
        context.beginTransaction();
    }

    protected void commitTransaction(IPersistenceContext context) {
        context.commitTransaction();
    }

    protected void rollbackTransaction(IPersistenceContext context) {
        try {
            context.rollbackTransaction();
        }
        catch (Exception ex) {
            String msg = "Failed when rolling back the current transaction: " + ex.getLocalizedMessage();
            logger.error((Object)msg, (Throwable)ex);
        }
    }

    protected Object performOperation(Class<?>[] parameterTypes, Object ... args) {
        Method method = this.findMethodToInvoke(parameterTypes, args);
        int argCount = args != null ? args.length : 0;
        Object[] newArgs = new Object[argCount + 1];
        int i = 0;
        while (i < argCount) {
            newArgs[i] = args[i];
            ++i;
        }
        IPersistenceContext context = this.createPersistenceContext();
        newArgs[argCount] = context;
        try {
            this.beginTransaction(context);
            Object result = method.invoke((Object)this, newArgs);
            this.commitTransaction(context);
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            String operationName = String.valueOf(this.getClass().getName()) + "." + method.getName() + "().";
            String msg = "Failed to perform operation: " + operationName;
            logger.error((Object)msg, (Throwable)ex);
            this.rollbackTransaction(context);
            throw this.generateException(method.getName(), ex);
        }
        finally {
            this.closePersistenceContext(context);
        }
    }

    private Method findMethodToInvoke(Class<?>[] parameterTypes, Object ... args) {
        String methodName = null;
        try {
            String className = ServiceImpl.class.getName();
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            int index = -1;
            int i = 0;
            while (i < stack.length) {
                String currClassName = stack[i].getClassName();
                String currMethodName = stack[i].getMethodName();
                if (className.equals(currClassName) && PERSISTENCE_OPERATION_NAME.equals(currMethodName)) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
            methodName = stack[index].getMethodName();
            ArrayList types = new ArrayList();
            int paramTypeCount = parameterTypes != null ? parameterTypes.length : 0;
            int i2 = 0;
            while (i2 < paramTypeCount) {
                types.add(parameterTypes[i2]);
                ++i2;
            }
            types.add(IPersistenceContext.class);
            return this.getClass().getDeclaredMethod(methodName, types.toArray(new Class[0]));
        }
        catch (Exception ex) {
            String msg = "Failed to find method: " + methodName + " in class: " + this.getClass().getName() + " to invoke.";
            logger.error((Object)msg, (Throwable)ex);
            throw new StudioRuntimeException(msg, ex);
        }
    }

    private RuntimeException generateException(String operationName, Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            cause = cause.getCause();
        }
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        String msg = "Failed to perform operation: " + this.getClass().getName() + "." + operationName + "().";
        return new ServiceException(ServiceErrorCode.GENERAL_ERROR, msg, cause);
    }
}

