/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ProtectionKeyDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.WatchPointDTOExporterFactory;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import com.tandbergtv.watchpoint.studio.lock.ILockOperationResult;
import com.tandbergtv.watchpoint.studio.lock.ILockStrategy;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.lock.LockAttributes;
import com.tandbergtv.watchpoint.studio.lock.LockFactory;
import com.tandbergtv.watchpoint.studio.service.IWorkflowTemplateService;
import com.tandbergtv.watchpoint.studio.service.LockFailureException;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowTemplateService
extends ServiceImpl
implements IWorkflowTemplateService {
    private static final Logger logger = Logger.getLogger(WorkflowTemplateService.class);
    private static final String PROCESS_DEFINITION_XPATH = "/process-definition";
    private static final String VERSION_ATTR_NAME = "version";
    private static final String NODE_DEFINITION_ID_XPATH = "//nodeDefinition/@id";
    private static final String RESOURCEGROUP_NAME_XPATH = "//resource-group/@name";
    private static final String PROTECTION_KEY_XPATH = "//protection-key/@name";

    @Override
    public List<WorkflowTemplateDTO> getTemplateList() {
        Class[] types = new Class[]{};
        return (List)super.performOperation(types, new Object[0]);
    }

    @Override
    public WorkflowTemplateDTO createTemplate(WorkflowTemplateDTO template, String ownerId, boolean lockTemplate) {
        Class[] types = new Class[]{WorkflowTemplateDTO.class, String.class, Boolean.TYPE};
        return (WorkflowTemplateDTO)super.performOperation(types, template, ownerId, lockTemplate);
    }

    @Override
    public WorkflowTemplateDTO getTemplateForView(String templateName) {
        Class[] types = new Class[]{String.class};
        return (WorkflowTemplateDTO)super.performOperation(types, templateName);
    }

    @Override
    public WorkflowTemplateDTO getTemplateForEdit(String name, String userId, boolean overrideLock) {
        Class[] types = new Class[]{String.class, String.class, Boolean.TYPE};
        return (WorkflowTemplateDTO)super.performOperation(types, name, userId, overrideLock);
    }

    @Override
    public WorkflowTemplateDTO saveTemplate(WorkflowTemplateDTO template, String userId) {
        Class[] types = new Class[]{WorkflowTemplateDTO.class, String.class};
        return (WorkflowTemplateDTO)super.performOperation(types, template, userId);
    }

    @Override
    public void closeTemplate(long templateKey, String ownerId) {
        Class[] types = new Class[]{Long.TYPE, String.class};
        super.performOperation(types, templateKey, ownerId);
    }

    @Override
    public void deleteTemplate(String templateName, String userId) {
        Class[] types = new Class[]{String.class, String.class};
        super.performOperation(types, templateName, userId);
    }

    @Override
    public WorkflowTemplateDTO exportTemplate(String templateName, Map<String, Object> parameters) throws ExportFailureException {
        WorkflowTemplateDTO template = null;
        Class[] types = new Class[]{String.class};
        template = (WorkflowTemplateDTO)super.performOperation(types, templateName);
        WatchPointDTOExporterFactory exporterFactory = WatchPointDTOExporterFactory.createFactory();
        IWatchPointDTOExporter<WorkflowTemplateDTO> exporter = exporterFactory.getExporter(WorkflowTemplateDTO.class);
        exporter.export(template, parameters);
        return template;
    }

    @Override
    public WorkflowTemplateDTO publishTemplate(String templateName, String userId) {
        Class[] types = new Class[]{String.class, String.class};
        return (WorkflowTemplateDTO)super.performOperation(types, templateName, userId);
    }

    @Override
    public WorkflowTemplateDTO unpublishTemplate(String templateName) {
        Class[] types = new Class[]{String.class};
        return (WorkflowTemplateDTO)super.performOperation(types, templateName);
    }

    @Override
    public List<ValidationMessage> validateTemplateForPublish(String templateName) {
        Class[] types = new Class[]{String.class};
        return (List)super.performOperation(types, templateName);
    }

    @Override
    public boolean nameExists(String name) {
        Class[] types = new Class[]{String.class};
        return (Boolean)super.performOperation(types, name);
    }

    protected List<WorkflowTemplateDTO> getTemplateList(IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        return templateDAO.findByCurrentVersion();
    }

    protected WorkflowTemplateDTO createTemplate(WorkflowTemplateDTO template, String ownerId, boolean lockTemplate, IPersistenceContext context) {
        template.setId(-1L);
        template.setDirty(true);
        template.setExportable(false);
        template.setActive(true);
        Document templateDocument = this.loadTemplateDocument(template);
        this.setTemplateVersion(template, templateDocument, 1);
        String templateName = template.getName();
        if (templateName != null) {
            template.setName(templateName.trim());
        }
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        this.updateNodeDefinitionsUsed(template, templateDocument, nodeDefinitionDAO);
        this.updateProtectionKeysUsed(template, templateDocument, context);
        ResourceGroupDAI resourceGroupDAO = this.createResourceGroupDAO(context);
        this.updateResourceGroupsUsed(template, templateDocument, resourceGroupDAO);
        ILock lockObject = lockTemplate ? LockFactory.createFactory().createLock(ownerId) : null;
        template.setLock(lockObject);
        this.validateNewTemplate(template, context);
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        return templateDAO.create(template);
    }

    protected WorkflowTemplateDTO getTemplateForView(String templateName, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        return this.lockTemplate(templateName, templateDAO);
    }

    protected WorkflowTemplateDTO getTemplateForEdit(String templateName, String userId, boolean overrideLock, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        WorkflowTemplateDTO template = this.lockTemplate(templateName, templateDAO);
        if (template.isExportable()) {
            String msg = "The template is currently published, cannot edit this template.";
            throw new ServiceException(ServiceErrorCode.WT_EDIT_PUBLISHED_ERROR, msg);
        }
        ILockStrategy lockStrategy = LockFactory.createFactory().createLockStrategy();
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put(LockAttributes.OVERRIDE_LOCK.toString(), Boolean.valueOf(overrideLock));
        ILockOperationResult result = lockStrategy.tryLock(userId, template, attributes, context);
        if (!result.getOperationResult()) {
            String msg = "Failed to acquire a lock for the template, cannot edit this template.";
            ILockable entity = result.getLockableEntity();
            throw new LockFailureException(ServiceErrorCode.WT_EDIT_LOCK_ERROR, entity, msg);
        }
        return (WorkflowTemplateDTO)result.getLockableEntity();
    }

    protected WorkflowTemplateDTO saveTemplate(WorkflowTemplateDTO template, String userId, IPersistenceContext context) {
        boolean requiresNewVersion;
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        WorkflowTemplateDTO persistedTemplate = (WorkflowTemplateDTO)templateDAO.lock(template.getId());
        if (!persistedTemplate.isActive()) {
            String msg = "The Template has already been deleted, cannot save this template.";
            throw new ServiceException(ServiceErrorCode.WT_OPERATION_ON_DELETED_TEMPLATE, msg);
        }
        ILock templateLock = persistedTemplate.getLock();
        if (templateLock == null || !templateLock.getOwnerId().equals(userId)) {
            String msg = "The template is not currently locked for the user, cannot save this template.";
            throw new ServiceException(ServiceErrorCode.WT_SAVE_UNLOCKED_ERROR, msg);
        }
        template.setDirty(true);
        template.setActive(persistedTemplate.isActive());
        template.setExportable(persistedTemplate.isExportable());
        template.setLock(persistedTemplate.getLock());
        Document templateDocument = this.loadTemplateDocument(template);
        NodeDefinitionDTODAI nodeDefinitionDAO = this.createNodeDefinitionDAO(context);
        this.updateNodeDefinitionsUsed(template, templateDocument, nodeDefinitionDAO);
        this.updateProtectionKeysUsed(template, templateDocument, context);
        ResourceGroupDAI resourceGroupDAO = this.createResourceGroupDAO(context);
        this.updateResourceGroupsUsed(template, templateDocument, resourceGroupDAO);
        this.validateExistingTemplate(template, persistedTemplate, context);
        boolean bl = requiresNewVersion = !persistedTemplate.isDirty();
        if (requiresNewVersion) {
            String templateName = persistedTemplate.getName();
            int newVersion = this.generateNewVersionNumber(templateName, templateDAO);
            this.setTemplateVersion(template, templateDocument, newVersion);
            template.setId(-1L);
            persistedTemplate.setLock(null);
            templateDAO.update(persistedTemplate);
            template.setLock(LockFactory.createFactory().createLock(userId));
            template = templateDAO.create(template);
        } else {
            this.setTemplateVersion(template, templateDocument, persistedTemplate.getVersion());
            template = templateDAO.update(template);
        }
        return template;
    }

    protected void closeTemplate(long templateKey, String ownerId, IPersistenceContext context) {
        WorkflowTemplateDTO template = new WorkflowTemplateDTO();
        template.setId(templateKey);
        ILockStrategy lockStrategy = LockFactory.createFactory().createLockStrategy();
        lockStrategy.releaseLock(ownerId, template, context);
    }

    protected void deleteTemplate(String templateName, String userId, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        DataAccessInterface lockDAO = null;
        WorkflowTemplateDTO template = this.lockTemplate(templateName, templateDAO);
        if (template.isExportable()) {
            String msg = "The template is currently published, cannot delete this template.";
            throw new ServiceException(ServiceErrorCode.WT_DELETE_PUBLISHED_ERROR, msg);
        }
        ILock templateLock = template.getLock();
        if (templateLock != null && !templateLock.getOwnerId().equals(userId)) {
            String msg = "The template is locked by another user, cannot delete this template.";
            throw new ServiceException(ServiceErrorCode.WT_DELETE_LOCKED_ERROR, msg);
        }
        if (templateLock != null) {
            template.setLock(null);
            templateDAO.update(template);
            lockDAO = this.daFactory.createDataAccessObject(templateLock, context);
            lockDAO.delete(templateLock.getKey());
        }
        int deletedTemplateCount = templateDAO.setInactiveByName(templateName);
        logger.debug((Object)("The number of deleted templates: " + deletedTemplateCount));
        templateDAO.deleteResourceGroupMap(templateName);
    }

    protected WorkflowTemplateDTO exportTemplate(String templateName, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        WorkflowTemplateDTO template = this.lockTemplate(templateName, templateDAO);
        if (!template.isExportable()) {
            String msg = "The template has not been published, cannot export this template.";
            throw new ServiceException(ServiceErrorCode.WT_EXPORT_UNPUBLISHED_ERROR, msg);
        }
        template.setDirty(false);
        templateDAO.update(template);
        return template;
    }

    protected WorkflowTemplateDTO publishTemplate(String templateName, String userId, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        WorkflowTemplateDTO template = this.lockTemplate(templateName, templateDAO);
        if (template.getLock() != null && !template.getLock().getOwnerId().equals(userId)) {
            String msg = "The template is currently locked by a different user, cannot publish the template.";
            throw new ServiceException(ServiceErrorCode.WT_PUBLISHED_LOCKED_ERROR, msg);
        }
        if (!template.isExportable()) {
            this.validateExportableTemplate(template);
            template.setExportable(true);
            template.setLock(null);
            templateDAO.update(template);
        }
        return template;
    }

    protected WorkflowTemplateDTO unpublishTemplate(String templateName, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        WorkflowTemplateDTO template = this.lockTemplate(templateName, templateDAO);
        if (template.isExportable()) {
            template.setExportable(false);
            templateDAO.update(template);
        }
        return template;
    }

    protected List<ValidationMessage> validateTemplateForPublish(String templateName, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        WorkflowTemplateDTO template = this.lockTemplate(templateName, templateDAO);
        return this.validateTemplate(template);
    }

    protected boolean nameExists(String name, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAO = this.createTemplateDAO(context);
        return templateDAO.getCountByName(name) > 0;
    }

    private WorkflowTemplateDTODAI createTemplateDAO(IPersistenceContext context) {
        Class<WorkflowTemplateDTO> entityClass = WorkflowTemplateDTO.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (WorkflowTemplateDTODAI)dao;
    }

    private NodeDefinitionDTODAI createNodeDefinitionDAO(IPersistenceContext context) {
        Class<NodeDefinitionDTO> entityClass = NodeDefinitionDTO.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (NodeDefinitionDTODAI)dao;
    }

    private ResourceGroupDAI createResourceGroupDAO(IPersistenceContext context) {
        Class<ResourceGroup> entityClass = ResourceGroup.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (ResourceGroupDAI)dao;
    }

    private ProtectionKeyDAI createProtectionKeyDAO(IPersistenceContext context) {
        Class<ProtectionKey> entityClass = ProtectionKey.class;
        DataAccessInterface dao = this.daFactory.createDataAccessObject(entityClass, context);
        return (ProtectionKeyDAI)dao;
    }

    private int generateNewVersionNumber(String templateName, WorkflowTemplateDTODAI templateDAO) {
        Long templateId = templateDAO.getTemplateIdByNameForOldestVersion(templateName);
        templateDAO.lock(templateId);
        int versionNumber = templateDAO.getCurrentVersionNumberByName(templateName) + 1;
        return versionNumber;
    }

    private void updateNodeDefinitionsUsed(WorkflowTemplateDTO template, Document templateDocument, NodeDefinitionDTODAI nodeDefinitionDAO) {
        HashSet<NodeDefinitionDTO> nodeDefinitions = new HashSet<NodeDefinitionDTO>();
        template.setNodeDefinitions(nodeDefinitions);
        HashSet<Long> nodeDefinitionKeys = new HashSet<Long>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(NODE_DEFINITION_ID_XPATH, templateDocument, XPathConstants.NODESET);
            int nodeCount = nodes != null ? nodes.getLength() : 0;
            int i = 0;
            while (i < nodeCount) {
                Node node = nodes.item(i);
                String nodeDefinitionIdValue = node.getNodeValue();
                if (nodeDefinitionIdValue != null && nodeDefinitionIdValue.trim().length() > 0) {
                    nodeDefinitionKeys.add(Long.parseLong(nodeDefinitionIdValue));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String msg = "Failed to get the list of Node Definition Ids specified in the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_NODE_DEFN_UPDATE_ERROR, msg, ex);
        }
        List<NodeDefinitionDTO> usedDefns = nodeDefinitionDAO.findByKeys(nodeDefinitionKeys);
        if (usedDefns != null) {
            nodeDefinitions.addAll(usedDefns);
        }
    }

    private void updateResourceGroupsUsed(WorkflowTemplateDTO template, Document templateDocument, ResourceGroupDAI resourceGroupDAO) {
        HashSet<String> resourceGroupNames = new HashSet<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = null;
        try {
            nodes = (NodeList)xpath.evaluate(RESOURCEGROUP_NAME_XPATH, templateDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            String msg = "Failed to get the list of Resource Group Names specified in the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_RESGRP_UPDATE_ERROR, msg, e);
        }
        int nodeCount = nodes != null ? nodes.getLength() : 0;
        int i = 0;
        while (i < nodeCount) {
            Node node = nodes.item(i);
            String resourceGroupName = node.getNodeValue();
            if (resourceGroupName != null && resourceGroupName.trim().length() > 0) {
                resourceGroupNames.add(resourceGroupName);
            }
            ++i;
        }
        HashSet<ResourceGroup> resourceGroups = new HashSet<ResourceGroup>();
        resourceGroups.addAll(resourceGroupDAO.findByNames(resourceGroupNames));
        template.setResourceGroups(resourceGroups);
    }

    private void updateProtectionKeysUsed(WorkflowTemplateDTO template, Document templateDocument, IPersistenceContext context) {
        HashSet<ProtectionKey> protectionKeys = new HashSet<ProtectionKey>();
        template.setProtectionKeys(protectionKeys);
        HashSet<String> protectionKeyNames = new HashSet<String>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(PROTECTION_KEY_XPATH, templateDocument, XPathConstants.NODESET);
            int nodeCount = nodes != null ? nodes.getLength() : 0;
            int i = 0;
            while (i < nodeCount) {
                Node node = nodes.item(i);
                String protectionKeyName = node.getNodeValue();
                if (protectionKeyName != null && protectionKeyName.trim().length() > 0) {
                    protectionKeyNames.add(protectionKeyName.trim());
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String msg = "Failed to get the set of Protection Keys specified in the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_PROTECTION_KEY_UPDATE_ERROR, msg, ex);
        }
        ProtectionKeyDAI pkDAO = this.createProtectionKeyDAO(context);
        List<ProtectionKey> existingProtectionKeys = pkDAO.findByNames(protectionKeyNames);
        if (existingProtectionKeys == null) {
            existingProtectionKeys = new ArrayList<ProtectionKey>();
        }
        HashSet<String> missingKeyNames = new HashSet<String>(protectionKeyNames);
        for (ProtectionKey protectionKey : existingProtectionKeys) {
            missingKeyNames.remove(protectionKey.getName());
        }
        protectionKeys.addAll(existingProtectionKeys);
        for (String keyName : missingKeyNames) {
            ProtectionKey protectionKey = new ProtectionKey();
            protectionKey.setName(keyName);
            protectionKeys.add(pkDAO.create(protectionKey));
        }
    }

    private void setTemplateVersion(WorkflowTemplateDTO template, Document document, int version) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element processDefinitionElement = (Element)xpath.evaluate(PROCESS_DEFINITION_XPATH, document, XPathConstants.NODE);
            processDefinitionElement.setAttribute(VERSION_ATTR_NAME, Integer.toString(version));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            template.setXml(writer.toString());
            template.setVersion(version);
        }
        catch (Exception ex) {
            String msg = "Failed to update the version attribute in the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_VERSION_UPDATE_ERROR, msg, ex);
        }
    }

    private WorkflowTemplateDTO lockTemplate(String name, WorkflowTemplateDTODAI templateDAO) {
        Long templateId = templateDAO.getTemplateIdByName(name);
        WorkflowTemplateDTO template = (WorkflowTemplateDTO)templateDAO.lock(templateId);
        if (!template.isActive()) {
            String msg = "The Template has already been deleted, cannot perform operation on this template.";
            throw new ServiceException(ServiceErrorCode.WT_OPERATION_ON_DELETED_TEMPLATE, msg);
        }
        return template;
    }

    private Document loadTemplateDocument(WorkflowTemplateDTO template) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            StringReader reader = new StringReader(template.getXml());
            return factory.newDocumentBuilder().parse(new InputSource(reader));
        }
        catch (Exception ex) {
            String msg = "Failed to load the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_INVALID_XML, msg, ex);
        }
    }

    private void validateNewTemplate(WorkflowTemplateDTO template, IPersistenceContext context) {
        WorkflowTemplateDTODAI templateDAI = this.createTemplateDAO(context);
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String templateName = template.getName();
        if (templateName == null || templateName.length() == 0) {
            ValidationMessageCode code = ValidationMessageCode.TEMPLATE_NAME_BLANK;
            messages.add(new ValidationMessage(template, ValidationMessageType.Error, code));
        } else {
            int templateCount = templateDAI.getCountByName(template.getName());
            if (templateCount > 0) {
                ValidationMessageCode code = ValidationMessageCode.TEMPLATE_NAME_NOT_UNIQUE;
                messages.add(new ValidationMessage(template, ValidationMessageType.Error, code));
            }
        }
        if (messages.size() > 0) {
            String msg = "The Template failed validation during creation.";
            throw new ServiceValidationException(msg, messages);
        }
    }

    private void validateExistingTemplate(WorkflowTemplateDTO template, WorkflowTemplateDTO existingTemplate, IPersistenceContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String templateName = existingTemplate.getName();
        if (!templateName.equals(template.getName())) {
            ValidationMessageCode code = ValidationMessageCode.TEMPLATE_NAME_CHANGED;
            messages.add(new ValidationMessage(template, ValidationMessageType.Error, code));
        }
        if (messages.size() > 0) {
            String msg = "The Template failed validation when updating.";
            throw new ServiceValidationException(msg, messages);
        }
    }

    private void validateExportableTemplate(WorkflowTemplateDTO template) {
        List<ValidationMessage> messages = this.validateTemplate(template);
        if (messages != null) {
            boolean validationFailed = false;
            for (ValidationMessage message : messages) {
                if (message.getType() != ValidationMessageType.Error && message.getType() != ValidationMessageType.Warning) continue;
                validationFailed = true;
                break;
            }
            if (validationFailed) {
                String msg = "The Template failed validation when attempting to publish the template.";
                throw new ServiceValidationException(msg, messages);
            }
        }
    }

    private List<ValidationMessage> validateTemplate(WorkflowTemplateDTO template) {
        ValidationServiceFactory factory = ValidationServiceFactory.createFactory();
        IValidationService validationService = factory.createValidationService();
        return validationService.validateTemplate(template);
    }
}

