/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.util.CoreUtility;

public class TemplateResourcesUtility {
    private static final String WATCH_POINT_TEMP_PROJECT = "WatchPointTempProject";
    private static final String TEMP_GPD_FILE = "gpd.xml";
    private static final String TEMPLATE_FOLDER = "TempTemplates";
    private static final String NODE_DEFINITION_FOLDER = "TempNodeDefinitions";
    private static final String TEMP_TEMPLATE_FILE = "processdefinition.xml";
    private static final String TEMP_NODE_DEFINITION_FILE = "nodedefinition.xml";
    private static IJavaProject PROJECT = null;

    public static IFile createTemplateFile(String templateXML, String gpdXML) {
        return TemplateResourcesUtility.createTempFiles(TEMPLATE_FOLDER, TEMP_TEMPLATE_FILE, templateXML, TEMP_GPD_FILE, gpdXML);
    }

    public static IFile createNodeDefinitionFile(String nodeDefinitionXML, String gpdXML) {
        return TemplateResourcesUtility.createTempFiles(NODE_DEFINITION_FOLDER, TEMP_NODE_DEFINITION_FILE, nodeDefinitionXML, TEMP_GPD_FILE, gpdXML);
    }

    public static String getTemplateGpdXml() {
        if (PROJECT == null) {
            return null;
        }
        return TemplateResourcesUtility.getGpdXml(TEMPLATE_FOLDER);
    }

    public static String getNodeDefinitionGpdXml() {
        if (PROJECT == null) {
            return null;
        }
        return TemplateResourcesUtility.getGpdXml(NODE_DEFINITION_FOLDER);
    }

    private static String getGpdXml(String folderName) {
        IFile gpdFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(PROJECT.getPath() + "//" + folderName + "//" + TEMP_GPD_FILE));
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(gpdFile.getContents()));
            StringBuffer buffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buffer.append(line);
                buffer.append(System.getProperty("line.separator"));
            }
            return buffer.toString();
        }
        catch (IOException e) {
            throw new UIException("Could not read from gpd file.", e);
        }
        catch (CoreException e) {
            throw new UIException("Could not open gpd file.", e);
        }
    }

    private static IFile createTempFiles(String folderName, String templateFileName, String templateXML, String gpdFileName, String gpdXML) {
        IFile processDefinitionFile = null;
        try {
            PROJECT = TemplateResourcesUtility.createJavaProject(WATCH_POINT_TEMP_PROJECT);
            processDefinitionFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(PROJECT.getPath() + "//" + folderName + "//" + templateFileName));
            if (processDefinitionFile.exists()) {
                processDefinitionFile.setContents((InputStream)new ByteArrayInputStream(templateXML.getBytes()), true, false, null);
            } else {
                processDefinitionFile.create((InputStream)new ByteArrayInputStream(templateXML.getBytes()), true, null);
            }
            IFile gpdFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(PROJECT.getPath() + "//" + folderName + "//" + gpdFileName));
            if (gpdFile.exists()) {
                gpdFile.setContents((InputStream)new ByteArrayInputStream(gpdXML.getBytes()), true, false, null);
            } else {
                gpdFile.create((InputStream)new ByteArrayInputStream(gpdXML.getBytes()), true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return processDefinitionFile;
    }

    private static IJavaProject createJavaProject(String projectName) throws CoreException {
        String nodeDefFolderName;
        IFolder nodeDefFolder;
        String templateFolderName;
        IFolder templateFolder;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!(templateFolder = project.getFolder(templateFolderName = TEMPLATE_FOLDER)).exists()) {
            CoreUtility.createFolder((IFolder)templateFolder, (boolean)false, (boolean)true, null);
        }
        if (!(nodeDefFolder = project.getFolder(nodeDefFolderName = NODE_DEFINITION_FOLDER)).exists()) {
            CoreUtility.createFolder((IFolder)nodeDefFolder, (boolean)false, (boolean)true, null);
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            TemplateResourcesUtility.addNatureToProject(project, "org.eclipse.jdt.core.javanature", null);
        }
        try {
            IJavaProject jproject = JavaCore.create((IProject)project);
            jproject.open(null);
            return jproject;
        }
        catch (Exception e) {
            throw new IllegalStateException("error de project java : " + e);
        }
    }

    private static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }
}

