/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.actionconfig;

import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionClassConfiguration;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationException;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionConfigurationManager {
    private static final Logger logger = Logger.getLogger(ActionConfigurationManager.class);
    private static ActionConfigurationManager instance = new ActionConfigurationManager();
    private Map<String, ActionClassConfiguration> actionClasses;

    public static ActionConfigurationManager getInstance() {
        return instance;
    }

    private ActionConfigurationManager() {
        this.initialize();
    }

    public synchronized ActionClassConfiguration getActionClass(String className) {
        if (this.actionClasses != null && className != null) {
            return this.actionClasses.get(className);
        }
        return null;
    }

    public synchronized List<ActionClassConfiguration> getAllActionClasses() {
        ArrayList<ActionClassConfiguration> classes = new ArrayList<ActionClassConfiguration>();
        if (this.actionClasses != null) {
            classes.addAll(this.actionClasses.values());
            Collections.sort(classes, new ActionClassComparator());
        }
        return classes;
    }

    private void initialize() {
        this.actionClasses = null;
        try {
            ActionConfigurationReader reader = new ActionConfigurationReader();
            this.actionClasses = reader.read();
        }
        catch (ActionConfigurationException ace) {
            String msg = "Failed to read the Action Class Configuration, no pre-configured Action Classes available.";
            logger.error((Object)msg, (Throwable)ace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionClassComparator
    implements Comparator<ActionClassConfiguration> {
        private ActionClassComparator() {
        }

        @Override
        public int compare(ActionClassConfiguration o1, ActionClassConfiguration o2) {
            return o1.getClassName().compareTo(o2.getClassName());
        }
    }
}

