/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.actionconfig;

import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionClassConfiguration;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationException;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionVariableConfiguration;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.gd.common.model.GenericElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionConfigurationReader {
    private static final Logger logger = Logger.getLogger(ActionConfigurationReader.class);
    private static final String RESOURCE_NAME = "/ActionClasses.xml";
    private static final String ACTION_CLASSES_XPATH = "//class/@name";
    private IValidationService validationService = ValidationServiceFactory.createFactory().createValidationService();

    public Map<String, ActionClassConfiguration> read() throws ActionConfigurationException {
        HashMap<String, ActionClassConfiguration> actionClasses = new HashMap<String, ActionClassConfiguration>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(this.getClass().getResourceAsStream(RESOURCE_NAME));
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(ACTION_CLASSES_XPATH, document, XPathConstants.NODESET);
            int nodeCount = nodes != null ? nodes.getLength() : 0;
            int i = 0;
            while (i < nodeCount) {
                Node node = nodes.item(i);
                String className = node.getNodeValue();
                if (className != null && className.trim().length() != 0) {
                    String expression = "//class[@name='" + className + "']/variable";
                    NodeList variableNodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
                    ArrayList<ActionVariableConfiguration> variables = new ArrayList<ActionVariableConfiguration>();
                    ArrayList variableNames = new ArrayList();
                    int variableNodeCount = variableNodes != null ? variableNodes.getLength() : 0;
                    int j = 0;
                    while (j < variableNodeCount) {
                        Node variableNode = variableNodes.item(j);
                        if (variableNode instanceof Element) {
                            Element element = (Element)variableNode;
                            String name = element.getAttribute("name");
                            if (this.isInvalidVariableName(name)) {
                                String msg = "The Action Class with name: " + className + " contains a variable with an invalid name: " + name + ", skipping variable.";
                                logger.warn((Object)msg);
                            } else if (variableNames.contains(name)) {
                                String msg = "The Action Class with name: " + className + " contains a more than one variable with name: " + name + ", skipping duplicate variables.";
                                logger.warn((Object)msg);
                            } else {
                                boolean required = Boolean.parseBoolean(element.getAttribute("required"));
                                String validator = element.getAttribute("validationRule");
                                variables.add(new ActionVariableConfiguration(name, required, validator));
                            }
                        }
                        ++j;
                    }
                    actionClasses.put(className, new ActionClassConfiguration(className, variables));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String msg = "Failed to load Action Class configuration from file: /ActionClasses.xml";
            throw new ActionConfigurationException(msg, ex);
        }
        return actionClasses;
    }

    private boolean isInvalidVariableName(String name) {
        GenericElement element = new GenericElement();
        element.setName(name);
        List<ValidationMessage> messages = this.validationService.validateActionVariableName(element);
        return messages != null && messages.size() > 0;
    }
}

