/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.jbpm.gd.common.editor.AbstractContentProvider;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class NodeDefinitionContentProvider
extends AbstractContentProvider {
    protected String getRootSemanticInfoElement() {
        return "<nodeDefinition>";
    }

    protected String getNotationInfoFileName(String semanticInfoFileName) {
        if ("nodedefinition.xml".equals(semanticInfoFileName)) {
            return "gpd.xml";
        }
        return super.getNotationInfoFileName(semanticInfoFileName);
    }

    protected String getSemanticInfoFileName(String notationInfoFileName) {
        if ("gpd.xml".equals(notationInfoFileName)) {
            return "nodedefinition.xml";
        }
        return super.getSemanticInfoFileName(notationInfoFileName);
    }

    protected SemanticElement getEdgeSemanticElement(Node node, Element notationInfo, int index) {
        Transition[] transitions = ((NodeElement)node.getSemanticElement()).getTransitions();
        return index < transitions.length ? transitions[index] : null;
    }

    protected SemanticElement getNodeSemanticElement(NodeContainer nodeContainer, Element notationInfo, int index) {
        NodeElementContainer nodeElementContainer = (NodeElementContainer)nodeContainer.getSemanticElement();
        return nodeElementContainer.getNodeElementByName(notationInfo.attributeValue("name"));
    }

    protected void addEdges(Node node, Element nodeInfo) {
        List edges = nodeInfo.elements("edge");
        int i = 0;
        while (i < edges.size()) {
            SemanticElement edgeSemanticElement = this.getEdgeSemanticElement(node, (Element)edges.get(i), i);
            super.addEdge(node, edgeSemanticElement, (Element)edges.get(i));
            ++i;
        }
    }

    protected void addNodes(NodeContainer nodeContainer, Element notationInfo) {
        List nodes = notationInfo.elements("node");
        int i = 0;
        while (i < nodes.size()) {
            SemanticElement nodeSemanticElement = this.getNodeSemanticElement(nodeContainer, (Element)nodes.get(i), i);
            this.addNode(nodeContainer, nodeSemanticElement, (Element)nodes.get(i));
            ++i;
        }
    }

    protected SemanticElement findDestination(Edge edge, Node source) {
        NodeContainer notationElement = source.getContainer();
        String pathCopy = ((Transition)edge.getSemanticElement()).getTo();
        while (pathCopy.length() > 3 && "../".equals(pathCopy.substring(0, 3)) && notationElement != null) {
            notationElement = ((Node)notationElement).getContainer();
            pathCopy = pathCopy.substring(3);
        }
        if (notationElement == null) {
            return null;
        }
        SemanticElement parent = notationElement.getSemanticElement();
        StringTokenizer tokenizer = new StringTokenizer(pathCopy, "/");
        while (parent != null && tokenizer.hasMoreTokens()) {
            if (!(parent instanceof NodeElementContainer)) {
                return null;
            }
            parent = ((NodeElementContainer)parent).getNodeElementByName(tokenizer.nextToken());
        }
        return parent;
    }
}

