/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.service.INodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.GraphicalEditPartFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionActionRegistry;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionContentProvider;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionCreationFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionGraphPage;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionGraphicalViewer;
import com.tandbergtv.watchpoint.studio.ui.editor.WPFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.nodedefinition.NodeDefinitionExplorer;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.jbpm.gd.common.editor.ContentProvider;
import org.jbpm.gd.common.editor.OutlineViewer;
import org.jbpm.gd.common.editor.SelectionSynchronizer;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.notation.NotationElementFactory;
import org.jbpm.gd.common.notation.RootContainer;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapterFactory;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeDefinitionEditor
extends XMLMultiPageEditorPart
implements ITabbedPropertySheetPageContributor,
IPartListener2 {
    private static final String NODEDEFINITIONIMAGE = "nodedefinitionimage.jpg";
    private NodeDefinitionActionRegistry actionRegistry;
    private EditDomain editDomain;
    private CommandStackListener commandStackListener;
    private boolean isDirty = false;
    private ISelectionListener selectionListener;
    private SelectionSynchronizer selectionSynchronizer;
    private SemanticElementFactory semanticElementFactory;
    private NotationElementFactory notationElementFactory;
    private RootContainer rootContainer;
    private NodeDefinitionGraphPage graphPage;
    private StructuredTextEditor sourcePage;
    private MenuManager sourceContextMenuManager;
    private ContentProvider contentProvider;
    private NodeDefinitionDTO nodeDefinitionDTO;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        NodeDefinitionDTO tempDTO;
        FileEditorInput fileInput = (FileEditorInput)input;
        this.nodeDefinitionDTO = tempDTO = (NodeDefinitionDTO)((WPFileEditorInput)fileInput).getWatchPointDTO();
        super.init(site, (IEditorInput)fileInput);
        this.initEditDomain();
        this.initCommandStackListener();
        this.initSelectionListener();
        this.initSelectionSynchronizer();
        this.getEditorSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
        Utility.setWindow(site.getWorkbenchWindow());
    }

    protected void createPages() {
        super.createPages();
        this.initSourcePage();
        this.initActionRegistry();
        this.initGraphPage();
        this.setActivePage(0);
    }

    private void addPage(int index, IEditorPart part, String label) {
        try {
            this.addPage(index, part, this.getEditorInput());
            this.setPageText(index, label);
        }
        catch (PartInitException e) {
            Logger.logError((String)"Could not create editor page", (Throwable)e);
        }
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public String getNodeDefinitionDTOName() {
        return this.nodeDefinitionDTO != null ? this.nodeDefinitionDTO.getName() : null;
    }

    public long getNodeDefinitionDTOId() {
        return this.nodeDefinitionDTO != null ? this.nodeDefinitionDTO.getId() : 0L;
    }

    private void initActionRegistry() {
        this.actionRegistry = new NodeDefinitionActionRegistry(this);
    }

    private void initEditDomain() {
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
    }

    private void initSelectionSynchronizer() {
        this.selectionSynchronizer = this.createSelectionSynchronizer();
    }

    private void initCommandStackListener() {
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                NodeDefinitionEditor.this.handleCommandStackChanged();
            }
        };
        this.getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    private void initSelectionListener() {
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                NodeDefinitionEditor.this.getActionRegistry().updateEditPartActions();
            }
        };
        ISelectionService selectionService = this.getEditorSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener(this.selectionListener);
    }

    protected void initGraphPage() {
        this.graphPage = new NodeDefinitionGraphPage(this);
        this.addPage(0, (IEditorPart)this.graphPage, "Diagram");
        this.getContentProvider().addNotationInfo(this.getRootContainer(), this.getEditorInput());
    }

    protected void initSourcePage() {
        int pageCount = this.getPageCount();
        int i = 0;
        while (i < pageCount) {
            if (this.getEditor(i) instanceof StructuredTextEditor) {
                this.sourcePage = (StructuredTextEditor)this.getEditor(i);
                NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement(this.sourcePage);
                nodeDefinition.setNodeType(this.nodeDefinitionDTO.getType());
                NodeDefinitionCreationFactory factory = new NodeDefinitionCreationFactory(nodeDefinition.getElementId(), this.getSemanticElementFactory(), this.getNotationElementFactory());
                this.setRootContainer((RootContainer)factory.getNewObject());
                this.getRootContainer().setSemanticElement((SemanticElement)nodeDefinition);
                nodeDefinition.addPropertyChangeListener((PropertyChangeListener)this.getRootContainer());
                this.setTransitionSources(nodeDefinition);
            }
            ++i;
        }
        if (this.sourcePage != null) {
            this.initSourcePageContextMenu((Control)this.sourcePage.getTextViewer().getTextWidget());
        }
    }

    private void setTransitionSources(NodeDefinition nodeDefinition) {
        NodeElement[] nodeElementArray = nodeDefinition.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            Transition[] transitionArray = node.getTransitions();
            int n3 = transitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Transition transition = transitionArray[n4];
                transition.setSource(node);
                ++n4;
            }
            ++n2;
        }
    }

    private SemanticElement getSemanticElement(StructuredTextEditor sourcePage) {
        Node node = this.getDocumentElement(sourcePage);
        XmlAdapterFactory factory = new XmlAdapterFactory(node.getOwnerDocument(), this.getSemanticElementFactory());
        XmlAdapter xmlAdapter = factory.adapt(node);
        SemanticElement semanticElement = this.createMainElement();
        xmlAdapter.initialize(semanticElement);
        return semanticElement;
    }

    private Node getDocumentElement(StructuredTextEditor sourcePage) {
        Element result = null;
        Document document = (Document)sourcePage.getAdapter(Document.class);
        if (document != null) {
            result = document.getDocumentElement();
        }
        return result;
    }

    private void initSourcePageContextMenu(Control control) {
        this.sourceContextMenuManager = new MenuManager("#PopupMenu");
        this.sourceContextMenuManager.setRemoveAllWhenShown(true);
        this.sourceContextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                NodeDefinitionEditor.this.fillContextMenu(m);
            }
        });
        Menu menu = this.sourceContextMenuManager.createContextMenu(control);
        this.getSite().registerContextMenu("org.jbpm.ui.editor.DesignerEditor.SourcePopupMenu", this.sourceContextMenuManager, this.getSite().getSelectionProvider());
        control.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private void handleCommandStackChanged() {
        this.getActionRegistry().updateStackActions();
        if (!this.isDirty() && this.getCommandStack().isDirty()) {
            this.isDirty = true;
            this.firePropertyChange(257);
        }
        this.handleNodeDefinitionChanged();
    }

    private void handleNodeDefinitionChanged() {
        if (this.nodeDefinitionDTO.getLock() == null || !this.nodeDefinitionDTO.getLock().getOwnerId().equals(Utility.getUserName())) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Node Definition locked", (String)"This node definition is open in view mode, any changes you make will be lost.");
        }
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean isDirty() {
        return this.isLockedByCurrentUser() && (this.isDirty || super.isDirty());
    }

    public NodeDefinitionActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public NodeDefinitionGraphPage getGraphPage() {
        return this.graphPage;
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public CommandStack getCommandStack() {
        return this.editDomain.getCommandStack();
    }

    public void setSelectionSynchronizer(SelectionSynchronizer selectionSynchronizer) {
        this.selectionSynchronizer = selectionSynchronizer;
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return this.selectionSynchronizer;
    }

    public SemanticElementFactory getSemanticElementFactory() {
        if (this.semanticElementFactory == null) {
            this.semanticElementFactory = new SemanticElementFactory(this.getContributorId());
        }
        return this.semanticElementFactory;
    }

    public NotationElementFactory getNotationElementFactory() {
        if (this.notationElementFactory == null) {
            this.notationElementFactory = new NotationElementFactory();
        }
        return this.notationElementFactory;
    }

    public RootContainer getRootContainer() {
        return this.rootContainer;
    }

    public NodeDefinition getNodeDefinition() {
        if (this.rootContainer == null) {
            return null;
        }
        return (NodeDefinition)this.rootContainer.getSemanticElement();
    }

    public void setRootContainer(RootContainer rootContainer) {
        this.rootContainer = rootContainer;
    }

    public ContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = this.createContentProvider();
        }
        return this.contentProvider;
    }

    public NodeDefinitionGraphicalViewer getGraphicalViewer() {
        return this.getGraphPage().getDesignerModelViewer();
    }

    public OutlineViewer getOutlineViewer() {
        return this.getGraphPage().getOutlineViewer();
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        if (adapter == CommandStack.class) {
            result = this.getCommandStack();
        } else {
            if (adapter == IContentOutlinePage.class) {
                return this.getOutlineViewer();
            }
            if (adapter == IPropertySheetPage.class) {
                return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            if (adapter == GraphicalViewer.class) {
                return this.getGraphicalViewer();
            }
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.getGraphPage().doSave(monitor);
        boolean saved = this.getContentProvider().saveToInput(this.getEditorInput(), this.getRootContainer());
        if (saved) {
            this.getCommandStack().markSaveLocation();
            this.setDirty(false);
            this.firePropertyChange(257);
        }
        Node node = this.getDocumentElement(this.sourcePage);
        NodeDefinitionDTO nodeDefinitionDTO = Utility.createNodeDefinitionDTO(this.nodeDefinitionDTO.getId(), this.getNodeDefinition().getName(), Utility.getXMLFromDocument(node.getOwnerDocument()), TemplateResourcesUtility.getNodeDefinitionGpdXml());
        INodeDefinitionService service = ServiceFactory.createFactory().createNodeDefinitionService();
        try {
            this.nodeDefinitionDTO = service.saveNodeDefinition(nodeDefinitionDTO, Utility.getUserName());
        }
        catch (ServiceValidationException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid Node Definition", (String)"The node definition is invalid, can not save.");
            Utility.updateValidationErrors(this.getSite(), e.getValidationMessages());
        }
        catch (ServiceException e) {
            this.setDirty(true);
            this.firePropertyChange(257);
            throw new UIException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
    }

    public void dispose() {
        super.dispose();
        this.getEditorSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
        this.getEditorSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        this.getCommandStack().removeCommandStackListener(this.commandStackListener);
    }

    public String getDefaultImageFileName() {
        return NODEDEFINITIONIMAGE;
    }

    public String getPartName() {
        if (this.getRootContainer() == null || this.getNodeDefinition().getName() == null) {
            return super.getPartName();
        }
        return this.getNodeDefinition().getName();
    }

    protected SelectionSynchronizer createSelectionSynchronizer() {
        return new SelectionSynchronizer();
    }

    protected ContentProvider createContentProvider() {
        return new NodeDefinitionContentProvider();
    }

    protected SemanticElement createMainElement() {
        return this.getSemanticElementFactory().createById("com.tandbergtv.watchpoint.studio.nodeDefinition");
    }

    protected NodeDefinitionGraphicalViewer createGraphicalViewer() {
        return new NodeDefinitionGraphicalViewer(this){

            protected void initEditPartFactory() {
                this.setEditPartFactory(new GraphicalEditPartFactory());
            }
        };
    }

    private boolean isLockedByCurrentUser() {
        return this.nodeDefinitionDTO.getLock() != null && this.nodeDefinitionDTO.getLock().getOwnerId().equals(Utility.getUserName());
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IViewPart view;
        IWorkbenchPage page;
        if (partRef.getPart(false) != this) {
            return;
        }
        ServiceFactory factory = ServiceFactory.createFactory();
        INodeDefinitionService nodeDefinitionService = factory.createNodeDefinitionService();
        if (this.nodeDefinitionDTO != null) {
            long nodeDefinitionId = this.nodeDefinitionDTO.getId();
            nodeDefinitionService.closeNodeDefinition(nodeDefinitionId, Utility.getUserName());
        }
        if ((page = this.getSite().getPage()) != null && (view = page.findView("com.tandbergtv.gd.NodeDefinitionExplorer")) != null) {
            ((NodeDefinitionExplorer)view).refresh();
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }
}

