/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.service.IWorkflowTemplateService;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.GraphicalEditPartFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.WPContentProvider;
import com.tandbergtv.watchpoint.studio.ui.editor.WPFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.template.TemplateExplorer;
import java.util.EventObject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jbpm.gd.common.editor.ContentProvider;
import org.jbpm.gd.common.editor.Editor;
import org.jbpm.gd.common.editor.GraphicalViewer;
import org.jbpm.gd.common.editor.OutlineViewer;
import org.jbpm.gd.common.editor.SelectionSynchronizer;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.editor.JpdlDeploymentEditorPage;
import org.jbpm.gd.jpdl.editor.JpdlSelectionSynchronizer;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WatchPointTemplateEditor
extends Editor
implements IPartListener2 {
    private static final String PROCESSIMAGE_JPG = "processimage.jpg";
    WorkflowTemplateDTO templateDTO;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.templateDTO = (WorkflowTemplateDTO)((WPFileEditorInput)input).getWatchPointDTO();
        super.init(site, input);
        this.initPartName();
        Utility.setWindow(site.getWorkbenchWindow());
        this.initCommandStackListener();
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public boolean isDirty() {
        return this.isLockedByCurrentUser() && super.isDirty();
    }

    private void initPartName() {
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        IPath path = fileInput.getPath().removeLastSegments(1);
        path = path.removeFirstSegments(path.segmentCount() - 1);
        this.setPartName(path.lastSegment());
    }

    protected SelectionSynchronizer createSelectionSynchronizer() {
        return new JpdlSelectionSynchronizer();
    }

    protected ContentProvider createContentProvider() {
        return new WPContentProvider();
    }

    protected GraphicalViewer createGraphicalViewer() {
        return new GraphicalViewer(this){

            protected void initEditPartFactory() {
                this.setEditPartFactory(new GraphicalEditPartFactory());
            }
        };
    }

    protected OutlineViewer createOutlineViewer() {
        return null;
    }

    protected SemanticElement createMainElement() {
        return this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.processDefinition");
    }

    public String getDefaultImageFileName() {
        return PROCESSIMAGE_JPG;
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        Node node = this.getDocumentElement();
        WorkflowTemplateDTO templateDTO = Utility.createTemplateDTO(this.templateDTO.getId(), this.templateDTO.getVersion(), this.getProcessDefinition().getName(), Utility.getXMLFromDocument(node.getOwnerDocument()), TemplateResourcesUtility.getTemplateGpdXml());
        IWorkflowTemplateService service = ServiceFactory.createFactory().createWorkflowTemplateService();
        try {
            this.templateDTO = this.templateDTO.getVersion() == 0 ? service.createTemplate(templateDTO, Utility.getUserName(), true) : service.saveTemplate(templateDTO, Utility.getUserName());
            this.getProcessDefinition().setVersion(this.templateDTO.getVersion());
        }
        catch (ServiceException e) {
            this.setDirty(true);
            this.firePropertyChange(257);
            monitor.setCanceled(true);
            if (e instanceof ServiceValidationException) {
                ServiceValidationException sve = (ServiceValidationException)e;
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid Template", (String)"The template is invalid, can not save.");
                Utility.updateValidationErrors(this.getSite(), sve.getValidationMessages());
            }
            throw new UIException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
    }

    public void dispose() {
        super.dispose();
        this.getEditorSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
    }

    public WorkflowTemplate getProcessDefinition() {
        return (WorkflowTemplate)this.getRootContainer().getSemanticElement();
    }

    public void setTemplateDTO(WorkflowTemplateDTO templateDTO) {
        this.templateDTO = templateDTO;
    }

    public WorkflowTemplateDTO getTemplateDTO() {
        return this.templateDTO;
    }

    public String getTemplateDTOName() {
        return this.templateDTO != null ? this.templateDTO.getName() : null;
    }

    public String getPartName() {
        if (this.getRootContainer() == null) {
            return super.getPartName();
        }
        return this.getProcessDefinition().getName();
    }

    public Node getDocumentElement() {
        StructuredTextEditor sourcePage = this.getSourcePage();
        Element result = null;
        Document document = (Document)sourcePage.getAdapter(Document.class);
        if (document != null) {
            result = document.getDocumentElement();
        }
        return result;
    }

    protected void createPages() {
        super.createPages();
        this.getEditorSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
    }

    protected void addPage(int index, IEditorPart part, String label) {
        if (part instanceof JpdlDeploymentEditorPage) {
            return;
        }
        super.addPage(index, part, label);
    }

    protected void initSourcePage() {
        super.initSourcePage();
        WorkflowTemplate template = this.getProcessDefinition();
        NodeElement[] nodeElementArray = template.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            Transition[] transitionArray = node.getTransitions();
            int n3 = transitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Transition transition = transitionArray[n4];
                transition.setSource(node);
                ++n4;
            }
            ++n2;
        }
    }

    private StructuredTextEditor getSourcePage() {
        StructuredTextEditor sourcePage = null;
        int pageCount = this.getPageCount();
        int i = 0;
        while (i < pageCount) {
            if (this.getEditor(i) instanceof StructuredTextEditor) {
                sourcePage = (StructuredTextEditor)this.getEditor(i);
            }
            ++i;
        }
        return sourcePage;
    }

    private void initCommandStackListener() {
        CommandStackListener commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                WatchPointTemplateEditor.this.handleCommandStackChanged();
            }
        };
        this.getCommandStack().addCommandStackListener(commandStackListener);
    }

    private void handleCommandStackChanged() {
        this.handleTemplateChanged();
    }

    private void handleTemplateChanged() {
        if (this.templateDTO.getLock() == null || !this.templateDTO.getLock().getOwnerId().equals(Utility.getUserName())) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Template locked", (String)"This template is open in view mode, any changes you make will be lost.");
        }
    }

    private boolean isLockedByCurrentUser() {
        return this.templateDTO.getLock() != null && this.templateDTO.getLock().getOwnerId().equals(Utility.getUserName());
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IViewPart view;
        IWorkbenchPage page;
        if (partRef.getPart(false) != this) {
            return;
        }
        ServiceFactory factory = ServiceFactory.createFactory();
        IWorkflowTemplateService templateService = factory.createWorkflowTemplateService();
        if (this.templateDTO != null) {
            templateService.closeTemplate(this.templateDTO.getId(), Utility.getUserName());
        }
        if ((page = this.getSite().getPage()) != null && (view = page.findView("com.tandbergtv.gd.TemplateExplorer")) != null) {
            ((TemplateExplorer)view).refresh();
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }
}

