/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.AdaptorPage;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.GeneralPage;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ManagementPage;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.MessagesPage;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class ResourceTypeEditor
extends FormEditor {
    private static final Logger logger = Logger.getLogger(ResourceTypeEditor.class);
    private boolean editorModified = false;

    protected void addPages() {
        Message message;
        this.updateTitle();
        try {
            this.addPage((IFormPage)new GeneralPage(this));
            this.addPage((IFormPage)new AdaptorPage(this));
            this.addPage((IFormPage)new MessagesPage(this));
            this.addPage((IFormPage)new ManagementPage(this));
        }
        catch (PartInitException ex) {
            String msg = "Failed to initialize Resource Type Editor.";
            logger.error((Object)msg, (Throwable)ex);
            throw new UIException(msg, ex);
        }
        IEditorInput input = this.getEditorInput();
        if (input != null && (message = (Message)input.getAdapter(Message.class)) != null) {
            this.setActivePage("ResourceType.MessagesPage");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            int i = 0;
            while (i < this.getPageCount()) {
                Object page = this.pages.get(i);
                if (page instanceof IFormPage) {
                    IFormPage formPage = (IFormPage)page;
                    formPage.doSave(monitor);
                }
                ++i;
            }
            ResourceTypeEditorInput input = (ResourceTypeEditorInput)this.getEditorInput();
            ResourceType resourceType = (ResourceType)input.getAdapter(ResourceType.class);
            this.prepareResourceTypeForSave(resourceType);
            ServiceFactory serviceFactory = ServiceFactory.createFactory();
            IResourceTypeService service = serviceFactory.createResourceTypeService();
            resourceType = service.updateResourceType(resourceType);
            input.updatePersistedResourceType(resourceType);
            this.editorSaved();
        }
        catch (ServiceValidationException sve) {
            monitor.setCanceled(true);
            Shell shell = this.getSite().getShell();
            String message = "The Resource Type is invalid, please fix validation errors before saving.";
            MessageDialog.openError((Shell)shell, (String)this.getTitle(), (String)message);
            Utility.updateValidationErrors(this.getSite(), sve.getValidationMessages());
        }
        catch (ServiceException se) {
            monitor.setCanceled(true);
            Utility.reportError("Failed to save the Resource Type.", se);
        }
    }

    public ResourceType getResourceType() {
        int i = 0;
        while (i < this.getPageCount()) {
            Object page = this.pages.get(i);
            if (page instanceof IFormPage) {
                IFormPage formPage = (IFormPage)page;
                formPage.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
        ResourceTypeEditorInput input = (ResourceTypeEditorInput)this.getEditorInput();
        return (ResourceType)input.getAdapter(ResourceType.class);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof ResourceTypeEditorInput)) {
            String editorClassName = editorInput.getClass().getName();
            String expectedClassName = ResourceTypeEditorInput.class.getName();
            String msg = "Invalid Input, expecting input of type: " + expectedClassName + ", but received input of type: " + editorClassName;
            throw new PartInitException(msg);
        }
        super.init(site, editorInput);
        Utility.setWindow(site.getWorkbenchWindow());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.editorModified || super.isDirty();
    }

    public void editorDirtyStateChanged() {
        if (!this.editorModified && this.isDirty()) {
            this.editorModified = true;
        }
        super.editorDirtyStateChanged();
    }

    private void prepareResourceTypeForSave(ResourceType resourceType) {
        AdaptorType adaptorType = resourceType.getAdaptorType();
        if (adaptorType == null) {
            adaptorType = AdaptorType.NONE;
            resourceType.setAdaptorType(adaptorType);
        }
        if (adaptorType != AdaptorType.DEFAULT) {
            resourceType.setMessageIdentificationClassName(null);
        }
        if (adaptorType != AdaptorType.CUSTOM) {
            resourceType.setAdaptorClassName(null);
            resourceType.setAdaptorScope(null);
            resourceType.setAdaptorParameters(null);
        }
        if (!resourceType.isInitializationRequired()) {
            resourceType.setInitializationStrategyClass(null);
            resourceType.setInitializationParameters(null);
        }
        if (!resourceType.isHeartbeatRequired()) {
            resourceType.setHeartbeatStrategyClass(null);
            resourceType.setHeartbeatConnectionType(null);
            resourceType.setHeartbeatParameters(null);
        }
    }

    private void editorSaved() {
        this.editorModified = false;
        this.editorDirtyStateChanged();
        int i = 0;
        while (i < this.getPageCount()) {
            IFormPage formPage;
            IManagedForm managedForm;
            Object page = this.pages.get(i);
            if (page instanceof IFormPage && (managedForm = (formPage = (IFormPage)page).getManagedForm()) != null) {
                IFormPart[] iFormPartArray = managedForm.getParts();
                int n = iFormPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFormPart formPart = iFormPartArray[n2];
                    if (formPart instanceof AbstractFormPart) {
                        ((AbstractFormPart)formPart).markStale();
                    }
                    ++n2;
                }
            }
            ++i;
        }
        this.updateTitle();
        Utility.updateValidationErrors(this.getSite(), new ArrayList<ValidationMessage>());
    }

    private void updateTitle() {
        IEditorInput input = this.getEditorInput();
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }
}

