/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.input.IInputChangedListener;
import com.tandbergtv.watchpoint.studio.ui.editor.input.IWatchPointEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.input.InputChangedEvent;
import com.tandbergtv.watchpoint.studio.ui.editor.input.InputChangedEventManager;
import com.tandbergtv.watchpoint.studio.ui.model.IEditableElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

public class ResourceTypeEditorInput
implements IWatchPointEditorInput,
IEditableElement {
    private ResourceType resourceType;
    private ResourceType persistedResourceType;
    private Message message;
    private boolean isEditable = true;
    private InputChangedEventManager eventManager = new InputChangedEventManager();

    public ResourceTypeEditorInput(ResourceType resourceType) {
        this(resourceType, null, true);
    }

    public ResourceTypeEditorInput(ResourceType resourceType, boolean isEditable) {
        this(resourceType, null, isEditable);
    }

    public ResourceTypeEditorInput(ResourceType resourceType, Message message) {
        this(resourceType, message, true);
    }

    public ResourceTypeEditorInput(ResourceType resourceType, Message message, boolean isEditable) {
        this.setPersistedResourceType(resourceType);
        this.message = message;
        this.isEditable = isEditable;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        String name = this.resourceType.getName();
        name = String.valueOf(name) + " [" + this.resourceType.getSystemId() + "]";
        if (!this.isEditable) {
            name = String.valueOf(name) + " (Read Only)";
        }
        return name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapterClass) {
        Object adapter = null;
        if (adapterClass.isInstance(this.resourceType)) {
            adapter = this.resourceType;
        } else if (adapterClass.isInstance(this.message)) {
            adapter = this.message;
        } else {
            if (adapterClass.isInstance(this)) {
                return this;
            }
            adapter = Platform.getAdapterManager().getAdapter((Object)this, adapterClass);
        }
        return adapter;
    }

    public boolean canEdit() {
        return this.isEditable;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Message getMessage() {
        return this.message;
    }

    public ResourceType getPersistedResourceType() {
        return this.persistedResourceType;
    }

    private void setPersistedResourceType(ResourceType resourceType) {
        this.persistedResourceType = resourceType;
        this.resourceType = resourceType.clone();
    }

    public void updatePersistedResourceType(ResourceType updatedResourceType) {
        if (!this.persistedResourceType.equals(updatedResourceType)) {
            String msg = "The updated Resource Type must have the same key as the current Resource Type in the input.";
            throw new IllegalArgumentException(msg);
        }
        this.persistedResourceType = updatedResourceType;
        this.resourceType = updatedResourceType.clone();
        InputChangedEvent event = new InputChangedEvent(this);
        this.eventManager.fireInputChanged(event);
    }

    public void addCreatedMessage(Message message) {
        this.persistedResourceType.addMessage(message);
        Message clonedMessage = message.clone();
        this.resourceType.addMessage(clonedMessage);
        InputChangedEvent event = new InputChangedEvent(this);
        this.eventManager.fireInputChanged(event);
    }

    public void removeDeletedMessage(Message message) {
        this.persistedResourceType.removeMessage(message);
        this.resourceType.removeMessage(message);
        InputChangedEvent event = new InputChangedEvent(this);
        this.eventManager.fireInputChanged(event);
    }

    public void addInputChangedListener(IInputChangedListener listener) {
        this.eventManager.addInputChangedListener(listener);
    }

    public void removeInputChangedListener(IInputChangedListener listener) {
        this.eventManager.removeInputChangedListener(listener);
    }

    public int hashCode() {
        if (this.resourceType == null) {
            return super.hashCode();
        }
        int hashCode = 3 * this.resourceType.hashCode() - 421;
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceTypeEditorInput)) {
            return false;
        }
        ResourceTypeEditorInput input = (ResourceTypeEditorInput)obj;
        if (this.resourceType != null) {
            return this.resourceType.equals(input.resourceType);
        }
        return super.equals(obj);
    }
}

