/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ResourceTypeParameterDialog
extends StatusDialog {
    protected Composite formComposite;
    protected Label nameLabel;
    protected Label valueLabel;
    protected Text nameText;
    protected Text valueText;
    protected IInputValidator nameValidator;
    protected IInputValidator valueValidator;
    protected String pluginId;
    protected boolean isValidating = true;
    private String inputParameterName = null;
    private String inputParameterValue = null;
    private String outputParameterName = null;
    private String outputParameterValue = null;
    private String nameErrorMessage = null;
    private String valueErrorMessage = null;

    public ResourceTypeParameterDialog(Shell parent, String pluginId) {
        this(parent, pluginId, null, null);
    }

    public ResourceTypeParameterDialog(Shell parent, String pluginId, String parameterName, String parameterValue) {
        super(parent);
        this.setTitle("Resource Type Parameter Editor");
        this.pluginId = pluginId;
        this.inputParameterName = parameterName;
        this.inputParameterValue = parameterValue;
    }

    public void setParameterNameValidator(IInputValidator validator) {
        this.nameValidator = validator;
    }

    public void setParameterValueValidator(IInputValidator validator) {
        this.valueValidator = validator;
    }

    public String getParameterName() {
        return this.outputParameterName;
    }

    public String getParameterValue() {
        return this.outputParameterValue;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createDialogControls(composite);
        this.initializeDialogLayouts(composite);
        this.populateInitialData();
        return composite;
    }

    protected void okPressed() {
        this.validateParameterName();
        this.validateParameterData();
        IStatus currentStatus = this.getStatus();
        if (currentStatus != null && !currentStatus.matches(4)) {
            this.outputParameterName = this.nameText.getText().trim();
            this.outputParameterValue = this.valueText.getText();
            super.okPressed();
        }
    }

    protected void createDialogControls(Composite parent) {
        this.formComposite = new Composite(parent, 0);
        int orientation = Window.getDefaultOrientation();
        this.nameLabel = new Label(this.formComposite, orientation);
        this.nameLabel.setText("Name: ");
        this.nameText = new Text(this.formComposite, 0x804 | orientation);
        this.nameText.setTextLimit(50);
        this.nameText.addFocusListener((FocusListener)new ValidatingFocusListener());
        this.nameText.addModifyListener((ModifyListener)new ValidatingModifyListener());
        this.valueLabel = new Label(this.formComposite, orientation);
        this.valueLabel.setText("Value: ");
        this.valueText = new Text(this.formComposite, 0xB02 | orientation);
        this.valueText.setTextLimit(256);
        this.valueText.addFocusListener((FocusListener)new ValidatingFocusListener());
        this.valueText.addModifyListener((ModifyListener)new ValidatingModifyListener());
    }

    protected void initializeDialogLayouts(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 2;
        layout.marginLeft = 2;
        layout.marginBottom = 2;
        layout.marginTop = 2;
        layout.verticalSpacing = 10;
        this.formComposite.setLayout((Layout)layout);
        this.nameLabel.setLayoutData((Object)this.createGridData());
        GridData layoutData = this.createGridData();
        layoutData.widthHint = 220 + this.valueText.getVerticalBar().getSize().x;
        this.nameText.setLayoutData((Object)layoutData);
        this.valueLabel.setLayoutData((Object)this.createGridData());
        layoutData = this.createGridData();
        layoutData.widthHint = 220;
        layoutData.heightHint = 60;
        this.valueText.setLayoutData((Object)layoutData);
    }

    protected void populateInitialData() {
        this.isValidating = false;
        String name = this.inputParameterName != null ? this.inputParameterName.trim() : "";
        String value = this.inputParameterValue != null ? this.inputParameterValue : "";
        this.nameText.setText(name);
        this.valueText.setText(value);
        this.nameErrorMessage = null;
        this.valueErrorMessage = null;
        this.updateStatus();
        this.isValidating = true;
    }

    private GridData createGridData() {
        return new GridData(1, 1, false, false);
    }

    private void validateParameterData() {
        if (!this.isValidating) {
            return;
        }
        String name = this.nameText.getText().trim();
        this.nameErrorMessage = this.validateData(this.nameValidator, name);
        this.valueErrorMessage = this.validateData(this.valueValidator, this.valueText.getText());
        this.updateStatus();
    }

    private void validateParameterName() {
        if (!this.isValidating) {
            return;
        }
        String name = this.nameText.getText().trim();
        this.nameErrorMessage = this.validateData(this.nameValidator, name);
        this.updateStatus();
    }

    private void validateParameterValue() {
        if (!this.isValidating) {
            return;
        }
        String value = this.valueText.getText();
        this.valueErrorMessage = this.validateData(this.valueValidator, value);
        this.updateStatus();
    }

    private String validateData(IInputValidator validator, String data) {
        String newError = null;
        if (validator != null) {
            newError = validator.isValid(data);
        }
        return newError;
    }

    private void updateStatus() {
        IStatus newStatus = Status.OK_STATUS;
        if (this.nameErrorMessage != null) {
            newStatus = new Status(4, this.pluginId, this.nameErrorMessage);
        } else if (this.valueErrorMessage != null) {
            newStatus = new Status(4, this.pluginId, this.valueErrorMessage);
        }
        this.updateStatus(newStatus);
    }

    private class ValidatingFocusListener
    extends FocusAdapter {
        private ValidatingFocusListener() {
        }

        public void focusLost(FocusEvent event) {
            if (event.getSource() == ResourceTypeParameterDialog.this.nameText) {
                String name = ResourceTypeParameterDialog.this.nameText.getText();
                if (!name.trim().equals(name)) {
                    ResourceTypeParameterDialog.this.nameText.setText(name.trim());
                }
                ResourceTypeParameterDialog.this.validateParameterName();
            } else if (event.getSource() == ResourceTypeParameterDialog.this.valueText) {
                ResourceTypeParameterDialog.this.validateParameterValue();
            }
        }
    }

    private class ValidatingModifyListener
    implements ModifyListener {
        private ValidatingModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            if (event.getSource() == ResourceTypeParameterDialog.this.nameText) {
                ResourceTypeParameterDialog.this.validateParameterName();
            } else if (event.getSource() == ResourceTypeParameterDialog.this.valueText) {
                ResourceTypeParameterDialog.this.validateParameterValue();
            }
        }
    }
}

