/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeParameterNameValidator
implements IInputValidator {
    private Set<String> usedNames = new HashSet<String>();
    private String currentName = null;

    public ResourceTypeParameterNameValidator(Collection<String> existingNames) {
        this(existingNames, null);
    }

    public ResourceTypeParameterNameValidator(Collection<String> existingNames, String currentName) {
        if (existingNames != null) {
            this.usedNames.addAll(existingNames);
        }
        this.currentName = currentName;
        if (currentName == null) {
            currentName = "";
        }
    }

    public String getCurrentName() {
        return this.currentName;
    }

    public Set<String> getUsedNames() {
        return this.usedNames;
    }

    public String isValid(String name) {
        String errorMessage = null;
        String string = name = name != null ? name.trim() : "";
        if (name.length() == 0) {
            errorMessage = "The Parameter Name cannot be blank.";
        } else if (!name.equals(this.currentName) && this.usedNames.contains(name)) {
            errorMessage = "A Parameter with the same name already exists.";
        }
        return errorMessage;
    }
}

