/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ResourceTypeFormPage;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.AdaptorTypeSectionPart;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.CustomAdaptorSectionPart;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.DefaultAdaptorSectionPart;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AdaptorPage
extends ResourceTypeFormPage {
    private static final String PAGE_TITLE = "Adaptor";
    private static final String PAGE_HEADER = "Adaptor Configuration";
    public static final String PAGE_ID = "ResourceType.AdaptorPage";
    AdaptorTypeSectionPart typePart;
    DefaultAdaptorSectionPart defaultPart;
    CustomAdaptorSectionPart customPart;
    Composite configComposite;
    StackLayout configLayout;

    public AdaptorPage(ResourceTypeEditor editor) {
        super(editor, PAGE_ID, PAGE_TITLE);
    }

    protected void createPageControls() {
        IManagedForm managedForm = this.getManagedForm();
        ScrolledForm form = managedForm.getForm();
        form.setText(PAGE_HEADER);
        Composite formBody = form.getBody();
        FormToolkit toolkit = managedForm.getToolkit();
        int style = AdaptorPage.getDefaultSectionStyle();
        this.typePart = new AdaptorTypeSectionPart((IEditorPart)this, formBody, toolkit, style);
        this.typePart.getSection().setText("Adaptor Type");
        managedForm.addPart((IFormPart)this.typePart);
        this.configComposite = toolkit.createComposite(formBody);
        toolkit.paintBordersFor(this.configComposite);
        this.defaultPart = new DefaultAdaptorSectionPart((IEditorPart)this, this.configComposite, toolkit, style);
        this.defaultPart.getSection().setText("Default Adaptor Configuration");
        managedForm.addPart((IFormPart)this.defaultPart);
        this.customPart = new CustomAdaptorSectionPart((IEditorPart)this, this.configComposite, toolkit, style);
        this.customPart.getSection().setText("Custom Adaptor Configuration");
        managedForm.addPart((IFormPart)this.customPart);
        this.typePart.getTypeCombo().addSelectionListener((SelectionListener)new TypeSelectionListener());
    }

    protected void initializePageLayout() {
        Composite formBody = this.getManagedForm().getForm().getBody();
        formBody.setLayout((Layout)this.createGridLayout(1, false));
        this.typePart.getSection().setLayoutData((Object)this.createSectionGridData());
        this.configComposite.setLayoutData((Object)this.createSectionGridData());
        this.configLayout = new StackLayout();
        this.configLayout.topControl = null;
        this.configComposite.setLayout((Layout)this.configLayout);
    }

    protected void populatePageData() {
        super.populatePageData();
        this.handleTypeSelection();
    }

    private void handleTypeSelection() {
        AdaptorType adaptorType = this.typePart.getAdaptorType();
        if (adaptorType == null) {
            adaptorType = AdaptorType.NONE;
        }
        Section topControl = null;
        switch (adaptorType) {
            case DEFAULT: {
                topControl = this.defaultPart.getSection();
                break;
            }
            case CUSTOM: {
                topControl = this.customPart.getSection();
            }
        }
        if (this.configLayout.topControl != topControl) {
            this.configLayout.topControl = topControl;
            this.configComposite.layout();
        }
    }

    class TypeSelectionListener
    implements SelectionListener {
        TypeSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            AdaptorPage.this.handleTypeSelection();
        }

        public void widgetSelected(SelectionEvent event) {
            AdaptorPage.this.handleTypeSelection();
        }
    }
}

