/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.model.IEditableElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

public abstract class ResourceTypeFormPage
extends FormPage {
    public ResourceTypeFormPage(ResourceTypeEditor editor, String pageId, String pageTitle) {
        super((FormEditor)editor, pageId, pageTitle);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createPageControls();
        this.initializePageLayout();
        this.populatePageData();
        this.setWidgetPermissions();
        managedForm.getForm().pack();
    }

    protected abstract void createPageControls();

    protected abstract void initializePageLayout();

    protected void populatePageData() {
        this.getManagedForm().setInput((Object)this.getEditorInput());
    }

    protected void setWidgetPermissions() {
    }

    public static int getDefaultSectionStyle() {
        return 368;
    }

    protected GridLayout createGridLayout(int columns, boolean equalColumnSize) {
        GridLayout gridLayout = new GridLayout(columns, equalColumnSize);
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 15;
        return gridLayout;
    }

    protected GridData createSectionGridData() {
        return new GridData(4, 1, true, false);
    }

    protected ResourceType getResourceType() {
        IEditorInput input = this.getEditorInput();
        return input != null ? (ResourceType)input.getAdapter(ResourceType.class) : null;
    }

    protected boolean isInputEditable() {
        IEditableElement editableElement;
        boolean isEditable = true;
        IEditorInput input = this.getEditorInput();
        if (input != null && (editableElement = (IEditableElement)input.getAdapter(IEditableElement.class)) != null) {
            isEditable = editableElement.canEdit();
        }
        return isEditable;
    }
}

