/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AdaptorTypeSectionPart
extends ResourceTypeSectionPart {
    Label typeLabel;
    CCombo typeCombo;
    private List<AdaptorType> adaptorTypes = new ArrayList<AdaptorType>();

    public AdaptorTypeSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit, int style) {
        super(parentPart, parent, toolkit, style);
    }

    public AdaptorType getAdaptorType() {
        int index = this.typeCombo.getSelectionIndex();
        AdaptorType adaptorType = AdaptorType.NONE;
        if (index != -1) {
            adaptorType = this.adaptorTypes.get(index);
        }
        return adaptorType;
    }

    public CCombo getTypeCombo() {
        return this.typeCombo;
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            int index = this.typeCombo.getSelectionIndex();
            AdaptorType adaptorType = AdaptorType.NONE;
            if (index != -1) {
                adaptorType = this.adaptorTypes.get(index);
            }
            resourceType.setAdaptorType(adaptorType);
        }
    }

    protected void createSectionClientControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.typeLabel = toolkit.createLabel(this.sectionClient, "Adaptor Type: ");
        int style = toolkit.getBorderStyle() | 8;
        this.typeCombo = new CCombo(this.sectionClient, style);
        toolkit.adapt((Control)this.typeCombo, true, true);
        this.typeCombo.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
    }

    protected void initializeSectionClientLayout(IManagedForm managedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        this.typeLabel.setLayoutData((Object)this.createLabelGridData());
        this.typeCombo.setLayoutData((Object)this.createGridData());
    }

    protected void populateSectionData() {
        int defaultIndex;
        ResourceType resourceType = this.getResourceType();
        this.typeCombo.removeAll();
        this.adaptorTypes.clear();
        AdaptorType[] adaptorTypeArray = AdaptorType.values();
        int n = adaptorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AdaptorType adaptorType = adaptorTypeArray[n2];
            this.adaptorTypes.add(adaptorType);
            this.typeCombo.add(this.getAdaptorTypeDisplayName(adaptorType));
            ++n2;
        }
        int index = defaultIndex = this.adaptorTypes.indexOf(AdaptorType.NONE);
        if (resourceType != null && (index = this.adaptorTypes.indexOf(resourceType.getAdaptorType())) == -1) {
            index = defaultIndex;
        }
        this.typeCombo.select(index);
    }

    protected void setWidgetPermissions() {
        boolean isEditable = this.isInputEditable();
        this.typeCombo.setEnabled(isEditable);
    }

    private String getAdaptorTypeDisplayName(AdaptorType adaptorType) {
        String value = adaptorType.toString();
        switch (adaptorType) {
            case NONE: {
                value = "None";
                break;
            }
            case CUSTOM: {
                value = "Custom";
                break;
            }
            case DEFAULT: {
                value = "Default";
            }
        }
        return value;
    }
}

