/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.AdaptorScope;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ParametersCompositeContainer;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import java.util.Map;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CustomAdaptorSectionPart
extends ResourceTypeSectionPart {
    Label classNameLabel;
    Label parametersLabel;
    Text classNameText;
    Composite parametersComposite;
    ParametersCompositeContainer parametersContainer;

    public CustomAdaptorSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit, int style) {
        super(parentPart, parent, toolkit, style);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            String className = this.classNameText.getText();
            resourceType.setAdaptorClassName(className);
            resourceType.setAdaptorScope(AdaptorScope.APPLICATION);
            Map<String, String> parameters = this.parametersContainer.getParameters();
            resourceType.setAdaptorParameters(parameters);
        }
    }

    protected void createSectionClientControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.classNameLabel = toolkit.createLabel(this.sectionClient, "Adaptor Class: ");
        this.classNameText = toolkit.createText(this.sectionClient, "");
        this.classNameText.setTextLimit(256);
        this.classNameText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.classNameText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.parametersLabel = toolkit.createLabel(this.sectionClient, "Adaptor Parameters: ");
        this.parametersComposite = toolkit.createComposite(this.sectionClient);
        toolkit.paintBordersFor(this.parametersComposite);
        this.parametersContainer = new ParametersCompositeContainer(this.editorPart, (AbstractFormPart)this, toolkit, this.parametersComposite);
    }

    protected void initializeSectionClientLayout(IManagedForm managedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        this.classNameLabel.setLayoutData((Object)this.createLabelGridData());
        this.parametersLabel.setLayoutData((Object)this.createLabelGridData());
        GridData layoutData = this.createGridData();
        layoutData.widthHint = this.getDefaultClassNameTextWidth();
        this.classNameText.setLayoutData((Object)layoutData);
        this.parametersComposite.setLayoutData((Object)this.createGridData());
    }

    protected void populateSectionData() {
        ResourceType resourceType = this.getResourceType();
        boolean isEditable = this.isInputEditable();
        if (resourceType != null) {
            String className = resourceType.getAdaptorClassName();
            this.classNameText.setText(this.formatValue(className, true));
            Map<String, String> adaptorParameters = resourceType.getAdaptorParameters();
            this.parametersContainer.setInput(adaptorParameters, isEditable);
        } else {
            this.classNameText.setText("");
            this.parametersContainer.setInput(null, isEditable);
        }
    }

    protected void setWidgetPermissions() {
        boolean isEditable = this.isInputEditable();
        this.classNameText.setEditable(isEditable);
    }
}

