/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DefaultAdaptorSectionPart
extends ResourceTypeSectionPart {
    Label messageIdentifierLabel;
    Label defaultMessageLabel;
    Text messageIdentifierText;

    public DefaultAdaptorSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit, int style) {
        super(parentPart, parent, toolkit, style);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            String className = this.messageIdentifierText.getText();
            resourceType.setMessageIdentificationClassName(className);
        }
    }

    protected void createSectionClientControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        String labelName = "Message Identifier Class: ";
        this.messageIdentifierLabel = toolkit.createLabel(this.sectionClient, labelName);
        this.messageIdentifierText = toolkit.createText(this.sectionClient, "");
        this.messageIdentifierText.setTextLimit(256);
        this.messageIdentifierText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.messageIdentifierText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        toolkit.createLabel(this.sectionClient, "");
        labelName = "* Leave blank in order to use default Message Identifier implementation.";
        this.defaultMessageLabel = toolkit.createLabel(this.sectionClient, labelName, 64);
    }

    protected void initializeSectionClientLayout(IManagedForm managedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        this.messageIdentifierLabel.setLayoutData((Object)this.createLabelGridData());
        this.defaultMessageLabel.setLayoutData((Object)this.createLabelGridData());
        GridData layoutData = this.createGridData();
        layoutData.widthHint = this.getDefaultClassNameTextWidth();
        this.messageIdentifierText.setLayoutData((Object)layoutData);
    }

    protected void populateSectionData() {
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            String className = resourceType.getMessageIdentificationClassName();
            this.messageIdentifierText.setText(this.formatValue(className, true));
        } else {
            this.messageIdentifierText.setText("");
        }
    }

    protected void setWidgetPermissions() {
        boolean isEditable = this.isInputEditable();
        this.messageIdentifierText.setEditable(isEditable);
    }
}

