/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GeneralSectionPart
extends ResourceTypeSectionPart {
    Label nameLabel;
    Label systemIdLabel;
    Label descriptionLabel;
    Label connectionTypeLabel;
    Text nameText;
    Text systemIdText;
    Text descriptionText;
    CCombo connectionTypeCombo;
    private List<ConnectionType> connectionTypes = new ArrayList<ConnectionType>();

    public GeneralSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit, int style) {
        super(parentPart, parent, toolkit, style);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            resourceType.setName(this.nameText.getText());
            resourceType.setSystemId(this.systemIdText.getText());
            resourceType.setDescription(this.descriptionText.getText());
            int index = this.connectionTypeCombo.getSelectionIndex();
            ConnectionType connectionType = index != -1 ? this.connectionTypes.get(index) : null;
            resourceType.setConnectionType(connectionType);
        }
    }

    protected void createSectionClientControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.nameLabel = toolkit.createLabel(this.sectionClient, "Name: ");
        this.nameText = toolkit.createText(this.sectionClient, "");
        this.nameText.setTextLimit(50);
        this.nameText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.nameText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.systemIdLabel = toolkit.createLabel(this.sectionClient, "System ID: ");
        this.systemIdText = toolkit.createText(this.sectionClient, "", 12);
        this.systemIdText.setTextLimit(10);
        this.descriptionLabel = toolkit.createLabel(this.sectionClient, "Description: ");
        this.descriptionText = toolkit.createText(this.sectionClient, "", 770);
        this.descriptionText.setTextLimit(256);
        this.descriptionText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.connectionTypeLabel = toolkit.createLabel(this.sectionClient, "Connection Type: ");
        int style = 8 | toolkit.getBorderStyle();
        this.connectionTypeCombo = new CCombo(this.sectionClient, style);
        toolkit.adapt((Control)this.connectionTypeCombo, true, true);
        this.connectionTypeCombo.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
    }

    protected void initializeSectionClientLayout(IManagedForm managedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        this.nameLabel.setLayoutData((Object)this.createLabelGridData());
        this.systemIdLabel.setLayoutData((Object)this.createLabelGridData());
        this.descriptionLabel.setLayoutData((Object)this.createLabelGridData());
        this.connectionTypeLabel.setLayoutData((Object)this.createLabelGridData());
        this.systemIdText.setLayoutData((Object)this.createGridData());
        this.connectionTypeCombo.setLayoutData((Object)this.createGridData());
        GridData layoutData = this.createGridData();
        layoutData.widthHint = 200;
        this.nameText.setLayoutData((Object)layoutData);
        layoutData = this.createGridData();
        layoutData.widthHint = 300;
        layoutData.heightHint = 100;
        this.descriptionText.setLayoutData((Object)layoutData);
    }

    protected void populateSectionData() {
        ResourceType resourceType = this.getResourceType();
        List<ConnectionType> connectionTypeList = this.getAvailableConnectionTypes();
        if (connectionTypeList != null) {
            this.connectionTypes.clear();
            this.connectionTypes.addAll(connectionTypeList);
            this.connectionTypeCombo.removeAll();
            for (ConnectionType connectionType : this.connectionTypes) {
                this.connectionTypeCombo.add(connectionType.getName());
            }
        }
        if (resourceType != null) {
            ConnectionType connectionType;
            this.nameText.setText(this.formatValue(resourceType.getName(), true));
            this.systemIdText.setText(this.formatValue(resourceType.getSystemId(), true));
            this.descriptionText.setText(this.formatValue(resourceType.getDescription(), false));
            connectionType = resourceType.getConnectionType();
            String value = connectionType != null ? connectionType.getName() : null;
            this.connectionTypeCombo.setText(this.formatValue(value, false));
        } else {
            this.nameText.setText("");
            this.systemIdText.setText("");
            this.descriptionText.setText("");
            this.connectionTypeCombo.setText("");
        }
    }

    protected void setWidgetPermissions() {
        boolean isEditable = this.isInputEditable();
        this.nameText.setEditable(isEditable);
        this.descriptionText.setEditable(isEditable);
        this.connectionTypeCombo.setEnabled(isEditable);
    }
}

