/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ParametersCompositeContainer;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HeartbeatSectionPart
extends ResourceTypeSectionPart {
    Label classLabel;
    Label connectionTypeLabel;
    Label parametersLabel;
    Button requiredButton;
    Group configGroup;
    Text classText;
    CCombo connectionTypeCombo;
    Composite parametersComposite;
    ParametersCompositeContainer parametersContainer;
    private List<ConnectionType> connectionTypes = new ArrayList<ConnectionType>();

    public HeartbeatSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit, int style) {
        super(parentPart, parent, toolkit, style);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            resourceType.setHeartbeatRequired(this.requiredButton.getSelection());
            resourceType.setHeartbeatStrategyClass(this.classText.getText());
            int index = this.connectionTypeCombo.getSelectionIndex();
            ConnectionType connectionType = index != -1 ? this.connectionTypes.get(index) : null;
            resourceType.setHeartbeatConnectionType(connectionType);
            Map<String, String> parameters = this.parametersContainer.getParameters();
            resourceType.setHeartbeatParameters(parameters);
        }
    }

    protected void createSectionClientControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.requiredButton = toolkit.createButton(this.sectionClient, "Requires Heartbeats", 16416);
        this.requiredButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.configGroup = new Group(this.sectionClient, 0);
        toolkit.adapt((Composite)this.configGroup);
        toolkit.paintBordersFor((Composite)this.configGroup);
        this.classLabel = toolkit.createLabel((Composite)this.configGroup, "Heartbeat Strategy Class: ");
        this.classText = toolkit.createText((Composite)this.configGroup, "");
        this.classText.setTextLimit(256);
        this.classText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.classText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.connectionTypeLabel = toolkit.createLabel((Composite)this.configGroup, "Heartbeat Connection Type: ");
        int style = 8 | toolkit.getBorderStyle();
        this.connectionTypeCombo = new CCombo((Composite)this.configGroup, style);
        toolkit.adapt((Control)this.connectionTypeCombo, true, true);
        this.connectionTypeCombo.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.parametersLabel = toolkit.createLabel((Composite)this.configGroup, "Heartbeat Parameters: ");
        this.parametersComposite = toolkit.createComposite((Composite)this.configGroup);
        toolkit.paintBordersFor(this.parametersComposite);
        this.parametersContainer = new ParametersCompositeContainer(this.editorPart, (AbstractFormPart)this, toolkit, this.parametersComposite);
    }

    protected void initializeSectionClientLayout(IManagedForm managedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(1, false));
        this.requiredButton.setLayoutData((Object)this.createGridData());
        this.configGroup.setLayoutData((Object)this.createGridData());
        this.configGroup.setLayout((Layout)this.createGridLayout(2, false));
        this.classLabel.setLayoutData((Object)this.createLabelGridData());
        this.connectionTypeLabel.setLayoutData((Object)this.createLabelGridData());
        this.parametersLabel.setLayoutData((Object)this.createLabelGridData());
        this.connectionTypeCombo.setLayoutData((Object)this.createGridData());
        GridData layoutData = this.createGridData();
        layoutData.widthHint = this.getDefaultClassNameTextWidth();
        this.classText.setLayoutData((Object)layoutData);
        this.parametersComposite.setLayoutData((Object)this.createGridData());
    }

    protected void populateSectionData() {
        ResourceType resourceType = this.getResourceType();
        boolean isEditable = this.isInputEditable();
        List<ConnectionType> connectionTypeList = this.getAvailableConnectionTypes();
        if (connectionTypeList != null) {
            this.connectionTypes.clear();
            this.connectionTypes.addAll(connectionTypeList);
            this.connectionTypeCombo.removeAll();
            for (ConnectionType connectionType : this.connectionTypes) {
                this.connectionTypeCombo.add(connectionType.getName());
            }
        }
        if (resourceType != null) {
            this.requiredButton.setSelection(resourceType.isHeartbeatRequired());
            String strategyClassName = resourceType.getHeartbeatStrategyClass();
            this.classText.setText(this.formatValue(strategyClassName, true));
            ConnectionType connectionType = resourceType.getHeartbeatConnectionType();
            String value = connectionType != null ? connectionType.getName() : null;
            this.connectionTypeCombo.setText(this.formatValue(value, false));
            Map<String, String> parameters = resourceType.getHeartbeatParameters();
            this.parametersContainer.setInput(parameters, isEditable);
        } else {
            this.requiredButton.setSelection(false);
            this.classText.setText("");
            this.connectionTypeCombo.setText("");
            this.parametersContainer.setInput(null, isEditable);
        }
    }

    protected void setWidgetPermissions() {
        boolean isEditable = this.isInputEditable();
        this.requiredButton.setEnabled(isEditable);
        this.classText.setEditable(isEditable);
        this.connectionTypeCombo.setEnabled(isEditable);
        this.updateConfigControlAccess();
    }

    private void updateConfigControlAccess() {
        boolean isRequired = this.requiredButton.getSelection();
        this.configGroup.setEnabled(isRequired);
        this.classText.setEnabled(isRequired);
        this.connectionTypeCombo.setEnabled(this.isInputEditable() && isRequired);
        this.parametersContainer.setEnabled(isRequired);
    }

    private void handleRequiredButtonSelected() {
        if (!this.isInputEditable()) {
            return;
        }
        this.updateConfigControlAccess();
        this.configGroup.redraw();
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private ButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            HeartbeatSectionPart.this.handleRequiredButtonSelected();
        }

        public void widgetSelected(SelectionEvent event) {
            HeartbeatSectionPart.this.handleRequiredButtonSelected();
            if (!HeartbeatSectionPart.this.isDirty()) {
                HeartbeatSectionPart.this.markDirty();
            }
        }
    }
}

