/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ParametersCompositeContainer;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import java.util.Map;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InitializationSectionPart
extends ResourceTypeSectionPart {
    protected Label classLabel;
    protected Label parametersLabel;
    protected Button requiredButton;
    protected Group configGroup;
    protected Text classText;
    protected Composite parametersComposite;
    protected ParametersCompositeContainer parametersContainer;

    public InitializationSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit, int style) {
        super(parentPart, parent, toolkit, style);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            resourceType.setInitializationRequired(this.requiredButton.getSelection());
            resourceType.setInitializationStrategyClass(this.classText.getText());
            Map<String, String> parameters = this.parametersContainer.getParameters();
            resourceType.setInitializationParameters(parameters);
        }
    }

    protected void createSectionClientControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.requiredButton = toolkit.createButton(this.sectionClient, "Requires Initialization", 16416);
        this.requiredButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.configGroup = new Group(this.sectionClient, 0);
        toolkit.adapt((Composite)this.configGroup);
        toolkit.paintBordersFor((Composite)this.configGroup);
        this.classLabel = toolkit.createLabel((Composite)this.configGroup, "Initialization Strategy Class: ");
        this.classText = toolkit.createText((Composite)this.configGroup, "");
        this.classText.setTextLimit(256);
        this.classText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.classText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.parametersLabel = toolkit.createLabel((Composite)this.configGroup, "Initialization Parameters: ");
        this.parametersComposite = toolkit.createComposite((Composite)this.configGroup);
        toolkit.paintBordersFor(this.parametersComposite);
        this.parametersContainer = new ParametersCompositeContainer(this.editorPart, (AbstractFormPart)this, toolkit, this.parametersComposite);
    }

    protected void initializeSectionClientLayout(IManagedForm managedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(1, false));
        this.requiredButton.setLayoutData((Object)this.createGridData());
        this.configGroup.setLayoutData((Object)this.createGridData());
        this.configGroup.setLayout((Layout)this.createGridLayout(2, false));
        this.classLabel.setLayoutData((Object)this.createLabelGridData());
        this.parametersLabel.setLayoutData((Object)this.createLabelGridData());
        GridData layoutData = this.createGridData();
        layoutData.widthHint = this.getDefaultClassNameTextWidth();
        this.classText.setLayoutData((Object)layoutData);
        this.parametersComposite.setLayoutData((Object)this.createGridData());
    }

    protected void populateSectionData() {
        ResourceType resourceType = this.getResourceType();
        boolean isEditable = this.isInputEditable();
        if (resourceType != null) {
            this.requiredButton.setSelection(resourceType.isInitializationRequired());
            String strategyClassName = resourceType.getInitializationStrategyClass();
            this.classText.setText(this.formatValue(strategyClassName, true));
            Map<String, String> parameters = resourceType.getInitializationParameters();
            this.parametersContainer.setInput(parameters, isEditable);
        } else {
            this.requiredButton.setSelection(false);
            this.classText.setText("");
            this.parametersContainer.setInput(null, isEditable);
        }
    }

    protected void setWidgetPermissions() {
        boolean isEditable = this.isInputEditable();
        this.requiredButton.setEnabled(isEditable);
        this.classText.setEditable(isEditable);
        this.updateConfigControlAccess();
    }

    private void updateConfigControlAccess() {
        boolean isRequired = this.requiredButton.getSelection();
        this.configGroup.setEnabled(isRequired);
        this.classText.setEnabled(isRequired);
        this.parametersContainer.setEnabled(isRequired);
    }

    private void handleRequiredButtonSelected() {
        if (!this.isInputEditable()) {
            return;
        }
        this.updateConfigControlAccess();
        this.configGroup.redraw();
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private ButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            InitializationSectionPart.this.handleRequiredButtonSelected();
        }

        public void widgetSelected(SelectionEvent event) {
            InitializationSectionPart.this.handleRequiredButtonSelected();
            if (!InitializationSectionPart.this.isDirty()) {
                InitializationSectionPart.this.markDirty();
            }
        }
    }
}

