/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.MessageInput;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

class MessageDetailsSectionPart
extends ResourceTypeSectionPart {
    private static final String INCOMING_TYPE = "Incoming";
    private static final String OUTGOING_TYPE = "Outgoing";
    Label nameLabel;
    Label uidLabel;
    Label typeLabel;
    Label descriptionLabel;
    Text nameText;
    Text uidText;
    Text descriptionText;
    CCombo typeCombo;
    private AbstractFormPart masterPart;

    public MessageDetailsSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit, int style) {
        super(parentPart, parent, toolkit, style);
    }

    public void setMessageMasterPart(AbstractFormPart masterPart) {
        this.masterPart = masterPart;
    }

    public boolean setFormInput(Object input) {
        if (input instanceof MessageInput) {
            this.input = (MessageInput)input;
            this.markStale();
            return true;
        }
        return false;
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        Message message = this.getMessage();
        if (message != null) {
            message.setName(this.nameText.getText());
            message.setProtocol(null);
            message.setDescription(this.descriptionText.getText());
            if (this.masterPart != null) {
                this.masterPart.markStale();
            }
        }
    }

    protected void createSectionClientControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.nameLabel = toolkit.createLabel(this.sectionClient, "Name: ");
        this.nameText = toolkit.createText(this.sectionClient, "");
        this.nameText.setTextLimit(50);
        this.nameText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.nameText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.uidLabel = toolkit.createLabel(this.sectionClient, "UID: ");
        this.uidText = toolkit.createText(this.sectionClient, "", 8);
        this.uidText.setTextLimit(10);
        this.uidText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.uidText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.typeLabel = toolkit.createLabel(this.sectionClient, "Type: ");
        int style = 8 | toolkit.getBorderStyle();
        this.typeCombo = new CCombo(this.sectionClient, style);
        toolkit.adapt((Control)this.typeCombo, true, true);
        this.typeCombo.setEnabled(false);
        this.typeCombo.add(INCOMING_TYPE, 0);
        this.typeCombo.add(OUTGOING_TYPE, 1);
        this.descriptionLabel = toolkit.createLabel(this.sectionClient, "Description: ");
        this.descriptionText = toolkit.createText(this.sectionClient, "", 770);
        this.descriptionText.setTextLimit(256);
        this.descriptionText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
    }

    protected void initializeSectionClientLayout(IManagedForm managedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        this.nameLabel.setLayoutData((Object)this.createLabelGridData());
        this.uidLabel.setLayoutData((Object)this.createLabelGridData());
        this.typeLabel.setLayoutData((Object)this.createLabelGridData());
        this.descriptionLabel.setLayoutData((Object)this.createLabelGridData());
        this.uidText.setLayoutData((Object)this.createGridData());
        this.typeCombo.setLayoutData((Object)this.createGridData());
        GridData layoutData = this.createGridData();
        layoutData.widthHint = 150;
        this.nameText.setLayoutData((Object)layoutData);
        layoutData = this.createGridData();
        layoutData.widthHint = 200;
        layoutData.heightHint = 60;
        this.descriptionText.setLayoutData((Object)layoutData);
    }

    protected void populateSectionData() {
        Message message = this.getMessage();
        if (message != null) {
            this.nameText.setText(this.formatValue(message.getName(), true));
            this.uidText.setText(this.formatValue(message.getUid(), true));
            this.typeCombo.setText(message.isIncoming() ? INCOMING_TYPE : OUTGOING_TYPE);
            this.descriptionText.setText(this.formatValue(message.getDescription(), false));
        } else {
            this.nameText.setText("");
            this.uidText.setText("");
            this.typeCombo.setText("");
            this.descriptionText.setText("");
        }
    }

    protected void setWidgetPermissions() {
        boolean editable = this.isInputEditable();
        this.nameText.setEditable(editable);
        this.descriptionText.setEditable(editable);
    }
}

