/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.MessageInput;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.MessageWizard;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MessageMasterSectionPart
extends ResourceTypeSectionPart {
    private static final int MESSAGE_UID_INDEX = 0;
    private static final int MESSAGE_NAME_INDEX = 1;
    TableViewer messagesTableViewer;
    Table messagesTable;
    TableColumn nameColumn;
    TableColumn uidColumn;
    Composite buttonComposite;
    Button createButton;
    Button deleteButton;
    Label createInfoLabel;
    Label infoLabel;

    public MessageMasterSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit, int style) {
        super(parentPart, parent, toolkit, style);
    }

    protected void createSectionClientControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.initializeMessagesTable(managedForm);
        this.buttonComposite = toolkit.createComposite(this.sectionClient);
        toolkit.paintBordersFor(this.buttonComposite);
        this.createButton = toolkit.createButton(this.buttonComposite, "Create...", 8);
        this.deleteButton = toolkit.createButton(this.buttonComposite, "Delete", 8);
        this.createButton.addSelectionListener((SelectionListener)new ButtonPressListener());
        this.deleteButton.addSelectionListener((SelectionListener)new ButtonPressListener());
        String createInfoText = "* Messages cannot be created if no Adaptor Configuration is saved.";
        this.createInfoLabel = toolkit.createLabel(this.sectionClient, createInfoText, 64);
        String infoText = "* Messages that are created or deleted are instantly saved, and do not require saving the Resource Type.";
        this.infoLabel = toolkit.createLabel(this.sectionClient, infoText, 64);
    }

    private void initializeMessagesTable(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        int style = 66308;
        this.messagesTable = toolkit.createTable(this.sectionClient, style);
        toolkit.paintBordersFor((Composite)this.messagesTable);
        this.uidColumn = new TableColumn(this.messagesTable, 16384, 0);
        this.uidColumn.setText("Message UID");
        this.uidColumn.setToolTipText("Message UID");
        this.uidColumn.setResizable(true);
        this.uidColumn.setMoveable(false);
        this.uidColumn.setWidth(110);
        this.nameColumn = new TableColumn(this.messagesTable, 16384, 1);
        this.nameColumn.setText("Message Name");
        this.nameColumn.setToolTipText("Message Name");
        this.nameColumn.setResizable(true);
        this.nameColumn.setMoveable(false);
        this.nameColumn.setWidth(220);
        this.messagesTable.setHeaderVisible(true);
        this.messagesTable.setSortColumn(this.nameColumn);
        this.messagesTable.setSortDirection(1024);
        this.messagesTable.setTopIndex(0);
        this.messagesTable.setLinesVisible(true);
        this.messagesTableViewer = new TableViewer(this.messagesTable);
        this.messagesTableViewer.setLabelProvider((IBaseLabelProvider)new MessageLabelProvider());
        this.messagesTableViewer.setContentProvider((IContentProvider)new MessageContentProvider());
        this.messagesTableViewer.addSelectionChangedListener((ISelectionChangedListener)new MessageSelectionChangedListener());
        this.messagesTableViewer.setComparator(new ViewerComparator());
    }

    protected void initializeSectionClientLayout(IManagedForm managedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 150;
        this.messagesTable.setLayoutData((Object)gridData);
        this.buttonComposite.setLayoutData((Object)this.createGridData());
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        rowLayout.pack = false;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.spacing = 5;
        this.buttonComposite.setLayout((Layout)rowLayout);
        this.createButton.setLayoutData((Object)new RowData());
        this.deleteButton.setLayoutData((Object)new RowData());
        int labelWidth = this.messagesTable.getSize().x + this.buttonComposite.getSize().x;
        gridData = new GridData(4, 1, true, false);
        gridData.widthHint = labelWidth;
        gridData.horizontalSpan = 2;
        this.createInfoLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 1, true, false);
        gridData.widthHint = labelWidth;
        gridData.horizontalSpan = 2;
        this.infoLabel.setLayoutData((Object)gridData);
    }

    protected void populateSectionData() {
        this.messagesTableViewer.setInput((Object)this.input);
        ISelection selection = this.messagesTableViewer.getSelection();
        if (!selection.isEmpty()) {
            this.getManagedForm().fireSelectionChanged((IFormPart)this, selection);
        }
    }

    protected void setWidgetPermissions() {
        boolean isEditable = this.isInputEditable();
        this.createButton.setEnabled(isEditable);
        this.deleteButton.setEnabled(isEditable);
        this.updateButtonStatus();
    }

    private void updateButtonStatus() {
        if (!this.isInputEditable()) {
            return;
        }
        this.createButton.setEnabled(this.isCreateAllowed());
        this.deleteButton.setEnabled(this.isDeleteAllowed());
    }

    private boolean isCreateAllowed() {
        if (!this.isInputEditable()) {
            return false;
        }
        ResourceTypeEditorInput adapter = null;
        AdaptorType adaptorType = null;
        adapter = (ResourceTypeEditorInput)this.input.getAdapter(ResourceTypeEditorInput.class);
        if (adapter != null) {
            adaptorType = adapter.getPersistedResourceType().getAdaptorType();
        }
        return adaptorType != null && adaptorType != AdaptorType.NONE;
    }

    private boolean isDeleteAllowed() {
        if (!this.isInputEditable()) {
            return false;
        }
        IStructuredSelection selection = this.getTableSelection();
        Object selectedObject = selection.getFirstElement();
        return selectedObject != null;
    }

    private IStructuredSelection getTableSelection() {
        ISelection selection = this.messagesTableViewer.getSelection();
        return (IStructuredSelection)selection;
    }

    private void createNewMessage() {
        if (!this.isCreateAllowed()) {
            this.updateButtonStatus();
            return;
        }
        ResourceTypeEditorInput adapter = null;
        adapter = (ResourceTypeEditorInput)this.input.getAdapter(ResourceTypeEditorInput.class);
        if (adapter == null || adapter.getPersistedResourceType() == null) {
            return;
        }
        Shell shell = this.getSection().getShell();
        long resourceTypeId = adapter.getPersistedResourceType().getId();
        MessageWizard messageWizard = new MessageWizard(resourceTypeId);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)messageWizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Message message = messageWizard.getMessage();
            adapter.addCreatedMessage(message);
            this.markStale();
        }
    }

    private void deleteSelectedMessage() {
        if (!this.isDeleteAllowed()) {
            this.updateButtonStatus();
            return;
        }
        ResourceTypeEditorInput adapter = null;
        adapter = (ResourceTypeEditorInput)this.input.getAdapter(ResourceTypeEditorInput.class);
        if (adapter == null || adapter.getPersistedResourceType() == null) {
            return;
        }
        IStructuredSelection selection = this.getTableSelection();
        Object selectedObject = selection.getFirstElement();
        if (selectedObject instanceof MessageInput) {
            MessageInput messageInput = (MessageInput)selectedObject;
            Message message = messageInput.getMessage();
            try {
                ServiceFactory factory = ServiceFactory.createFactory();
                IResourceTypeService resourceTypeService = factory.createResourceTypeService();
                resourceTypeService.deleteMessage(message.getId());
                adapter.removeDeletedMessage(message);
                this.markStale();
            }
            catch (Exception ex) {
                Utility.reportError("Error while deleting the selected Message.", ex);
                return;
            }
        }
    }

    private class ButtonPressListener
    extends SelectionAdapter {
        private ButtonPressListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.getSource() == MessageMasterSectionPart.this.createButton) {
                MessageMasterSectionPart.this.createNewMessage();
            } else if (event.getSource() == MessageMasterSectionPart.this.deleteButton) {
                MessageMasterSectionPart.this.deleteSelectedMessage();
            }
        }
    }

    private class MessageContentProvider
    implements IStructuredContentProvider {
        private MessageContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = null;
            if (inputElement instanceof ResourceTypeEditorInput) {
                Set<Message> messages;
                ResourceTypeEditorInput input = (ResourceTypeEditorInput)inputElement;
                ResourceType resourceType = input.getResourceType();
                boolean isEditable = input.canEdit();
                Set<Message> set = messages = resourceType != null ? resourceType.getMessages() : null;
                if (messages != null) {
                    elements = new Object[messages.size()];
                    int counter = 0;
                    for (Message message : messages) {
                        elements[counter++] = new MessageInput(message, isEditable);
                    }
                }
            } else {
                elements = new Object[]{};
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class MessageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MessageLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof MessageInput)) {
                return null;
            }
            MessageInput input = (MessageInput)element;
            Message message = input.getMessage();
            if (message == null) {
                return null;
            }
            String label = "";
            switch (columnIndex) {
                case 0: {
                    label = message.getUid();
                    break;
                }
                case 1: {
                    label = message.getName();
                }
            }
            if (label != null) {
                label = label.trim();
            }
            return label;
        }

        public String getText(Object element) {
            if (!(element instanceof MessageInput)) {
                return null;
            }
            MessageInput input = (MessageInput)element;
            Message message = input.getMessage();
            if (message == null) {
                return null;
            }
            return message.getName();
        }
    }

    private class MessageSelectionChangedListener
    implements ISelectionChangedListener {
        private MessageSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            IManagedForm managedForm = MessageMasterSectionPart.this.getManagedForm();
            MessageMasterSectionPart.this.updateButtonStatus();
            managedForm.fireSelectionChanged((IFormPart)MessageMasterSectionPart.this, selection);
        }
    }
}

